/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.cache;

import org.aoju.bus.cache.Context;
import org.aoju.bus.cache.Hitting;
import org.aoju.bus.cache.provider.H2Hitting;
import org.aoju.bus.cache.provider.MemoryHitting;
import org.aoju.bus.cache.provider.MySQLHitting;
import org.aoju.bus.cache.provider.SqliteHitting;
import org.aoju.bus.cache.provider.ZookeeperHitting;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.starter.cache.AspectjCacheProxy;
import org.aoju.bus.starter.cache.CacheProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={CacheProperties.class})
public class CacheConfiguration {
    @Autowired
    CacheProperties properties;

    @Bean
    public AspectjCacheProxy cacheConfigurer() {
        String type = StringKit.toString((CharSequence)this.properties.getType());
        try {
            if (!StringKit.isEmpty((CharSequence)type)) {
                Class provider = ClassKit.loadClass((String)type);
                Context config = Context.newConfig(this.properties.getMap());
                if (provider instanceof H2Hitting) {
                    config.setHitting((Hitting)new H2Hitting(this.properties.getProvider().getUrl(), this.properties.getProvider().getUsername(), this.properties.getProvider().getPassword()));
                } else if (provider instanceof MySQLHitting) {
                    config.setHitting((Hitting)new MySQLHitting(BeanKit.beanToMap((Object)this.properties)));
                } else if (provider instanceof SqliteHitting) {
                    config.setHitting((Hitting)new SqliteHitting(this.properties.getProvider().getUrl(), this.properties.getProvider().getUsername(), this.properties.getProvider().getPassword()));
                } else if (provider instanceof ZookeeperHitting) {
                    config.setHitting((Hitting)new ZookeeperHitting(this.properties.getProvider().getUrl()));
                } else if (provider instanceof MemoryHitting) {
                    config.setHitting((Hitting)new MemoryHitting());
                }
                return new AspectjCacheProxy(config);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can not resolve class with type: " + type);
        }
        return null;
    }
}

