/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.mapper;

import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.mapper.builder.MapperBuilder;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.session.Configuration;
import org.mybatis.spring.support.SqlSessionDaoSupport;
import org.springframework.beans.factory.FactoryBean;

public class MapperFactoryBean<T>
extends SqlSessionDaoSupport
implements FactoryBean<T> {
    private Class<T> mapperInterface;
    private boolean addToConfig = true;
    private MapperBuilder mapperBuilder;

    public MapperFactoryBean() {
    }

    public MapperFactoryBean(Class<T> mapperInterface) {
        this.mapperInterface = mapperInterface;
    }

    protected void checkDaoConfig() {
        super.checkDaoConfig();
        Assert.notNull(this.mapperInterface, (String)"Property 'mapperInterface' is required", (Object[])new Object[0]);
        Configuration configuration = this.getSqlSession().getConfiguration();
        if (this.addToConfig && !configuration.hasMapper(this.mapperInterface)) {
            try {
                configuration.addMapper(this.mapperInterface);
            }
            catch (Exception e) {
                Logger.error((String)("Error while adding the mapper '" + this.mapperInterface + "' to configuration."), (Object[])new Object[]{e});
                throw new IllegalArgumentException(e);
            }
            finally {
                ErrorContext.instance().reset();
            }
        }
        if (configuration.hasMapper(this.mapperInterface) && this.mapperBuilder != null && this.mapperBuilder.isExtendCommonMapper(this.mapperInterface)) {
            this.mapperBuilder.processConfiguration(this.getSqlSession().getConfiguration(), this.mapperInterface);
        }
    }

    public T getObject() {
        return (T)this.getSqlSession().getMapper(this.mapperInterface);
    }

    public Class<T> getObjectType() {
        return this.mapperInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<T> getMapperInterface() {
        return this.mapperInterface;
    }

    public void setMapperInterface(Class<T> mapperInterface) {
        this.mapperInterface = mapperInterface;
    }

    public boolean isAddToConfig() {
        return this.addToConfig;
    }

    public void setAddToConfig(boolean addToConfig) {
        this.addToConfig = addToConfig;
    }

    public void setMapperBuilder(MapperBuilder mapperBuilder) {
        this.mapperBuilder = mapperBuilder;
    }
}

