/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.cache;

import org.aoju.bus.cache.Aspectj;
import org.aoju.bus.cache.Context;
import org.aoju.bus.cache.Provider;
import org.aoju.bus.cache.provider.H2Provider;
import org.aoju.bus.cache.provider.MemoryProvider;
import org.aoju.bus.cache.provider.MySQLProvider;
import org.aoju.bus.cache.provider.SqliteProvider;
import org.aoju.bus.cache.provider.ZKProvider;
import org.aoju.bus.core.utils.BeanUtils;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.starter.cache.CacheProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={CacheProperties.class})
public class CacheConfiguration {
    @Autowired
    CacheProperties properties;

    @Bean
    public Aspectj cacheConfigurer() {
        String type = StringUtils.toString((Object)this.properties.getType());
        try {
            if (!StringUtils.isEmpty((Object)type)) {
                Class provider = ClassUtils.loadClass((String)type);
                Context config = Context.newConfig(this.properties.getMap());
                if (provider instanceof H2Provider) {
                    config.setProvider((Provider)new H2Provider(this.properties.getProvider().getUrl(), this.properties.getProvider().getUsername(), this.properties.getProvider().getPassword()));
                } else if (provider instanceof MySQLProvider) {
                    config.setProvider((Provider)new MySQLProvider(BeanUtils.beanToMap((Object)this.properties)));
                } else if (provider instanceof SqliteProvider) {
                    config.setProvider((Provider)new SqliteProvider(this.properties.getProvider().getUrl(), this.properties.getProvider().getUsername(), this.properties.getProvider().getPassword()));
                } else if (provider instanceof ZKProvider) {
                    config.setProvider((Provider)new ZKProvider(this.properties.getProvider().getUrl()));
                } else if (provider instanceof MemoryProvider) {
                    config.setProvider((Provider)new MemoryProvider());
                }
                return new Aspectj(config);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can not resolve class with type: " + type);
        }
        return null;
    }
}

