/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.banner;

import java.io.Closeable;
import java.io.InputStream;
import org.aoju.bus.core.utils.IoUtils;

public abstract class AbstractBanner {
    protected Class<?> resourceClass;
    protected String resourceLocation;
    protected String defaultBanner;
    protected String banner;

    public AbstractBanner(Class<?> resourceClass, String resourceLocation, String defaultBanner) {
        this.resourceClass = resourceClass;
        this.resourceLocation = resourceLocation;
        this.defaultBanner = defaultBanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        InputStream inputStream = null;
        String bannerText = null;
        try {
            if (this.resourceLocation != null) {
                inputStream = this.resourceClass.getResourceAsStream(this.resourceLocation);
                bannerText = IoUtils.toString((InputStream)inputStream, (String)"UTF-8");
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.banner = this.generateBanner(bannerText);
            if (inputStream != null) {
                IoUtils.close((Closeable)inputStream);
            }
        }
    }

    public String getBanner() {
        return this.banner;
    }

    public String getPlainBanner() {
        if (this.banner != null) {
            this.banner = this.banner.replaceAll("\u001b\\[[;\\d]*m", "");
        }
        return this.banner;
    }

    protected abstract String generateBanner(String var1);
}

