/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.sensitive;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.base.entity.Message;
import org.aoju.bus.base.entity.Result;
import org.aoju.bus.base.spring.BaseAdvice;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.ReflectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.sensitive.annotation.Privacy;
import org.aoju.bus.sensitive.annotation.Sensitive;
import org.aoju.bus.starter.sensitive.SensitiveProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;

public class ResponseBodyAdvice
extends BaseAdvice
implements org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice<Object> {
    @Autowired
    SensitiveProperties properties;

    private static <T> void setValue(T entity, String[] fields, Object[] value) {
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (!ReflectUtils.hasField(entity, (String)field)) continue;
            ReflectUtils.invokeSetter(entity, (String)field, (Object)value[i]);
        }
    }

    private static <T> Object getValue(T entity, String field) {
        if (ReflectUtils.hasField(entity, (String)field)) {
            Object object = ReflectUtils.invokeGetter(entity, (String)field);
            return object != null ? object.toString() : null;
        }
        return null;
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        Object[] annotations = returnType.getDeclaringClass().getAnnotations();
        if (ArrayUtils.isNotEmpty((Object[])annotations)) {
            for (Object annotation : annotations) {
                if (!(annotation instanceof Sensitive)) continue;
                return true;
            }
        }
        return returnType.getMethod().isAnnotationPresent(Sensitive.class);
    }

    public Object beforeBodyWrite(Object body, MethodParameter parameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> converterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (ObjectUtils.isNotEmpty((Object[])new Object[]{this.properties}) && !this.properties.isDebug()) {
            try {
                Sensitive sensitive = parameter.getMethod().getAnnotation(Sensitive.class);
                if (ObjectUtils.isEmpty((Object[])new Object[]{sensitive})) {
                    return body;
                }
                Object object = ((Message)body).getData();
                if (object instanceof Result) {
                    ArrayList list = new ArrayList();
                    for (Object obj : ((Result)object).getRows()) {
                        this.beforeBodyWrite(sensitive, obj);
                        list.add(obj);
                    }
                    ((Result)((Message)body).getData()).setRows(list);
                } else if (object instanceof List) {
                    ArrayList list = new ArrayList();
                    for (Object obj : (List)object) {
                        this.beforeBodyWrite(sensitive, obj);
                        list.add(obj);
                    }
                    ((Message)body).setData(list);
                } else {
                    this.beforeBodyWrite(sensitive, object);
                    ((Message)body).setData(object);
                }
            }
            catch (Exception e) {
                Logger.error((String)("Internal processing failure:" + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return body;
    }

    private void beforeBodyWrite(Sensitive sensitive, Object object) {
        if (ObjectUtils.isEmpty((Object[])new Object[0]) || ObjectUtils.isEmpty((Object[])new Object[]{object})) {
            return;
        }
        if (("ALL".equals(sensitive.value()) || "SENS".equals(sensitive.value())) && ("ALL".equals(sensitive.stage()) || "OUT".equals(sensitive.stage()))) {
            Logger.debug((String)"Response data sensitive enabled ...", (Object[])new Object[0]);
            org.aoju.bus.sensitive.Builder.on((Object)object, (Annotation)sensitive);
        }
        if ("ALL".equals(sensitive.value()) || "SAFE".equals(sensitive.value()) && ("ALL".equals(sensitive.stage()) || "OUT".equals(sensitive.stage()))) {
            Map<String, Privacy> map = this.getPrivacyMap(object.getClass());
            for (Map.Entry<String, Privacy> entry : map.entrySet()) {
                String property;
                String value;
                Privacy privacy = entry.getValue();
                if (!ObjectUtils.isNotEmpty((Object[])new Object[]{privacy}) || !StringUtils.isNotEmpty((String)privacy.value()) || !"ALL".equals(privacy.value()) && !"OUT".equals(privacy.value()) || !StringUtils.isNotEmpty((String)(value = (String)ResponseBodyAdvice.getValue(object, property = entry.getKey())))) continue;
                if (ObjectUtils.isEmpty((Object[])new Object[]{this.properties})) {
                    throw new InstrumentException("Please check the request.crypto.encrypt");
                }
                Logger.debug((String)"Response data encryption enabled ...", (Object[])new Object[0]);
                value = Builder.encrypt((String)this.properties.getEncrypt().getType(), (String)this.properties.getEncrypt().getKey(), (String)value, (java.nio.charset.Charset)Charset.UTF_8);
                ResponseBodyAdvice.setValue(object, new String[]{property}, new String[]{value});
            }
        }
    }

    private Map<String, Privacy> getPrivacyMap(Class<?> clazz) {
        HashMap<String, Privacy> map = new HashMap<String, Privacy>();
        for (Field field : clazz.getDeclaredFields()) {
            Privacy privacy = field.getAnnotation(Privacy.class);
            if (privacy == null) continue;
            map.put(field.getName(), privacy);
        }
        return map;
    }
}

