/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.wrapper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CacheResponseWrapper
extends HttpServletResponseWrapper {
    private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private PrintWriter writer = new PrintWriter(this.byteArrayOutputStream);

    CacheResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public PrintWriter getWriter() throws IOException {
        return new ServletPrintWriter(super.getWriter(), this.writer);
    }

    public byte[] getBody() {
        return this.byteArrayOutputStream.toByteArray();
    }

    public ServletOutputStream getOutputStream() {
        return new ServletOutputStream(){

            public boolean isReady() {
                return false;
            }

            public void setWriteListener(WriteListener writeListener) {
            }

            public void write(int b) throws IOException {
                TeeOutputStream write = new TeeOutputStream((OutputStream)CacheResponseWrapper.super.getOutputStream(), CacheResponseWrapper.this.byteArrayOutputStream);
                write.write(b);
            }
        };
    }

    class TeeOutputStream
    extends OutputStream {
        private OutputStream oneOut;
        private OutputStream twoOut;

        public TeeOutputStream(OutputStream oneOut, OutputStream twoOut) {
            this.oneOut = oneOut;
            this.twoOut = twoOut;
        }

        @Override
        public void write(byte[] buf) throws IOException {
            this.oneOut.write(buf);
            this.twoOut.write(buf);
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            this.oneOut.write(buf, off, len);
            this.twoOut.write(buf, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.oneOut.write(b);
            this.twoOut.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.oneOut.flush();
            this.twoOut.flush();
        }

        @Override
        public void close() throws IOException {
            this.oneOut.close();
            this.twoOut.close();
        }
    }

    private static class ServletPrintWriter
    extends PrintWriter {
        PrintWriter printWriter;

        ServletPrintWriter(PrintWriter main, PrintWriter printWriter) {
            super((Writer)main, true);
            this.printWriter = printWriter;
        }

        @Override
        public void write(char[] buff, int off, int len) {
            super.write(buff, off, len);
            super.flush();
            this.printWriter.write(buff, off, len);
            this.printWriter.flush();
        }

        @Override
        public void write(String s, int off, int len) {
            super.write(s, off, len);
            super.flush();
            this.printWriter.write(s, off, len);
            this.printWriter.flush();
        }

        @Override
        public void write(int c) {
            super.write(c);
            super.flush();
            this.printWriter.write(c);
            this.printWriter.flush();
        }

        @Override
        public void flush() {
            super.flush();
            this.printWriter.flush();
        }
    }
}

