/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.wrapper;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aoju.bus.core.lang.Ansi;
import org.aoju.bus.health.HealthUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.starter.wrapper.CacheRequestWrapper;
import org.aoju.bus.starter.wrapper.CacheResponseWrapper;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Component
public class GenieWrapperHandler
implements HandlerInterceptor {
    private static void isHandle(String method, String url) {
        switch (method) {
            case "ALL": {
                method = Ansi.BgBlack.and(Ansi.White).format(" %s ", new Object[]{method});
                break;
            }
            case "GET": {
                method = Ansi.BgGreen.and(Ansi.Black).format(" %s ", new Object[]{method});
                break;
            }
            case "POST": {
                method = Ansi.BgBlue.and(Ansi.Black).format(" %s ", new Object[]{method});
                break;
            }
            case "DELETE": {
                method = Ansi.BgRed.and(Ansi.Black).format(" %s ", new Object[]{method});
                break;
            }
            case "PUT": {
                method = Ansi.BgYellow.and(Ansi.Black).format(" %s ", new Object[]{method});
                break;
            }
            case "OPTIONS": {
                method = Ansi.BgCyan.and(Ansi.Black).format(" %s ", new Object[]{method});
                break;
            }
            case "BEFORE": {
                method = Ansi.BgMagenta.and(Ansi.Black).format(" %s ", new Object[]{method});
                break;
            }
            case "AFTER": {
                method = Ansi.BgWhite.and(Ansi.Black).format(" %s ", new Object[]{method});
            }
        }
        Logger.info((String)"{} {} {} {}", (Object[])new Object[]{Ansi.isWindows ? "" : "==>", HealthUtils.getHostInfo().getAddress(), method, url});
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String method = request.getMethod().toUpperCase();
        GenieWrapperHandler.isHandle(method, request.getRequestURL().toString());
        if (("GET".equals(method) || "POST".equals(method) || "PATCH".equals(method) || "PUT".equals(method)) && request instanceof CacheRequestWrapper) {
            CacheRequestWrapper cacheRequestWrapper = (CacheRequestWrapper)request;
            Logger.info((String)"==> {}", (Object[])new Object[]{new String(cacheRequestWrapper.getBody())});
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        String method = request.getMethod();
        if (("POST".equals(method) || "PATCH".equals(method) || "PUT".equals(method)) && response instanceof CacheResponseWrapper) {
            CacheResponseWrapper cacheResponseWrapper = (CacheResponseWrapper)response;
            Logger.info((String)"<== {}", (Object[])new Object[]{new String(cacheResponseWrapper.getBody())});
        }
    }

    @Bean
    WebMvcConfigurer enableGenieHandler() {
        return new WebMvcConfigurer(){

            public void addInterceptors(InterceptorRegistry registry) {
                registry.addInterceptor((HandlerInterceptor)new GenieWrapperHandler());
            }
        };
    }
}

