/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.gui;

import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.TreeAdaptor;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.debug.AddAttributeEvent;
import org.stringtemplate.v4.debug.DebugST;
import org.stringtemplate.v4.debug.EvalTemplateEvent;
import org.stringtemplate.v4.debug.InterpEvent;
import org.stringtemplate.v4.gui.JTreeASTModel;
import org.stringtemplate.v4.gui.JTreeSTModel;
import org.stringtemplate.v4.gui.STViewFrame;
import org.stringtemplate.v4.misc.ErrorManager;
import org.stringtemplate.v4.misc.Interval;
import org.stringtemplate.v4.misc.Misc;
import org.stringtemplate.v4.misc.STMessage;
import org.stringtemplate.v4.misc.STRuntimeMessage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STViz {
    public DebugST currentST;
    public List<InterpEvent> allEvents;
    public JTreeSTModel tmodel;
    public List<STMessage> errors;
    public ErrorManager errMgr;
    public Interpreter interp;

    public STViz(ErrorManager errMgr, DebugST root, String output, Interpreter interp, List<String> trace, List<STMessage> errors) {
        this.errMgr = errMgr;
        this.currentST = root;
        this.interp = interp;
        this.allEvents = interp.getEvents();
        this.errors = errors;
        final STViewFrame m = new STViewFrame();
        this.updateStack(this.currentST, m);
        this.updateAttributes(this.currentST, m);
        this.tmodel = new JTreeSTModel(interp, this.currentST);
        m.tree.setModel(this.tmodel);
        m.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                STViz.this.currentST = ((JTreeSTModel.Wrapper)m.tree.getLastSelectedPathComponent()).st;
                STViz.this.updateCurrentST(m);
            }
        });
        JTreeASTModel astModel = new JTreeASTModel((TreeAdaptor)new CommonTreeAdaptor(), this.currentST.impl.ast);
        m.ast.setModel(astModel);
        m.ast.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath path = treeSelectionEvent.getNewLeadSelectionPath();
                if (path == null) {
                    return;
                }
                CommonTree node = (CommonTree)treeSelectionEvent.getNewLeadSelectionPath().getLastPathComponent();
                System.out.println("select AST: " + node);
                CommonToken a = (CommonToken)STViz.this.currentST.impl.tokens.get(node.getTokenStartIndex());
                CommonToken b = (CommonToken)STViz.this.currentST.impl.tokens.get(node.getTokenStopIndex());
                STViz.this.highlight(m.template, a.getStartIndex(), b.getStopIndex());
            }
        });
        m.attributes.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int minIndex = m.attributes.getMinSelectionIndex();
                int maxIndex = m.attributes.getMaxSelectionIndex();
                for (int i = minIndex; i <= maxIndex; ++i) {
                    if (!m.attributes.isSelectedIndex(i)) continue;
                }
            }
        });
        m.output.setText(output);
        m.template.setText(this.currentST.impl.template);
        m.bytecode.setText(this.currentST.impl.disasm());
        m.trace.setText(Misc.join(trace.iterator(), "\n"));
        CaretListener caretListenerLabel = new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                int dot = e.getDot();
                InterpEvent de = STViz.this.findEventAtOutputLocation(STViz.this.allEvents, dot);
                STViz.this.currentST = de == null ? STViz.this.tmodel.root.st : de.self;
                STViz.this.updateCurrentST(m);
            }
        };
        m.output.addCaretListener(caretListenerLabel);
        m.setDefaultCloseOperation(2);
        m.pack();
        m.setSize(800, 600);
        m.topSplitPane.setBorder(null);
        m.overallSplitPane.setBorder(null);
        if (errors == null || errors.size() == 0) {
            m.errorScrollPane.setVisible(false);
        } else {
            DefaultListModel<STMessage> errorListModel = new DefaultListModel<STMessage>();
            for (STMessage msg : errors) {
                errorListModel.addElement(msg);
            }
            m.errorList.setModel(errorListModel);
        }
        m.errorList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int i;
                int minIndex = m.errorList.getMinSelectionIndex();
                int maxIndex = m.errorList.getMaxSelectionIndex();
                for (i = minIndex; i <= maxIndex && !m.errorList.isSelectedIndex(i); ++i) {
                }
                ListModel model = m.errorList.getModel();
                STMessage msg = (STMessage)model.getElementAt(i);
                if (msg instanceof STRuntimeMessage) {
                    STRuntimeMessage rmsg = (STRuntimeMessage)msg;
                    Interval I = rmsg.self.impl.sourceMap[rmsg.ip];
                    STViz.this.currentST = (DebugST)msg.self;
                    STViz.this.updateCurrentST(m);
                    if (I != null) {
                        STViz.this.highlight(m.template, I.a, I.b);
                    }
                }
            }
        });
        m.bottomSplitPane.setBorder(null);
        m.treeScrollPane.setPreferredSize(new Dimension(120, 400));
        m.bottomSplitPane.setPreferredSize(new Dimension(120, 200));
        m.setVisible(true);
    }

    private void updateCurrentST(STViewFrame m) {
        this.updateStack(this.currentST, m);
        this.updateAttributes(this.currentST, m);
        m.bytecode.setText(this.currentST.impl.disasm());
        JTreeASTModel astModel = new JTreeASTModel((TreeAdaptor)new CommonTreeAdaptor(), this.currentST.impl.ast);
        m.ast.setModel(astModel);
        List<ST> pathST = this.currentST.getEnclosingInstanceStack(true);
        Object[] path = new Object[pathST.size()];
        int j = 0;
        for (ST s : pathST) {
            path[j++] = new JTreeSTModel.Wrapper((DebugST)s);
        }
        m.tree.setSelectionPath(new TreePath(path));
        m.template.setText(this.currentST.impl.template);
        Interval r = this.currentST.impl.getTemplateRange();
        if (this.currentST.enclosingInstance != null) {
            int i = this.tmodel.getIndexOfChild((DebugST)this.currentST.enclosingInstance, this.currentST);
            InterpEvent e = this.interp.getEvents(this.currentST.enclosingInstance).get(i);
            if (e instanceof EvalTemplateEvent) {
                if (this.currentST.isAnonSubtemplate()) {
                    this.highlight(m.template, r.a, r.b);
                }
                this.highlight(m.output, e.outputStartChar, e.outputStopChar);
            }
        } else {
            this.highlight(m.output, r.a, r.b);
        }
    }

    protected void highlight(JTextComponent comp, int i, int j) {
        Highlighter highlighter = comp.getHighlighter();
        highlighter.removeAllHighlights();
        try {
            highlighter.addHighlight(i, j + 1, DefaultHighlighter.DefaultPainter);
        }
        catch (BadLocationException ble) {
            this.errMgr.internalError(this.tmodel.root.st, "bad highlight location", ble);
        }
    }

    protected void updateAttributes(DebugST st, STViewFrame m) {
        DefaultListModel<String> attrModel = new DefaultListModel<String>();
        Map<String, Object> attrs = st.getAttributes();
        if (attrs != null) {
            for (String a : attrs.keySet()) {
                if (st.addAttrEvents != null) {
                    List events = (List)st.addAttrEvents.get(a);
                    StringBuilder locations = new StringBuilder();
                    int i = 0;
                    if (events != null) {
                        for (AddAttributeEvent ae : events) {
                            if (i > 0) {
                                locations.append(", ");
                            }
                            locations.append(new StringBuffer().append(ae.getFileName()).append(":").append(ae.getLine()).toString());
                            ++i;
                        }
                    }
                    attrModel.addElement(new StringBuffer().append(a).append(" = ").append(attrs.get(a)).append(" @ ").append(locations.toString()).toString());
                    continue;
                }
                attrModel.addElement(new StringBuffer().append(a).append(" = ").append(attrs.get(a)).toString());
            }
        }
        m.attributes.setModel(attrModel);
    }

    protected void updateStack(DebugST st, STViewFrame m) {
        List<ST> stack = st.getEnclosingInstanceStack(true);
        m.setTitle(new StringBuffer().append("STViz - [").append(Misc.join(stack.iterator(), " ")).append("]").toString());
    }

    public InterpEvent findEventAtOutputLocation(List<InterpEvent> events, int charIndex) {
        for (InterpEvent e : events) {
            if (charIndex < e.outputStartChar || charIndex > e.outputStopChar) continue;
            return e;
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        if (args.length > 0 && args[0].equals("1")) {
            STViz.test1();
        } else if (args.length > 0 && args[0].equals("2")) {
            STViz.test2();
        } else {
            STViz.test3();
        }
    }

    public static void test1() throws IOException {
        String templates = "method(type,name,locals,args,stats) ::= <<\npublic <type> <name>(<args:{a| int <a>}; separator=\", \">) {\n    <if(locals)>int locals[<locals>];<endif>\n    <stats;separator=\"\\n\">\n}\n>>\nassign(a,b) ::= \"<a> = <b>;\"\nreturn(x) ::= <<return <x>;>>\nparen(x) ::= \"(<x>)\"\n";
        String tmpdir = System.getProperty("java.io.tmpdir");
        STViz.writeFile(tmpdir, "t.stg", templates);
        STGroupFile group = new STGroupFile(new StringBuffer().append(tmpdir).append("/").append("t.stg").toString());
        STGroup.debug = true;
        ST st = group.getInstanceOf("method");
        st.impl.dump();
        st.add("type", "float");
        st.add("name", "foo");
        st.add("locals", new Integer(3));
        st.add("args", new String[]{"x", "y", "z"});
        ST s1 = group.getInstanceOf("assign");
        ST paren = group.getInstanceOf("paren");
        paren.add("x", "x");
        s1.add("a", paren);
        s1.add("b", "y");
        ST s2 = group.getInstanceOf("assign");
        s2.add("a", "y");
        s2.add("b", "z");
        ST s3 = group.getInstanceOf("return");
        s3.add("x", "3.14159");
        st.add("stats", s1);
        st.add("stats", s2);
        st.add("stats", s3);
        ((DebugST)st).inspect();
        System.out.println(st.render());
    }

    public static void test2() throws IOException {
        String templates = "t1(q1=\"Some\\nText\") ::= <<\n<q1>\n>>\n\nt2(p1) ::= <<\n<p1>\n>>\n\nmain() ::= <<\nSTART-<t1()>-END\n\nSTART-<t2(p1=\"Some\\nText\")>-END\n>>\n";
        String tmpdir = System.getProperty("java.io.tmpdir");
        STViz.writeFile(tmpdir, "t.stg", templates);
        STGroupFile group = new STGroupFile(new StringBuffer().append(tmpdir).append("/").append("t.stg").toString());
        STGroup.debug = true;
        ST st = group.getInstanceOf("main");
        ((DebugST)st).inspect();
    }

    public static void test3() throws IOException {
        String templates = "main() ::= <<\nFoo: <{bar};format=\"lower\">\n>>\n";
        String tmpdir = System.getProperty("java.io.tmpdir");
        STViz.writeFile(tmpdir, "t.stg", templates);
        STGroupFile group = new STGroupFile(new StringBuffer().append(tmpdir).append("/").append("t.stg").toString());
        STGroup.debug = true;
        ST st = group.getInstanceOf("main");
        ((DebugST)st).inspect();
    }

    public static void writeFile(String dir, String fileName, String content) {
        try {
            File f = new File(dir, fileName);
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            FileWriter w = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(w);
            bw.write(content);
            bw.close();
            w.close();
        }
        catch (IOException ioe) {
            System.err.println("can't write file");
            ioe.printStackTrace(System.err);
        }
    }
}

