/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ModelAdaptor;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroupDir;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.compiler.Compiler;
import org.stringtemplate.v4.compiler.FormalArgument;
import org.stringtemplate.v4.compiler.GroupLexer;
import org.stringtemplate.v4.compiler.GroupParser;
import org.stringtemplate.v4.compiler.STException;
import org.stringtemplate.v4.debug.DebugST;
import org.stringtemplate.v4.misc.ErrorManager;
import org.stringtemplate.v4.misc.ErrorType;
import org.stringtemplate.v4.misc.MapModelAdaptor;
import org.stringtemplate.v4.misc.Misc;
import org.stringtemplate.v4.misc.ObjectModelAdaptor;
import org.stringtemplate.v4.misc.STModelAdaptor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STGroup {
    public static final String DICT_KEY = "key";
    public static final String DEFAULT_KEY = "default";
    public String encoding = "UTF-8";
    protected List<STGroup> imports;
    public char delimiterStartChar = (char)60;
    public char delimiterStopChar = (char)62;
    protected Map<String, CompiledST> templates = Collections.synchronizedMap(new LinkedHashMap());
    protected Map<String, Map<String, Object>> dictionaries = Collections.synchronizedMap(new HashMap());
    protected Map<Class, AttributeRenderer> renderers;
    protected Map<Class, ModelAdaptor> adaptors = Collections.synchronizedMap(new LinkedHashMap<Class, ModelAdaptor>(){
        {
            this.put(class$java$lang$Object == null ? (class$java$lang$Object = STGroup.class$("java.lang.Object")) : class$java$lang$Object, new ObjectModelAdaptor());
            this.put(class$org$stringtemplate$v4$ST == null ? (class$org$stringtemplate$v4$ST = STGroup.class$("org.stringtemplate.v4.ST")) : class$org$stringtemplate$v4$ST, new STModelAdaptor());
            this.put(class$java$util$Map == null ? (class$java$util$Map = STGroup.class$("java.util.Map")) : class$java$util$Map, new MapModelAdaptor());
        }
    });
    protected Map<Class, ModelAdaptor> typeToAdaptorCache = Collections.synchronizedMap(new LinkedHashMap());
    protected Map<Class, AttributeRenderer> typeToRendererCache;
    protected static final CompiledST NOT_FOUND_ST = new CompiledST();
    public static final ErrorManager DEFAULT_ERR_MGR = new ErrorManager();
    public static boolean debug = false;
    public static boolean verbose = false;
    public static STGroup defaultGroup = new STGroup();
    public ErrorManager errMgr = DEFAULT_ERR_MGR;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$stringtemplate$v4$ST;
    static /* synthetic */ Class class$java$util$Map;

    public STGroup() {
    }

    public STGroup(char delimiterStartChar, char delimiterStopChar) {
        this.delimiterStartChar = delimiterStartChar;
        this.delimiterStopChar = delimiterStopChar;
    }

    public ST getInstanceOf(String name) {
        if (verbose) {
            System.out.println(new StringBuffer().append("getInstanceOf(").append(name).append(") in group ").append(this.getName()).toString());
        }
        if (name == null) {
            return null;
        }
        CompiledST c = this.lookupTemplate(name);
        if (c != null) {
            ST instanceST = this.createStringTemplate();
            instanceST.groupThatCreatedThisInstance = this;
            instanceST.impl = c;
            if (instanceST.impl.formalArguments != null) {
                instanceST.locals = new Object[instanceST.impl.formalArguments.size()];
                Arrays.fill(instanceST.locals, ST.EMPTY_ATTR);
            }
            return instanceST;
        }
        return null;
    }

    protected ST getEmbeddedInstanceOf(ST enclosingInstance, int ip, String name) {
        ST st = this.getInstanceOf(name);
        if (st == null) {
            this.errMgr.runTimeError(enclosingInstance, ip, ErrorType.NO_SUCH_TEMPLATE, name);
            st = this.createStringTemplate();
            st.impl = new CompiledST();
            return st;
        }
        st.enclosingInstance = enclosingInstance;
        return st;
    }

    public ST createSingleton(Token templateToken) {
        String template = templateToken.getType() == 8 ? Misc.strip(templateToken.getText(), 2) : Misc.strip(templateToken.getText(), 1);
        ST st = this.createStringTemplate();
        st.groupThatCreatedThisInstance = this;
        st.impl = this.compile(this.getFileName(), null, null, template, templateToken);
        st.impl.hasFormalArgs = false;
        st.impl.name = "anonymous";
        st.impl.defineImplicitlyDefinedTemplates(this);
        return st;
    }

    public boolean isDefined(String name) {
        return this.lookupTemplate(name) != null;
    }

    public CompiledST lookupTemplate(String name) {
        CompiledST code = this.rawGetTemplate(name);
        if (code == NOT_FOUND_ST) {
            if (verbose) {
                System.out.println(new StringBuffer().append(name).append(" not found").toString());
            }
            return null;
        }
        if (code == null) {
            code = this.load(name);
        }
        if (code == null) {
            code = this.lookupImportedTemplate(name);
        }
        if (code == null) {
            if (verbose) {
                System.out.println(new StringBuffer().append(name).append(" not found").toString());
            }
            this.templates.put(name, NOT_FOUND_ST);
        }
        if (verbose && code != null) {
            System.out.println(new StringBuffer().append("found ").append(name).append(" in ").append(this.getName()).toString());
        }
        return code;
    }

    public synchronized void unload() {
        this.templates.clear();
        this.dictionaries.clear();
    }

    protected CompiledST load(String name) {
        return null;
    }

    public void load() {
    }

    protected CompiledST lookupImportedTemplate(String name) {
        if (this.imports == null) {
            return null;
        }
        for (STGroup g : this.imports) {
            CompiledST code = g.lookupTemplate(name);
            if (code == null) continue;
            if (verbose) {
                System.out.println(new StringBuffer().append("found ").append(name).append(" in ").append(g.getName()).toString());
            }
            return code;
        }
        if (verbose) {
            System.out.println(new StringBuffer().append(name).append("not found in imports").toString());
        }
        return null;
    }

    public CompiledST rawGetTemplate(String name) {
        return this.templates.get(name);
    }

    public Map<String, Object> rawGetDictionary(String name) {
        return this.dictionaries.get(name);
    }

    public boolean isDictionary(String name) {
        return this.dictionaries.get(name) != null;
    }

    public CompiledST defineTemplate(String templateName, String template) {
        try {
            CompiledST impl = this.defineTemplate(templateName, (Token)new CommonToken(7, templateName), null, template, null);
            return impl;
        }
        catch (STException sTException) {
            return null;
        }
    }

    public CompiledST defineTemplate(String name, String argsS, String template) {
        String[] args = argsS.split(",");
        ArrayList<FormalArgument> a = new ArrayList<FormalArgument>();
        for (String arg : args) {
            a.add(new FormalArgument(arg));
        }
        return this.defineTemplate(name, (Token)new CommonToken(7, name), a, template, null);
    }

    public CompiledST defineTemplate(String templateName, Token nameT, List<FormalArgument> args, String template, Token templateToken) {
        if (templateName == null || templateName.length() == 0) {
            throw new IllegalArgumentException("empty template name");
        }
        if (templateName.indexOf(46) >= 0) {
            throw new IllegalArgumentException("cannot have '.' in template names");
        }
        template = Misc.trimOneStartingNewline(template);
        template = Misc.trimOneTrailingNewline(template);
        CompiledST code = this.compile(this.getFileName(), templateName, args, template, templateToken);
        code.name = templateName;
        this.rawDefineTemplate(templateName, code, nameT);
        code.defineArgDefaultValueTemplates(this);
        code.defineImplicitlyDefinedTemplates(this);
        return code;
    }

    public CompiledST defineTemplateAlias(Token aliasT, Token targetT) {
        String alias = aliasT.getText();
        String target = targetT.getText();
        CompiledST targetCode = this.rawGetTemplate(target);
        if (targetCode == null) {
            this.errMgr.compileTimeError(ErrorType.ALIAS_TARGET_UNDEFINED, null, aliasT, alias, target);
            return null;
        }
        this.templates.put(alias, targetCode);
        return targetCode;
    }

    public CompiledST defineRegion(String enclosingTemplateName, Token regionT, String template, Token templateToken) {
        String name = regionT.getText();
        template = Misc.trimOneStartingNewline(template);
        template = Misc.trimOneTrailingNewline(template);
        CompiledST code = this.compile(this.getFileName(), enclosingTemplateName, null, template, regionT);
        String mangled = STGroup.getMangledRegionName(enclosingTemplateName, name);
        if (this.lookupTemplate(mangled) == null) {
            this.errMgr.compileTimeError(ErrorType.NO_SUCH_REGION, templateToken, regionT, enclosingTemplateName, name);
            return new CompiledST();
        }
        code.name = mangled;
        code.isRegion = true;
        code.regionDefType = ST.RegionType.EXPLICIT;
        code.templateDefStartToken = regionT;
        this.rawDefineTemplate(mangled, code, regionT);
        code.defineArgDefaultValueTemplates(this);
        code.defineImplicitlyDefinedTemplates(this);
        return code;
    }

    public void defineTemplateOrRegion(String templateName, String regionSurroundingTemplateName, Token templateToken, String template, Token nameToken, List<FormalArgument> args) {
        try {
            if (regionSurroundingTemplateName != null) {
                this.defineRegion(regionSurroundingTemplateName, nameToken, template, templateToken);
            } else {
                this.defineTemplate(templateName, nameToken, args, template, templateToken);
            }
        }
        catch (STException e) {
            // empty catch block
        }
    }

    public void rawDefineTemplate(String name, CompiledST code, Token defT) {
        CompiledST prev = this.rawGetTemplate(name);
        if (prev != null) {
            if (!prev.isRegion) {
                this.errMgr.compileTimeError(ErrorType.TEMPLATE_REDEFINITION, null, defT);
                return;
            }
            if (prev.isRegion) {
                if (code.regionDefType != ST.RegionType.IMPLICIT && prev.regionDefType == ST.RegionType.EMBEDDED) {
                    this.errMgr.compileTimeError(ErrorType.EMBEDDED_REGION_REDEFINITION, null, defT, STGroup.getUnMangledTemplateName(name));
                    return;
                }
                if (code.regionDefType == ST.RegionType.IMPLICIT || prev.regionDefType == ST.RegionType.EXPLICIT) {
                    this.errMgr.compileTimeError(ErrorType.REGION_REDEFINITION, null, defT, STGroup.getUnMangledTemplateName(name));
                    return;
                }
            }
        }
        code.nativeGroup = this;
        code.templateDefStartToken = defT;
        this.templates.put(name, code);
    }

    public void undefineTemplate(String name) {
        this.templates.remove(name);
    }

    public CompiledST compile(String srcName, String name, List<FormalArgument> args, String template, Token templateToken) {
        Compiler c = new Compiler(this);
        return c.compile(srcName, name, args, template, templateToken);
    }

    public static String getMangledRegionName(String enclosingTemplateName, String name) {
        return new StringBuffer().append("region__").append(enclosingTemplateName).append("__").append(name).toString();
    }

    public static String getUnMangledTemplateName(String mangledName) {
        String t = mangledName.substring("region__".length(), mangledName.lastIndexOf("__"));
        String r = mangledName.substring(mangledName.lastIndexOf("__") + 2, mangledName.length());
        return new StringBuffer().append(t).append('.').append(r).toString();
    }

    public void defineDictionary(String name, Map<String, Object> mapping) {
        this.dictionaries.put(name, mapping);
    }

    public void importTemplates(STGroup g) {
        if (g == null) {
            return;
        }
        if (this.imports == null) {
            this.imports = Collections.synchronizedList(new ArrayList());
        }
        this.imports.add(g);
    }

    public void importTemplates(Token fileNameToken) {
        String fileName = fileNameToken.getText();
        if (fileName == null || fileName.equals("<missing STRING>")) {
            return;
        }
        fileName = Misc.strip(fileName, 1);
        boolean isGroupFile = fileName.endsWith(".stg");
        boolean isTemplateFile = fileName.endsWith(".st");
        boolean isGroupDir = !isGroupFile && !isTemplateFile;
        STGroup g = null;
        File f = new File(fileName);
        if (f.isAbsolute()) {
            if (isTemplateFile) {
                g = new STGroup();
                g.setListener(this.getListener());
                g.loadAbsoluteTemplateFile(fileName);
            } else if (isGroupFile) {
                g = new STGroupFile(fileName, this.delimiterStartChar, this.delimiterStopChar);
                g.setListener(this.getListener());
            } else if (isGroupDir) {
                g = new STGroupDir(fileName, this.delimiterStartChar, this.delimiterStopChar);
                g.setListener(this.getListener());
            }
            this.importTemplates(g);
            return;
        }
        URL thisRoot = this.getRootDirURL();
        URL fileUnderRoot = null;
        try {
            fileUnderRoot = new URL(new StringBuffer().append(thisRoot).append("/").append(fileName).toString());
        }
        catch (MalformedURLException mfe) {
            this.errMgr.internalError(null, new StringBuffer().append("can't build URL for ").append(thisRoot).append("/").append(fileName).toString(), mfe);
            return;
        }
        if (isTemplateFile) {
            g = new STGroup();
            g.setListener(this.getListener());
            URL fileURL = Misc.urlExists(fileUnderRoot) ? fileUnderRoot : this.getURL(fileName);
            if (fileURL != null) {
                try {
                    InputStream s = fileURL.openStream();
                    ANTLRInputStream templateStream = new ANTLRInputStream(s);
                    templateStream.name = fileName;
                    CompiledST code = g.loadTemplateFile("", fileName, (CharStream)templateStream);
                    if (code == null) {
                        g = null;
                    }
                }
                catch (IOException ioe) {
                    this.errMgr.internalError(null, new StringBuffer().append("can't read from ").append(fileURL).toString(), ioe);
                    g = null;
                }
            } else {
                g = null;
            }
        } else if (isGroupFile) {
            if (Misc.urlExists(fileUnderRoot)) {
                g = new STGroupFile(fileUnderRoot, this.encoding, this.delimiterStartChar, this.delimiterStopChar);
                g.setListener(this.getListener());
            } else {
                g = new STGroupFile(fileName, this.delimiterStartChar, this.delimiterStopChar);
                g.setListener(this.getListener());
            }
        } else if (isGroupDir) {
            if (Misc.urlExists(fileUnderRoot)) {
                g = new STGroupDir(fileUnderRoot, this.encoding, this.delimiterStartChar, this.delimiterStopChar);
                g.setListener(this.getListener());
            } else {
                g = new STGroupDir(fileName, this.delimiterStartChar, this.delimiterStopChar);
                g.setListener(this.getListener());
            }
        }
        if (g == null) {
            this.errMgr.compileTimeError(ErrorType.CANT_IMPORT, null, fileNameToken, fileName);
        } else {
            this.importTemplates(g);
        }
    }

    public void loadGroupFile(String prefix, String fileName) {
        GroupParser parser = null;
        try {
            URL f = new URL(fileName);
            ANTLRInputStream fs = new ANTLRInputStream(f.openStream(), this.encoding);
            GroupLexer lexer = new GroupLexer((CharStream)fs);
            fs.name = fileName;
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            parser = new GroupParser((TokenStream)tokens);
            parser.group(this, prefix);
        }
        catch (Exception e) {
            this.errMgr.IOError(null, ErrorType.CANT_LOAD_GROUP_FILE, e, fileName);
        }
    }

    public CompiledST loadAbsoluteTemplateFile(String fileName) {
        ANTLRFileStream fs;
        try {
            fs = new ANTLRFileStream(fileName, this.encoding);
            fs.name = fileName;
        }
        catch (IOException ioe) {
            return null;
        }
        return this.loadTemplateFile("", fileName, (CharStream)fs);
    }

    public CompiledST loadTemplateFile(String prefix, String fileName, CharStream templateStream) {
        GroupLexer lexer = new GroupLexer(templateStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        GroupParser parser = new GroupParser((TokenStream)tokens);
        parser.group = this;
        lexer.group = this;
        try {
            parser.templateDef(prefix);
        }
        catch (RecognitionException re) {
            this.errMgr.groupSyntaxError(ErrorType.SYNTAX_ERROR, fileName, re, re.getMessage());
        }
        String templateName = Misc.getFileNameNoSuffix(fileName);
        if (prefix != null && prefix.length() > 0) {
            templateName = new StringBuffer().append(prefix).append("/").append(templateName).toString();
        }
        return this.rawGetTemplate(templateName);
    }

    public void registerModelAdaptor(Class attributeType, ModelAdaptor adaptor) {
        if (attributeType.isPrimitive()) {
            throw new IllegalArgumentException(new StringBuffer().append("can't register ModelAdaptor for primitive type ").append(attributeType.getSimpleName()).toString());
        }
        this.adaptors.put(attributeType, adaptor);
        this.invalidateModelAdaptorCache(attributeType);
    }

    public void invalidateModelAdaptorCache(Class attributeType) {
        this.typeToAdaptorCache.clear();
    }

    public ModelAdaptor getModelAdaptor(Class attributeType) {
        ModelAdaptor a = this.typeToAdaptorCache.get(attributeType);
        if (a != null) {
            return a;
        }
        for (Class t : this.adaptors.keySet()) {
            if (!t.isAssignableFrom(attributeType)) continue;
            a = this.adaptors.get(t);
        }
        this.typeToAdaptorCache.put(attributeType, a);
        return a;
    }

    public void registerRenderer(Class attributeType, AttributeRenderer r) {
        if (attributeType.isPrimitive()) {
            throw new IllegalArgumentException(new StringBuffer().append("can't register renderer for primitive type ").append(attributeType.getSimpleName()).toString());
        }
        this.typeToAdaptorCache.clear();
        if (this.renderers == null) {
            this.renderers = Collections.synchronizedMap(new LinkedHashMap());
        }
        this.renderers.put(attributeType, r);
    }

    public AttributeRenderer getAttributeRenderer(Class attributeType) {
        if (this.renderers == null) {
            return null;
        }
        AttributeRenderer r = null;
        if (this.typeToRendererCache != null && (r = this.typeToRendererCache.get(attributeType)) != null) {
            return r;
        }
        for (Class t : this.renderers.keySet()) {
            if (!t.isAssignableFrom(attributeType)) continue;
            r = this.renderers.get(t);
            if (this.typeToRendererCache == null) {
                this.typeToRendererCache = Collections.synchronizedMap(new LinkedHashMap());
            }
            this.typeToRendererCache.put(attributeType, r);
            return r;
        }
        return null;
    }

    public ST createStringTemplate() {
        if (debug) {
            return new DebugST();
        }
        return new ST();
    }

    public ST createStringTemplate(ST proto) {
        if (debug) {
            return new DebugST(proto);
        }
        return new ST(proto);
    }

    public String getName() {
        return "<no name>;";
    }

    public String getFileName() {
        return null;
    }

    public URL getRootDirURL() {
        return null;
    }

    public URL getURL(String fileName) {
        URL url = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        url = cl.getResource(fileName);
        if (url == null) {
            cl = this.getClass().getClassLoader();
            url = cl.getResource(fileName);
        }
        return url;
    }

    public String toString() {
        return this.getName();
    }

    public String show() {
        StringBuilder buf = new StringBuilder();
        if (this.imports != null) {
            buf.append(new StringBuffer().append(" : ").append(this.imports).toString());
        }
        for (String name : this.templates.keySet()) {
            CompiledST c = this.rawGetTemplate(name);
            if (c.isAnonSubtemplate || c == NOT_FOUND_ST) continue;
            int slash = name.lastIndexOf(47);
            name = name.substring(slash + 1, name.length());
            buf.append(name);
            buf.append('(');
            if (c.formalArguments != null) {
                buf.append(Misc.join(c.formalArguments.values().iterator(), ","));
            }
            buf.append(')');
            buf.append(new StringBuffer().append(" ::= <<").append(Misc.newline).toString());
            buf.append(new StringBuffer().append(c.template).append(Misc.newline).toString());
            buf.append(new StringBuffer().append(">>").append(Misc.newline).toString());
        }
        return buf.toString();
    }

    public STErrorListener getListener() {
        return this.errMgr.listener;
    }

    public void setListener(STErrorListener listener) {
        this.errMgr = new ErrorManager(listener);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

