/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.antlr.gunit.Interp;
import org.antlr.gunit.gUnitTestInput;
import org.antlr.gunit.gUnitTestSuite;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;

public class gUnitExecuter {
    public Interp interpreter;
    protected String stderr;
    protected String stdout;
    protected boolean invalidInput;

    public gUnitExecuter(Interp interpreter) {
        this.interpreter = interpreter;
    }

    public void execTest() throws IOException {
        try {
            String title;
            String lexerName;
            String parserName;
            if (this.interpreter.header != null) {
                parserName = this.interpreter.header + "." + this.interpreter.grammarName + "Parser";
                lexerName = this.interpreter.header + "." + this.interpreter.grammarName + "Lexer";
            } else {
                parserName = this.interpreter.grammarName + "Parser";
                lexerName = this.interpreter.grammarName + "Lexer";
            }
            StringBuffer bufResult = new StringBuffer();
            StringBuffer bufInvalid = new StringBuffer();
            int numOfTest = 0;
            int numOfSuccess = 0;
            int numOfFailure = 0;
            int numOfInvalidInput = 0;
            if (this.interpreter.treeGrammarName != null) {
                title = "executing testsuite for tree grammar:" + this.interpreter.treeGrammarName + " walks " + parserName;
                for (gUnitTestSuite ts : this.interpreter.ruleTestSuites) {
                    for (gUnitTestInput input : ts.testSuites.keySet()) {
                        ++numOfTest;
                        Object result = this.runTreeParser(parserName, lexerName, ts.rule, ts.treeRule, input);
                        if (this.invalidInput) {
                            ++numOfInvalidInput;
                            bufInvalid.append("test" + numOfTest + " (" + ts.treeRule + " walks " + ts.rule + ")" + " - " + "\n");
                            bufInvalid.append("invalid input: " + input.testInput + "\n\n");
                        }
                        if (ts.testSuites.get(input).getType() == 27) {
                            if (this.stderr == null) {
                                ++numOfSuccess;
                                continue;
                            }
                            ++numOfFailure;
                            bufResult.append("test" + numOfTest + " (" + ts.treeRule + " walks " + ts.rule + ")" + " - " + "\n");
                            bufResult.append("expected: OK\n");
                            bufResult.append("actual: FAIL\n\n");
                            continue;
                        }
                        if (ts.testSuites.get(input).getType() == 28) {
                            if (this.stderr != null) {
                                ++numOfSuccess;
                                continue;
                            }
                            ++numOfFailure;
                            bufResult.append("test" + numOfTest + " (" + ts.treeRule + " walks " + ts.rule + ")" + " - " + "\n");
                            bufResult.append("expected: FAIL\n");
                            bufResult.append("actual: OK\n\n");
                            continue;
                        }
                        if (result == null) {
                            ++numOfFailure;
                            bufResult.append("test" + numOfTest + " (" + ts.treeRule + " walks " + ts.rule + ")" + " - " + "\n");
                            bufResult.append("expected: " + ts.testSuites.get(input).getText() + "\n");
                            bufResult.append("actual: null\n\n");
                            continue;
                        }
                        if (ts.testSuites.get(input).getType() == 7) {
                            String stringResult = String.valueOf(result);
                            String expect = ts.testSuites.get(input).getText();
                            if (expect.charAt(0) == '\"' && expect.charAt(expect.length() - 1) == '\"') {
                                expect = expect.substring(0, expect.length() - 1);
                            }
                            if (stringResult.equals(expect)) {
                                ++numOfSuccess;
                                continue;
                            }
                            ++numOfFailure;
                            bufResult.append("test" + numOfTest + " (" + ts.treeRule + " walks " + ts.rule + ")" + " - " + "\n");
                            bufResult.append("expected: " + expect + "\n");
                            bufResult.append("actual: " + result + "\n\n");
                            continue;
                        }
                        if (ts.testSuites.get(input).getType() == 6) {
                            ++numOfFailure;
                            bufResult.append("test" + numOfTest + " (" + ts.treeRule + " walks " + ts.rule + ")" + " - " + "\n");
                            bufResult.append("\t{ACTION} is not supported in the interpreter yet...\n\n");
                            continue;
                        }
                        if (result.equals(ts.testSuites.get(input).getText())) {
                            ++numOfSuccess;
                            continue;
                        }
                        ++numOfFailure;
                        bufResult.append("test" + numOfTest + " (" + ts.treeRule + " walks " + ts.rule + ")" + " - " + "\n");
                        bufResult.append("expected: " + ts.testSuites.get(input).getText() + "\n");
                        bufResult.append("actual: " + result + "\n\n");
                    }
                }
            } else {
                title = "executing testsuite for grammar:" + this.interpreter.grammarName;
                for (gUnitTestSuite ts : this.interpreter.ruleTestSuites) {
                    for (gUnitTestInput input : ts.testSuites.keySet()) {
                        ++numOfTest;
                        Object result = this.runParser(parserName, lexerName, ts.rule, input);
                        if (this.invalidInput) {
                            ++numOfInvalidInput;
                            bufInvalid.append("test" + numOfTest + " (" + ts.rule + ")" + " - " + "\n");
                            bufInvalid.append("invalid input: " + input.testInput + "\n\n");
                        }
                        if (ts.testSuites.get(input).getType() == 27) {
                            if (this.stderr == null) {
                                ++numOfSuccess;
                                continue;
                            }
                            ++numOfFailure;
                            bufResult.append("test" + numOfTest + " (" + ts.rule + ")" + " - " + "\n");
                            bufResult.append("expected: OK\n");
                            bufResult.append("actual: FAIL\n\n");
                            continue;
                        }
                        if (ts.testSuites.get(input).getType() == 28) {
                            if (this.stderr != null) {
                                ++numOfSuccess;
                                continue;
                            }
                            ++numOfFailure;
                            bufResult.append("test" + numOfTest + " (" + ts.rule + ")" + " - " + "\n");
                            bufResult.append("expected: FAIL\n");
                            bufResult.append("actual: OK\n\n");
                            continue;
                        }
                        if (result == null) {
                            ++numOfFailure;
                            bufResult.append("test" + numOfTest + " (" + ts.rule + ")" + " - " + "\n");
                            bufResult.append("expected: " + ts.testSuites.get(input).getText() + "\n");
                            bufResult.append("actual: null\n\n");
                            continue;
                        }
                        if (ts.testSuites.get(input).getType() == 7) {
                            String stringResult = String.valueOf(result);
                            String expect = ts.testSuites.get(input).getText();
                            if (expect.charAt(0) == '\"' && expect.charAt(expect.length() - 1) == '\"') {
                                expect = expect.substring(1, expect.length() - 1);
                            }
                            if (stringResult.equals(expect)) {
                                ++numOfSuccess;
                                continue;
                            }
                            ++numOfFailure;
                            bufResult.append("test" + numOfTest + " (" + ts.rule + ")" + " - " + "\n");
                            bufResult.append("expected: " + expect + "\n");
                            bufResult.append("actual: " + result + "\n\n");
                            continue;
                        }
                        if (ts.testSuites.get(input).getType() == 6) {
                            bufResult.append("test" + numOfTest + " (" + ts.rule + ")" + " - " + "\n");
                            bufResult.append("\t{ACTION} is not supported in the interpreter yet...\n\n");
                            continue;
                        }
                        if (result.equals(ts.testSuites.get(input).getText())) {
                            ++numOfSuccess;
                            continue;
                        }
                        ++numOfFailure;
                        bufResult.append("test" + numOfTest + " (" + ts.rule + ")" + " - " + "\n");
                        bufResult.append("expected: " + ts.testSuites.get(input).getText() + "\n");
                        bufResult.append("actual: " + result + "\n\n");
                    }
                }
            }
            this.interpreter.unitTestResult.append("--------------------------------------------------------------------------------\n");
            this.interpreter.unitTestResult.append(title + " with " + numOfTest + " tests\n");
            this.interpreter.unitTestResult.append("--------------------------------------------------------------------------------\n");
            if (numOfFailure > 0) {
                this.interpreter.unitTestResult.append(numOfFailure + " failures found:\n");
                this.interpreter.unitTestResult.append(bufResult.toString() + "\n");
            }
            if (numOfInvalidInput > 0) {
                this.interpreter.unitTestResult.append(numOfInvalidInput + " invalid inputs found:\n");
                this.interpreter.unitTestResult.append(bufInvalid.toString() + "\n");
            }
            this.interpreter.unitTestResult.append("Tests run: " + numOfTest + ", " + "Failures: " + numOfFailure + "\n\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected Object runParser(String parserName, String lexerName, String testRuleName, gUnitTestInput testInput) throws Exception {
        Object input = testInput.inputIsFile ? new ANTLRFileStream(testInput.testInput) : new ANTLRStringStream(testInput.testInput);
        Class<?> lexer = null;
        Class<?> parser = null;
        try {
            lexer = Class.forName(lexerName);
            Class[] lexArgTypes = new Class[]{CharStream.class};
            Constructor<?> lexConstructor = lexer.getConstructor(lexArgTypes);
            Object[] lexArgs = new Object[]{input};
            Object lexObj = lexConstructor.newInstance(lexArgs);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)((Lexer)lexObj));
            parser = Class.forName(parserName);
            Class[] parArgTypes = new Class[]{TokenStream.class};
            Constructor<?> parConstructor = parser.getConstructor(parArgTypes);
            Object[] parArgs = new Object[]{tokens};
            Object parObj = parConstructor.newInstance(parArgs);
            Method ruleName = parser.getMethod(testRuleName, new Class[0]);
            PipedInputStream pipedIn = new PipedInputStream();
            PipedOutputStream pipedOut = new PipedOutputStream();
            PipedInputStream pipedErrIn = new PipedInputStream();
            PipedOutputStream pipedErrOut = new PipedOutputStream();
            try {
                pipedOut.connect(pipedIn);
                pipedErrOut.connect(pipedErrIn);
            }
            catch (IOException e) {
                System.err.println("connection failed...");
                System.exit(1);
            }
            PrintStream console = System.out;
            PrintStream consoleErr = System.err;
            PrintStream ps = new PrintStream(pipedOut);
            PrintStream ps2 = new PrintStream(pipedErrOut);
            System.setOut(ps);
            System.setErr(ps2);
            Object ruleReturn = ruleName.invoke(parObj, new Object[0]);
            String astString = null;
            if (ruleReturn != null && ruleReturn.toString().indexOf(testRuleName + "_return") > 0) {
                try {
                    Method[] methods;
                    Class<?> _return = Class.forName(parserName + "$" + testRuleName + "_return");
                    for (Method method : methods = _return.getDeclaredMethods()) {
                        if (!method.getName().equals("getTree")) continue;
                        Method returnName = _return.getMethod("getTree", new Class[0]);
                        CommonTree tree = (CommonTree)returnName.invoke(ruleReturn, new Object[0]);
                        astString = tree.toStringTree();
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            this.invalidInput = tokens.index() != tokens.size();
            StreamVacuum stdoutVacuum = new StreamVacuum(pipedIn);
            StreamVacuum stderrVacuum = new StreamVacuum(pipedErrIn);
            ps.close();
            ps2.close();
            System.setOut(console);
            System.setErr(consoleErr);
            this.stdout = null;
            this.stderr = null;
            stdoutVacuum.start();
            stderrVacuum.start();
            stdoutVacuum.join();
            stderrVacuum.join();
            if (stderrVacuum.toString().length() > 0) {
                this.stderr = stderrVacuum.toString();
                return this.stderr;
            }
            if (stdoutVacuum.toString().length() > 0) {
                this.stdout = stdoutVacuum.toString();
            }
            if (astString != null) {
                return astString;
            }
            if (ruleReturn != null) {
                return ruleReturn;
            }
            if (stderrVacuum.toString().length() == 0 && stdoutVacuum.toString().length() == 0) {
                return null;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return this.stdout;
    }

    protected Object runTreeParser(String parserName, String lexerName, String testRuleName, String testTreeRuleName, gUnitTestInput testInput) throws Exception {
        Object input = testInput.inputIsFile ? new ANTLRFileStream(testInput.testInput) : new ANTLRStringStream(testInput.testInput);
        String treeParserPath = this.interpreter.header != null ? this.interpreter.header + "." + this.interpreter.treeGrammarName : this.interpreter.treeGrammarName;
        Class<?> lexer = null;
        Class<?> parser = null;
        Class<?> treeParser = null;
        try {
            lexer = Class.forName(lexerName);
            Class[] lexArgTypes = new Class[]{CharStream.class};
            Constructor<?> lexConstructor = lexer.getConstructor(lexArgTypes);
            Object[] lexArgs = new Object[]{input};
            Object lexObj = lexConstructor.newInstance(lexArgs);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)((Lexer)lexObj));
            parser = Class.forName(parserName);
            Class[] parArgTypes = new Class[]{TokenStream.class};
            Constructor<?> parConstructor = parser.getConstructor(parArgTypes);
            Object[] parArgs = new Object[]{tokens};
            Object parObj = parConstructor.newInstance(parArgs);
            Method ruleName = parser.getMethod(testRuleName, new Class[0]);
            PipedInputStream pipedIn = new PipedInputStream();
            PipedOutputStream pipedOut = new PipedOutputStream();
            PipedInputStream pipedErrIn = new PipedInputStream();
            PipedOutputStream pipedErrOut = new PipedOutputStream();
            try {
                pipedOut.connect(pipedIn);
                pipedErrOut.connect(pipedErrIn);
            }
            catch (IOException e) {
                System.err.println("connection failed...");
                System.exit(1);
            }
            PrintStream console = System.out;
            PrintStream consoleErr = System.err;
            PrintStream ps = new PrintStream(pipedOut);
            PrintStream ps2 = new PrintStream(pipedErrOut);
            System.setOut(ps);
            System.setErr(ps2);
            Object ruleReturn = ruleName.invoke(parObj, new Object[0]);
            Class<?> _return = Class.forName(parserName + "$" + testRuleName + "_return");
            Method returnName = _return.getMethod("getTree", new Class[0]);
            CommonTree tree = (CommonTree)returnName.invoke(ruleReturn, new Object[0]);
            CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)tree);
            nodes.setTokenStream((TokenStream)tokens);
            treeParser = Class.forName(treeParserPath);
            Class[] treeParArgTypes = new Class[]{TreeNodeStream.class};
            Constructor<?> treeParConstructor = treeParser.getConstructor(treeParArgTypes);
            Object[] treeParArgs = new Object[]{nodes};
            Object treeParObj = treeParConstructor.newInstance(treeParArgs);
            Method treeRuleName = treeParser.getMethod(testTreeRuleName, new Class[0]);
            Object treeRuleReturn = treeRuleName.invoke(treeParObj, new Object[0]);
            String astString = null;
            if (treeRuleReturn != null && treeRuleReturn.toString().indexOf(testTreeRuleName + "_return") > 0) {
                try {
                    Method[] methods;
                    Class<?> _treeReturn = Class.forName(treeParserPath + "$" + testTreeRuleName + "_return");
                    for (Method method : methods = _treeReturn.getDeclaredMethods()) {
                        if (!method.getName().equals("getTree")) continue;
                        Method treeReturnName = _treeReturn.getMethod("getTree", new Class[0]);
                        CommonTree returnTree = (CommonTree)treeReturnName.invoke(treeRuleReturn, new Object[0]);
                        astString = returnTree.toStringTree();
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            this.invalidInput = tokens.index() != tokens.size();
            StreamVacuum stdoutVacuum = new StreamVacuum(pipedIn);
            StreamVacuum stderrVacuum = new StreamVacuum(pipedErrIn);
            ps.close();
            ps2.close();
            System.setOut(console);
            System.setErr(consoleErr);
            this.stdout = null;
            this.stderr = null;
            stdoutVacuum.start();
            stderrVacuum.start();
            stdoutVacuum.join();
            stderrVacuum.join();
            if (stderrVacuum.toString().length() > 0) {
                this.stderr = stderrVacuum.toString();
                return this.stderr;
            }
            if (stdoutVacuum.toString().length() > 0) {
                this.stdout = stdoutVacuum.toString();
            }
            if (astString != null) {
                return astString;
            }
            if (treeRuleReturn != null) {
                return treeRuleReturn;
            }
            if (stderrVacuum.toString().length() == 0 && stdoutVacuum.toString().length() == 0) {
                return null;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return this.stdout;
    }

    public static class StreamVacuum
    implements Runnable {
        StringBuffer buf = new StringBuffer();
        BufferedReader in;
        Thread sucker;

        public StreamVacuum(InputStream in) {
            this.in = new BufferedReader(new InputStreamReader(in));
        }

        public void start() {
            this.sucker = new Thread(this);
            this.sucker.start();
        }

        public void run() {
            try {
                String line = this.in.readLine();
                while (line != null) {
                    this.buf.append(line);
                    this.buf.append('\n');
                    line = this.in.readLine();
                }
            }
            catch (IOException ioe) {
                System.err.println("can't read output from standard (error) output");
            }
        }

        public void join() throws InterruptedException {
            this.sucker.join();
        }

        public String toString() {
            return this.buf.toString();
        }
    }
}

