/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.tree.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.print.PrintException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.abego.treelayout.Configuration;
import org.abego.treelayout.NodeExtentProvider;
import org.abego.treelayout.TreeForTreeLayout;
import org.abego.treelayout.TreeLayout;
import org.abego.treelayout.util.DefaultConfiguration;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.misc.GraphicsSupport;
import org.antlr.v4.runtime.misc.Utils;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.Tree;
import org.antlr.v4.runtime.tree.Trees;
import org.antlr.v4.runtime.tree.gui.TreeLayoutAdaptor;
import org.antlr.v4.runtime.tree.gui.TreeTextProvider;

public class TreeViewer
extends JComponent {
    public static final Color LIGHT_RED = new Color(244, 213, 211);
    protected TreeTextProvider treeTextProvider;
    protected TreeLayout<Tree> treeLayout;
    protected List<Tree> highlightedNodes;
    protected String fontName = "Helvetica";
    protected int fontStyle = 0;
    protected int fontSize = 11;
    protected Font font = new Font(this.fontName, this.fontStyle, this.fontSize);
    protected double gapBetweenLevels = 17.0;
    protected double gapBetweenNodes = 7.0;
    protected int nodeWidthPadding = 2;
    protected int nodeHeightPadding = 0;
    protected int arcSize = 0;
    protected double scale = 1.0;
    protected Color boxColor = null;
    protected Color highlightedBoxColor = Color.lightGray;
    protected Color borderColor = null;
    protected Color textColor = Color.black;
    protected Parser parser;
    private boolean useCurvedEdges = false;

    public TreeViewer(Parser parser, Tree tree) {
        this.parser = parser;
        this.setTreeTextProvider(new DefaultTreeTextProvider(parser));
        boolean useIdentity = true;
        this.treeLayout = new TreeLayout((TreeForTreeLayout)new TreeLayoutAdaptor(tree), (NodeExtentProvider)new VariableExtentProvide(this), (Configuration)new DefaultConfiguration(this.gapBetweenLevels, this.gapBetweenNodes), useIdentity);
        this.updatePreferredSize();
        this.setFont(this.font);
    }

    private void updatePreferredSize() {
        this.setPreferredSize(this.getScaledTreeSize());
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
        this.repaint();
    }

    public boolean getUseCurvedEdges() {
        return this.useCurvedEdges;
    }

    public void setUseCurvedEdges(boolean useCurvedEdges) {
        this.useCurvedEdges = useCurvedEdges;
    }

    protected void paintEdges(Graphics g, Tree parent) {
        if (!this.getTree().isLeaf((Object)parent)) {
            BasicStroke stroke = new BasicStroke(1.0f, 1, 1);
            ((Graphics2D)g).setStroke(stroke);
            Rectangle2D.Double parentBounds = this.getBoundsOfNode(parent);
            double x1 = parentBounds.getCenterX();
            double y1 = parentBounds.getMaxY();
            for (Tree child : this.getTree().getChildren((Object)parent)) {
                Rectangle2D.Double childBounds = this.getBoundsOfNode(child);
                double x2 = childBounds.getCenterX();
                double y2 = childBounds.getMinY();
                if (this.getUseCurvedEdges()) {
                    CubicCurve2D.Double c = new CubicCurve2D.Double();
                    double ctrlx1 = x1;
                    double ctrly1 = (y1 + y2) / 2.0;
                    double ctrlx2 = x2;
                    double ctrly2 = y1;
                    ((CubicCurve2D)c).setCurve(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2);
                    ((Graphics2D)g).draw(c);
                } else {
                    g.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
                }
                this.paintEdges(g, child);
            }
        }
    }

    protected void paintBox(Graphics g, Tree tree) {
        Rectangle2D.Double box = this.getBoundsOfNode(tree);
        if (this.isHighlighted(tree) || this.boxColor != null || tree instanceof ErrorNode) {
            if (this.isHighlighted(tree)) {
                g.setColor(this.highlightedBoxColor);
            } else if (tree instanceof ErrorNode) {
                g.setColor(LIGHT_RED);
            } else {
                g.setColor(this.boxColor);
            }
            g.fillRoundRect((int)box.x, (int)box.y, (int)box.width - 1, (int)box.height - 1, this.arcSize, this.arcSize);
        }
        if (this.borderColor != null) {
            g.setColor(this.borderColor);
            g.drawRoundRect((int)box.x, (int)box.y, (int)box.width - 1, (int)box.height - 1, this.arcSize, this.arcSize);
        }
        g.setColor(this.textColor);
        String s = this.getText(tree);
        String[] lines = s.split("\n");
        FontMetrics m = this.getFontMetrics(this.font);
        int x = (int)box.x + this.arcSize / 2 + this.nodeWidthPadding;
        int y = (int)box.y + m.getAscent() + m.getLeading() + 1 + this.nodeHeightPadding;
        for (int i = 0; i < lines.length; ++i) {
            this.text(g, lines[i], x, y);
            y += m.getHeight();
        }
    }

    public void text(Graphics g, String s, int x, int y) {
        s = Utils.escapeWhitespace(s, true);
        g.drawString(s, x, y);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.paintEdges(g, (Tree)this.getTree().getRoot());
        for (Tree Tree2 : this.treeLayout.getNodeBounds().keySet()) {
            this.paintBox(g, Tree2);
        }
    }

    @Override
    protected Graphics getComponentGraphics(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.scale(this.scale, this.scale);
        return super.getComponentGraphics(g2d);
    }

    protected static void showInDialog(final TreeViewer viewer) {
        final JDialog dialog = new JDialog();
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout(0, 0));
        ((Component)contentPane).setBackground(Color.white);
        dialog.setContentPane(contentPane);
        JScrollPane scrollPane = new JScrollPane(viewer);
        contentPane.add((Component)scrollPane, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout(0, 0));
        contentPane.add((Component)bottomPanel, "South");
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        JPanel wrapper = new JPanel(new FlowLayout());
        wrapper.add(ok);
        bottomPanel.add((Component)wrapper, "South");
        int sliderValue = (int)((viewer.getScale() - 1.0) * 1000.0);
        final JSlider scaleSlider = new JSlider(0, -999, 1000, sliderValue);
        scaleSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int v = scaleSlider.getValue();
                viewer.setScale((double)v / 1000.0 + 1.0);
            }
        });
        bottomPanel.add((Component)scaleSlider, "Center");
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    private Dimension getScaledTreeSize() {
        Dimension scaledTreeSize = this.treeLayout.getBounds().getBounds().getSize();
        scaledTreeSize = new Dimension((int)((double)scaledTreeSize.width * this.scale), (int)((double)scaledTreeSize.height * this.scale));
        return scaledTreeSize;
    }

    public void open() {
        final TreeViewer viewer = this;
        viewer.setScale(1.5);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeViewer.showInDialog(viewer);
            }
        });
    }

    public void save(String fileName) throws IOException, PrintException {
        JDialog dialog = new JDialog();
        Container contentPane = dialog.getContentPane();
        ((JComponent)contentPane).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.add(this);
        contentPane.setBackground(Color.white);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.dispose();
        GraphicsSupport.saveImage(this, fileName);
    }

    protected Rectangle2D.Double getBoundsOfNode(Tree node) {
        return (Rectangle2D.Double)this.treeLayout.getNodeBounds().get(node);
    }

    protected String getText(Tree tree) {
        String s = this.treeTextProvider.getText(tree);
        s = Utils.escapeWhitespace(s, true);
        return s;
    }

    public TreeTextProvider getTreeTextProvider() {
        return this.treeTextProvider;
    }

    public void setTreeTextProvider(TreeTextProvider treeTextProvider) {
        this.treeTextProvider = treeTextProvider;
    }

    public void setFontSize(int sz) {
        this.fontSize = sz;
        this.font = new Font(this.fontName, this.fontStyle, this.fontSize);
    }

    public void setFontName(String name) {
        this.fontName = name;
        this.font = new Font(this.fontName, this.fontStyle, this.fontSize);
    }

    public void addHighlightedNodes(Collection<Tree> nodes) {
        this.highlightedNodes = new ArrayList<Tree>();
        this.highlightedNodes.addAll(nodes);
    }

    public void removeHighlightedNodes(Collection<Tree> nodes) {
        if (this.highlightedNodes != null) {
            for (Tree t : nodes) {
                int i = this.getHighlightedNodeIndex(t);
                if (i < 0) continue;
                this.highlightedNodes.remove(i);
            }
        }
    }

    protected boolean isHighlighted(Tree node) {
        return this.getHighlightedNodeIndex(node) >= 0;
    }

    protected int getHighlightedNodeIndex(Tree node) {
        if (this.highlightedNodes == null) {
            return -1;
        }
        for (int i = 0; i < this.highlightedNodes.size(); ++i) {
            Tree t = this.highlightedNodes.get(i);
            if (t != node) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    public int getArcSize() {
        return this.arcSize;
    }

    public void setArcSize(int arcSize) {
        this.arcSize = arcSize;
    }

    public Color getBoxColor() {
        return this.boxColor;
    }

    public void setBoxColor(Color boxColor) {
        this.boxColor = boxColor;
    }

    public Color getHighlightedBoxColor() {
        return this.highlightedBoxColor;
    }

    public void setHighlightedBoxColor(Color highlightedBoxColor) {
        this.highlightedBoxColor = highlightedBoxColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    protected TreeForTreeLayout<Tree> getTree() {
        return this.treeLayout.getTree();
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        if (scale <= 0.0) {
            scale = 1.0;
        }
        this.scale = scale;
        this.updatePreferredSize();
    }

    public static class VariableExtentProvide
    implements NodeExtentProvider<Tree> {
        TreeViewer viewer;

        public VariableExtentProvide(TreeViewer viewer) {
            this.viewer = viewer;
        }

        public double getWidth(Tree tree) {
            FontMetrics fontMetrics = this.viewer.getFontMetrics(this.viewer.font);
            String s = this.viewer.getText(tree);
            int w = fontMetrics.stringWidth(s) + this.viewer.nodeWidthPadding * 2;
            return w;
        }

        public double getHeight(Tree tree) {
            FontMetrics fontMetrics = this.viewer.getFontMetrics(this.viewer.font);
            int h = fontMetrics.getHeight() + this.viewer.nodeHeightPadding * 2;
            String s = this.viewer.getText(tree);
            String[] lines = s.split("\n");
            return h * lines.length;
        }
    }

    public static class DefaultTreeTextProvider
    implements TreeTextProvider {
        Parser parser;

        public DefaultTreeTextProvider(Parser parser) {
            this.parser = parser;
        }

        @Override
        public String getText(Tree node) {
            return String.valueOf(Trees.getNodeText(node, this.parser));
        }
    }
}

