/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.misc;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.print.PrintException;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DiagnosticErrorListener;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;

public class TestRig {
    static String grammarName;
    static String startRuleName;
    static List<String> inputFiles;
    static boolean printTree;
    static boolean gui;
    static String psFile;
    static boolean showTokens;
    static boolean trace;
    static boolean diagnostics;
    static String encoding;
    static boolean SLL;
    public static final String LEXER_START_RULE_NAME = "tokens";

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("java org.antlr.v4.runtime.misc.TestRig GrammarName startRuleName\n  [-tokens] [-tree] [-gui] [-ps file.ps] [-encoding encodingname]\n  [-trace] [-diagnostics] [-SLL]\n  [input-filename(s)]");
            System.err.println("Use startRuleName='tokens' if GrammarName is a lexer grammar.");
            System.err.println("Omitting input-filename makes rig read from stdin.");
            return;
        }
        int i = 0;
        grammarName = args[i];
        startRuleName = args[++i];
        ++i;
        while (i < args.length) {
            String arg = args[i];
            ++i;
            if (arg.charAt(0) != '-') {
                inputFiles.add(arg);
                continue;
            }
            if (arg.equals("-tree")) {
                printTree = true;
            }
            if (arg.equals("-gui")) {
                gui = true;
            }
            if (arg.equals("-tokens")) {
                showTokens = true;
                continue;
            }
            if (arg.equals("-trace")) {
                trace = true;
                continue;
            }
            if (arg.equals("-SLL")) {
                SLL = true;
                continue;
            }
            if (arg.equals("-diagnostics")) {
                diagnostics = true;
                continue;
            }
            if (arg.equals("-encoding")) {
                if (i >= args.length) {
                    System.err.println("missing encoding on -encoding");
                    return;
                }
                encoding = args[i];
                ++i;
                continue;
            }
            if (!arg.equals("-ps")) continue;
            if (i >= args.length) {
                System.err.println("missing filename on -ps");
                return;
            }
            psFile = args[i];
            ++i;
        }
        String lexerName = grammarName + "Lexer";
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<Lexer> lexerClass = null;
        try {
            lexerClass = cl.loadClass(lexerName).asSubclass(Lexer.class);
        }
        catch (ClassNotFoundException cnfe) {
            lexerName = grammarName;
            try {
                lexerClass = cl.loadClass(lexerName).asSubclass(Lexer.class);
            }
            catch (ClassNotFoundException cnfe2) {
                System.err.println("Can't load " + lexerName + " as lexer or parser");
                return;
            }
        }
        Constructor<Lexer> lexerCtor = lexerClass.getConstructor(CharStream.class);
        Lexer lexer = lexerCtor.newInstance(new Object[]{null});
        Class<Parser> parserClass = null;
        Parser parser = null;
        if (!startRuleName.equals(LEXER_START_RULE_NAME)) {
            String parserName = grammarName + "Parser";
            parserClass = cl.loadClass(parserName).asSubclass(Parser.class);
            if (parserClass == null) {
                System.err.println("Can't load " + parserName);
            }
            Constructor<Parser> parserCtor = parserClass.getConstructor(TokenStream.class);
            parser = parserCtor.newInstance(new Object[]{null});
        }
        if (inputFiles.size() == 0) {
            InputStream is = System.in;
            InputStreamReader r = encoding != null ? new InputStreamReader(is, encoding) : new InputStreamReader(is);
            TestRig.process(lexer, parserClass, parser, is, r);
            return;
        }
        for (String inputFile : inputFiles) {
            InputStream is = System.in;
            if (inputFile != null) {
                is = new FileInputStream(inputFile);
            }
            InputStreamReader r = encoding != null ? new InputStreamReader(is, encoding) : new InputStreamReader(is);
            if (inputFiles.size() > 1) {
                System.err.println(inputFile);
            }
            TestRig.process(lexer, parserClass, parser, is, r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void process(Lexer lexer, Class<? extends Parser> parserClass, Parser parser, InputStream is, Reader r) throws IOException, IllegalAccessException, InvocationTargetException, PrintException {
        try {
            ANTLRInputStream input = new ANTLRInputStream(r);
            lexer.setInputStream(input);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            tokens.fill();
            if (showTokens) {
                for (Token tok : tokens.getTokens()) {
                    System.out.println(tok);
                }
            }
            if (startRuleName.equals(LEXER_START_RULE_NAME)) {
                return;
            }
            if (diagnostics) {
                parser.addErrorListener(new DiagnosticErrorListener());
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL_EXACT_AMBIG_DETECTION);
            }
            if (printTree || gui || psFile != null) {
                parser.setBuildParseTree(true);
            }
            if (SLL) {
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            }
            parser.setTokenStream(tokens);
            parser.setTrace(trace);
            try {
                Method startRule = parserClass.getMethod(startRuleName, new Class[0]);
                ParserRuleContext tree = (ParserRuleContext)startRule.invoke((Object)parser, (Object[])null);
                if (printTree) {
                    System.out.println(tree.toStringTree(parser));
                }
                if (gui) {
                    tree.inspect(parser);
                }
                if (psFile != null) {
                    tree.save(parser, psFile);
                }
            }
            catch (NoSuchMethodException nsme) {
                System.err.println("No method for rule " + startRuleName + " or it has arguments");
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    static {
        inputFiles = new ArrayList<String>();
        printTree = false;
        gui = false;
        psFile = null;
        showTokens = false;
        trace = false;
        diagnostics = false;
        encoding = null;
        SLL = false;
    }
}

