/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.dfa;

import java.util.Arrays;
import java.util.Map;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.dfa.DFAState;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Nullable;

public class DFASerializer {
    @NotNull
    final DFA dfa;
    @Nullable
    final String[] tokenNames;

    public DFASerializer(@NotNull DFA dfa, @Nullable String[] tokenNames) {
        this.dfa = dfa;
        this.tokenNames = tokenNames;
    }

    public String toString() {
        if (this.dfa.s0 == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        Map<DFAState, DFAState> states = this.dfa.states;
        if (states != null) {
            for (DFAState s : states.values()) {
                int n = 0;
                if (s.edges != null) {
                    n = s.edges.length;
                }
                for (int i = 0; i < n; ++i) {
                    DFAState t = s.edges[i];
                    if (t == null || t.stateNumber == Integer.MAX_VALUE) continue;
                    buf.append(this.getStateString(s));
                    String label = this.getEdgeLabel(i);
                    buf.append("-").append(label).append("->").append(this.getStateString(t)).append('\n');
                }
            }
        }
        String output = buf.toString();
        return output;
    }

    protected String getEdgeLabel(int i) {
        if (i == 0) {
            return "EOF";
        }
        String label = this.tokenNames != null ? this.tokenNames[i - 1] : String.valueOf(i - 1);
        return label;
    }

    String getStateString(DFAState s) {
        int n = s.stateNumber;
        String stateStr = "s" + n;
        if (s.isAcceptState) {
            stateStr = s.predicates != null ? ":s" + n + "=>" + Arrays.toString(s.predicates) : ":s" + n + "=>" + s.prediction;
        } else if (s.requiresFullContext) {
            stateStr = "s" + n + "^";
        }
        return stateStr;
    }
}

