/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.atn;

import java.io.InvalidClassException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.ActionTransition;
import org.antlr.v4.runtime.atn.AtomTransition;
import org.antlr.v4.runtime.atn.BlockEndState;
import org.antlr.v4.runtime.atn.BlockStartState;
import org.antlr.v4.runtime.atn.DecisionState;
import org.antlr.v4.runtime.atn.EpsilonTransition;
import org.antlr.v4.runtime.atn.LoopEndState;
import org.antlr.v4.runtime.atn.NotSetTransition;
import org.antlr.v4.runtime.atn.PlusBlockStartState;
import org.antlr.v4.runtime.atn.PlusLoopbackState;
import org.antlr.v4.runtime.atn.PredicateTransition;
import org.antlr.v4.runtime.atn.PredictionContext;
import org.antlr.v4.runtime.atn.PredictionContextCache;
import org.antlr.v4.runtime.atn.RangeTransition;
import org.antlr.v4.runtime.atn.RuleStartState;
import org.antlr.v4.runtime.atn.RuleStopState;
import org.antlr.v4.runtime.atn.RuleTransition;
import org.antlr.v4.runtime.atn.SetTransition;
import org.antlr.v4.runtime.atn.StarBlockStartState;
import org.antlr.v4.runtime.atn.StarLoopEntryState;
import org.antlr.v4.runtime.atn.StarLoopbackState;
import org.antlr.v4.runtime.atn.TokensStartState;
import org.antlr.v4.runtime.atn.Transition;
import org.antlr.v4.runtime.atn.WildcardTransition;
import org.antlr.v4.runtime.dfa.DFAState;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Pair;

public abstract class ATNSimulator {
    public static final int SERIALIZED_VERSION = 1;
    @NotNull
    public static final DFAState ERROR = new DFAState(new ATNConfigSet());
    @NotNull
    public final ATN atn;
    protected final PredictionContextCache sharedContextCache;

    public ATNSimulator(@NotNull ATN atn, @NotNull PredictionContextCache sharedContextCache) {
        this.atn = atn;
        this.sharedContextCache = sharedContextCache;
    }

    public abstract void reset();

    public PredictionContext getCachedContext(PredictionContext context) {
        if (this.sharedContextCache == null) {
            return context;
        }
        IdentityHashMap<PredictionContext, PredictionContext> visited = new IdentityHashMap<PredictionContext, PredictionContext>();
        return PredictionContext.getCachedContext(context, this.sharedContextCache, visited);
    }

    /*
     * WARNING - void declaration
     */
    public static ATN deserialize(@NotNull char[] data) {
        void var9_16;
        int version;
        ATN atn = new ATN();
        ArrayList<IntervalSet> sets = new ArrayList<IntervalSet>();
        int p = 0;
        if ((version = ATNSimulator.toInt(data[p++])) != SERIALIZED_VERSION) {
            String reason = String.format("Could not deserialize ATN with version %d (expected %d).", version, SERIALIZED_VERSION);
            throw new UnsupportedOperationException(new InvalidClassException(ATN.class.getName(), reason));
        }
        atn.grammarType = ATNSimulator.toInt(data[p++]);
        atn.maxTokenType = ATNSimulator.toInt(data[p++]);
        ArrayList<Pair<LoopEndState, Integer>> loopBackStateNumbers = new ArrayList<Pair<LoopEndState, Integer>>();
        ArrayList<Pair<BlockStartState, Integer>> endStateNumbers = new ArrayList<Pair<BlockStartState, Integer>>();
        int nstates = ATNSimulator.toInt(data[p++]);
        for (int i = 1; i <= nstates; ++i) {
            int n;
            if ((n = ATNSimulator.toInt(data[p++])) == 0) {
                atn.addState(null);
                continue;
            }
            ATNState s = ATNSimulator.stateFactory(n, i);
            s.ruleIndex = ATNSimulator.toInt(data[p++]);
            if (n == 12) {
                int loopBackStateNumber = ATNSimulator.toInt(data[p++]);
                loopBackStateNumbers.add(new Pair<LoopEndState, Integer>((LoopEndState)s, loopBackStateNumber));
            } else if (s instanceof BlockStartState) {
                int endStateNumber = ATNSimulator.toInt(data[p++]);
                endStateNumbers.add(new Pair<BlockStartState, Integer>((BlockStartState)s, endStateNumber));
            }
            atn.addState(s);
        }
        for (Pair pair : loopBackStateNumbers) {
            ((LoopEndState)pair.a).loopBackState = atn.states.get((Integer)pair.b);
        }
        for (Pair pair : endStateNumbers) {
            ((BlockStartState)pair.a).endState = (BlockEndState)atn.states.get((Integer)pair.b);
        }
        int numNonGreedyStates = ATNSimulator.toInt(data[p++]);
        boolean bl = false;
        while (var9_16 < numNonGreedyStates) {
            int stateNumber = ATNSimulator.toInt(data[p++]);
            ((DecisionState)atn.states.get((int)stateNumber)).nonGreedy = true;
            ++var9_16;
        }
        int n = ATNSimulator.toInt(data[p++]);
        if (atn.grammarType == 2) {
            atn.ruleToTokenType = new int[n];
            atn.ruleToActionIndex = new int[n];
        }
        atn.ruleToStartState = new RuleStartState[n];
        for (int i = 0; i < n; ++i) {
            int actionIndex;
            int tokenType;
            RuleStartState startState;
            int s = ATNSimulator.toInt(data[p++]);
            atn.ruleToStartState[i] = startState = (RuleStartState)atn.states.get(s);
            if (atn.grammarType != 2) continue;
            atn.ruleToTokenType[i] = tokenType = ATNSimulator.toInt(data[p++]);
            atn.ruleToActionIndex[i] = actionIndex = ATNSimulator.toInt(data[p++]);
        }
        atn.ruleToStopState = new RuleStopState[n];
        for (ATNState state : atn.states) {
            RuleStopState stopState;
            if (!(state instanceof RuleStopState)) continue;
            atn.ruleToStopState[state.ruleIndex] = stopState = (RuleStopState)state;
            atn.ruleToStartState[state.ruleIndex].stopState = stopState;
        }
        int nmodes = ATNSimulator.toInt(data[p++]);
        for (int i = 0; i < nmodes; ++i) {
            int s = ATNSimulator.toInt(data[p++]);
            atn.modeToStartState.add((TokensStartState)atn.states.get(s));
        }
        int nsets = ATNSimulator.toInt(data[p++]);
        for (int i = 1; i <= nsets; ++i) {
            int nintervals = ATNSimulator.toInt(data[p]);
            ++p;
            IntervalSet set = new IntervalSet(new int[0]);
            sets.add(set);
            for (int j = 1; j <= nintervals; ++j) {
                set.add(ATNSimulator.toInt(data[p]), ATNSimulator.toInt(data[p + 1]));
                p += 2;
            }
        }
        int nedges = ATNSimulator.toInt(data[p++]);
        for (int i = 1; i <= nedges; ++i) {
            int src = ATNSimulator.toInt(data[p]);
            int trg = ATNSimulator.toInt(data[p + 1]);
            int ttype = ATNSimulator.toInt(data[p + 2]);
            int arg1 = ATNSimulator.toInt(data[p + 3]);
            int arg2 = ATNSimulator.toInt(data[p + 4]);
            int arg3 = ATNSimulator.toInt(data[p + 5]);
            Transition trans = ATNSimulator.edgeFactory(atn, ttype, src, trg, arg1, arg2, arg3, sets);
            ATNState srcState = atn.states.get(src);
            srcState.addTransition(trans);
            p += 6;
        }
        for (ATNState state : atn.states) {
            for (int i = 0; i < state.getNumberOfTransitions(); ++i) {
                Transition t = state.transition(i);
                if (!(t instanceof RuleTransition)) continue;
                RuleTransition ruleTransition = (RuleTransition)t;
                atn.ruleToStopState[ruleTransition.target.ruleIndex].addTransition(new EpsilonTransition(ruleTransition.followState));
            }
        }
        for (ATNState state : atn.states) {
            ATNState target;
            int i;
            ATNState loopbackState;
            if (state instanceof BlockStartState) {
                if (((BlockStartState)state).endState == null) {
                    throw new IllegalStateException();
                }
                if (((BlockStartState)state).endState.startState != null) {
                    throw new IllegalStateException();
                }
                ((BlockStartState)state).endState.startState = (BlockStartState)state;
            }
            if (state instanceof PlusLoopbackState) {
                loopbackState = (PlusLoopbackState)state;
                for (i = 0; i < loopbackState.getNumberOfTransitions(); ++i) {
                    target = loopbackState.transition((int)i).target;
                    if (!(target instanceof PlusBlockStartState)) continue;
                    ((PlusBlockStartState)target).loopBackState = loopbackState;
                }
                continue;
            }
            if (!(state instanceof StarLoopbackState)) continue;
            loopbackState = (StarLoopbackState)state;
            for (i = 0; i < loopbackState.getNumberOfTransitions(); ++i) {
                target = loopbackState.transition((int)i).target;
                if (!(target instanceof StarLoopEntryState)) continue;
                ((StarLoopEntryState)target).loopBackState = loopbackState;
            }
        }
        int ndecisions = ATNSimulator.toInt(data[p++]);
        for (int i = 1; i <= ndecisions; ++i) {
            int s = ATNSimulator.toInt(data[p++]);
            DecisionState decState = (DecisionState)atn.states.get(s);
            atn.decisionToState.add(decState);
            decState.decision = i - 1;
        }
        ATNSimulator.verifyATN(atn);
        return atn;
    }

    private static void verifyATN(ATN atn) {
        for (ATNState state : atn.states) {
            DecisionState decisionState;
            if (state == null) continue;
            if (state instanceof PlusBlockStartState && ((PlusBlockStartState)state).loopBackState == null) {
                throw new IllegalStateException();
            }
            if (state instanceof StarLoopEntryState && ((StarLoopEntryState)state).loopBackState == null) {
                throw new IllegalStateException();
            }
            if (state instanceof LoopEndState && ((LoopEndState)state).loopBackState == null) {
                throw new IllegalStateException();
            }
            if (state instanceof RuleStartState && ((RuleStartState)state).stopState == null) {
                throw new IllegalStateException();
            }
            if (state instanceof BlockStartState && ((BlockStartState)state).endState == null) {
                throw new IllegalStateException();
            }
            if (state instanceof BlockEndState && ((BlockEndState)state).startState == null) {
                throw new IllegalStateException();
            }
            if (!(state instanceof DecisionState) || (decisionState = (DecisionState)state).getNumberOfTransitions() <= 1 || decisionState.decision >= 0) continue;
            throw new IllegalStateException();
        }
    }

    public static int toInt(char c) {
        return c == '\uffff' ? -1 : (int)c;
    }

    @NotNull
    public static Transition edgeFactory(@NotNull ATN atn, int type, int src, int trg, int arg1, int arg2, int arg3, List<IntervalSet> sets) {
        ATNState target = atn.states.get(trg);
        switch (type) {
            case 1: {
                return new EpsilonTransition(target);
            }
            case 2: {
                return new RangeTransition(target, arg1, arg2);
            }
            case 3: {
                RuleTransition rt = new RuleTransition((RuleStartState)atn.states.get(arg1), arg2, target);
                return rt;
            }
            case 4: {
                PredicateTransition pt = new PredicateTransition(target, arg1, arg2, arg3 != 0);
                return pt;
            }
            case 5: {
                return new AtomTransition(target, arg1);
            }
            case 6: {
                ActionTransition a = new ActionTransition(target, arg1, arg2, arg3 != 0);
                return a;
            }
            case 7: {
                return new SetTransition(target, sets.get(arg1));
            }
            case 8: {
                return new NotSetTransition(target, sets.get(arg1));
            }
            case 9: {
                return new WildcardTransition(target);
            }
        }
        throw new IllegalArgumentException("The specified transition type is not valid.");
    }

    public static ATNState stateFactory(int type, int stateNumber) {
        ATNState s;
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                s = new ATNState();
                break;
            }
            case 2: {
                s = new RuleStartState();
                break;
            }
            case 3: {
                s = new BlockStartState();
                break;
            }
            case 4: {
                s = new PlusBlockStartState();
                break;
            }
            case 5: {
                s = new StarBlockStartState();
                break;
            }
            case 6: {
                s = new TokensStartState();
                break;
            }
            case 7: {
                s = new RuleStopState();
                break;
            }
            case 8: {
                s = new BlockEndState();
                break;
            }
            case 9: {
                s = new StarLoopbackState();
                break;
            }
            case 10: {
                s = new StarLoopEntryState();
                break;
            }
            case 11: {
                s = new PlusLoopbackState();
                break;
            }
            case 12: {
                s = new LoopEndState();
                break;
            }
            default: {
                String message = String.format("The specified state type %d for state %d is not valid.", type, stateNumber);
                throw new IllegalArgumentException(message);
            }
        }
        s.stateNumber = stateNumber;
        return s;
    }

    static {
        ATNSimulator.ERROR.stateNumber = Integer.MAX_VALUE;
    }
}

