/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.mojo.antlr3;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.Tool;
import org.antlr.tool.BuildDependencyGenerator;
import org.antlr.tool.CompositeGrammar;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.apache.maven.plugin.MojoExecutionException;

public class ConfigurableTool
extends Tool {
    protected String baseDirectory;
    private Map<String, ExtendedBuildDependencyGenerator> buildDependencyGenerators = new HashMap<String, ExtendedBuildDependencyGenerator>();
    private final DependencyComparator dependsWorker = new DependencyComparator(this);

    public File getFileFor(String filename) {
        return new File(this.baseDirectory, filename);
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        File outDir;
        if (outputDirectory.endsWith("/") || outputDirectory.endsWith("\\")) {
            outputDirectory = outputDirectory.substring(0, outputDirectory.length() - 1);
        }
        if ((outDir = new File(outputDirectory)).exists() && !outDir.isDirectory()) {
            ErrorManager.error((int)6, (Object)outputDirectory);
            this.libDirectory = ".";
        }
        this.outputDirectory = outputDirectory;
    }

    public void setLibDirectory(String libDirectory) {
        File outDir;
        if (libDirectory.endsWith("/") || libDirectory.endsWith("\\")) {
            libDirectory = libDirectory.substring(0, libDirectory.length() - 1);
        }
        if (!(outDir = new File(libDirectory)).exists()) {
            ErrorManager.error((int)5, (Object)libDirectory);
            libDirectory = ".";
        }
        this.libDirectory = libDirectory;
    }

    public void setNfa() {
        this.generate_NFA_dot = true;
    }

    public void setDfa() {
        this.generate_DFA_dot = true;
    }

    public void setDebug() {
        this.debug = true;
    }

    public void setTrace() {
        this.trace = true;
    }

    public void setReport() {
        this.report = true;
    }

    public void setProfile() {
        this.profile = true;
    }

    public void setPrintGrammar() {
        this.printGrammar = true;
    }

    public void setDepend() {
        this.depend = true;
    }

    public void addGrammarFile(String grammarFileName) throws TokenStreamException, RecognitionException, IOException {
        this.buildDependencyGenerators.put(grammarFileName, new ExtendedBuildDependencyGenerator(this, grammarFileName));
        this.grammarFileNames.add(grammarFileName);
    }

    public Grammar getRootGrammar(String grammarFileName) throws IOException {
        CompositeGrammar composite = new CompositeGrammar();
        Grammar grammar = new Grammar((Tool)this, grammarFileName, composite);
        composite.setDelegationRoot(grammar);
        FileReader fr = null;
        fr = new FileReader(this.getFileFor(grammarFileName));
        BufferedReader br = new BufferedReader(fr);
        grammar.parseAndBuildAST((Reader)br);
        composite.watchNFAConversion = internalOption_watchNFAConversion;
        br.close();
        fr.close();
        return grammar;
    }

    public void sortGrammarFiles() throws MojoExecutionException {
        GraphTS sorted = new GraphTS();
        for (Object p : this.grammarFileNames) {
            sorted.addVertex((String)p);
        }
        int parent = 0;
        for (Object p : this.grammarFileNames) {
            int dependency = 0;
            for (Object d : this.grammarFileNames) {
                if (parent != dependency && this.dependsWorker.dependsOn((String)p, (String)d)) {
                    sorted.addEdge(dependency, parent);
                }
                ++dependency;
            }
            ++parent;
        }
        try {
            String[] sortedArray = sorted.topo();
            this.grammarFileNames.clear();
            for (int j = 0; j < parent; ++j) {
                this.grammarFileNames.add(sortedArray[j]);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Your grammar files contain circular dependencies that cannot be resolved. You must solve this issue before you can generate recognizers.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExtendedBuildDependencyGenerator
    extends BuildDependencyGenerator {
        private ExtendedBuildDependencyGenerator(Tool tool, String grammarFileName) throws IOException, TokenStreamException, RecognitionException {
            super(tool, grammarFileName);
        }

        protected List<File> getUsefulDependenciesFileList() {
            ArrayList<File> files = new ArrayList<File>();
            String vocabName = (String)this.grammar.getOption("tokenVocab");
            if (vocabName != null) {
                File parentFile = new File(this.grammar.getFileName()).getParentFile();
                if (parentFile != null) {
                    vocabName = parentFile.getPath() + File.separator + vocabName;
                }
                File vocabFile = this.tool.getImportedVocabFile(vocabName);
                files.add(vocabFile);
            }
            return files;
        }
    }

    public class DependencyComparator {
        private ConfigurableTool tool;

        public DependencyComparator(ConfigurableTool tool) {
            this.tool = tool;
        }

        protected boolean dependsOn(String o1, String o2) {
            ExtendedBuildDependencyGenerator dep1 = (ExtendedBuildDependencyGenerator)((Object)this.tool.buildDependencyGenerators.get(o1));
            ExtendedBuildDependencyGenerator dep2 = (ExtendedBuildDependencyGenerator)((Object)this.tool.buildDependencyGenerators.get(o2));
            List<File> dependencies = dep1.getUsefulDependenciesFileList();
            if (dependencies == null) {
                return false;
            }
            List generatedFiles = dep2.getGeneratedFileList();
            Boolean does = !Collections.disjoint(dependencies, generatedFiles);
            return does;
        }
    }

    public class GraphTS {
        private final int MAX_VERTS = 200;
        private Vertex[] vertexList = new Vertex[200];
        private int[][] matrix = new int[200][200];
        private int numVerts = 0;
        private String[] sortedArray;

        public GraphTS() {
            for (int i = 0; i < 200; ++i) {
                for (int k = 0; k < 200; ++k) {
                    this.matrix[i][k] = 0;
                }
            }
            this.sortedArray = new String[200];
        }

        public void addVertex(String lab) {
            this.vertexList[this.numVerts++] = new Vertex(lab);
        }

        public void addEdge(int start, int end) {
            this.matrix[start][end] = 1;
        }

        public void displayVertex(int v) {
            System.out.print(this.vertexList[v].label);
        }

        public String[] topo() throws Exception {
            int orig_nVerts = this.numVerts;
            while (this.numVerts > 0) {
                int currentVertex = this.noSuccessors();
                if (currentVertex == -1) {
                    throw new Exception("The provided grammar files have cyclic dependencies and cannot be ordered to build correctly");
                }
                this.sortedArray[this.numVerts - 1] = this.vertexList[currentVertex].label;
                this.deleteVertex(currentVertex);
            }
            return this.sortedArray;
        }

        public int noSuccessors() {
            for (int row = 0; row < this.numVerts; ++row) {
                boolean isEdge = false;
                for (int col = 0; col < this.numVerts; ++col) {
                    if (this.matrix[row][col] <= 0) continue;
                    isEdge = true;
                    break;
                }
                if (isEdge) continue;
                return row;
            }
            return -1;
        }

        public void deleteVertex(int delVert) {
            if (delVert != this.numVerts - 1) {
                for (int j = delVert; j < this.numVerts - 1; ++j) {
                    this.vertexList[j] = this.vertexList[j + 1];
                }
                for (int row = delVert; row < this.numVerts - 1; ++row) {
                    this.moveRowUp(row, this.numVerts);
                }
                for (int col = delVert; col < this.numVerts - 1; ++col) {
                    this.moveColLeft(col, this.numVerts - 1);
                }
            }
            --this.numVerts;
        }

        private void moveRowUp(int row, int length) {
            for (int col = 0; col < length; ++col) {
                this.matrix[row][col] = this.matrix[row + 1][col];
            }
        }

        private void moveColLeft(int col, int length) {
            for (int row = 0; row < length; ++row) {
                this.matrix[row][col] = this.matrix[row][col + 1];
            }
        }
    }

    class Vertex {
        public String label;

        public Vertex(String lab) {
            this.label = lab;
        }
    }
}

