/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.mojo.antlr3;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.mojo.antlr3.ConfigurableTool;
import org.antlr.mojo.antlr3.LoggingErrorListener;
import org.antlr.tool.ANTLRErrorListener;
import org.antlr.tool.ErrorManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;

public abstract class AbstractAntlr3PluginMojo
extends AbstractMojo {
    protected Set includes = new HashSet();
    protected Set excludes = new HashSet();
    protected boolean debug;
    protected boolean trace;
    protected boolean profile;
    protected boolean report;
    protected boolean nfa;
    protected boolean dfa;
    protected boolean printGrammar;
    protected String messageFormat;
    protected File antlrOutput;
    private int conversionTimeout;
    protected MavenProject project;

    abstract File getSourceDirectory();

    abstract File getOutputDirectory();

    abstract File getLibDirectory();

    abstract void addSourceRoot(File var1);

    public void execute() throws MojoExecutionException {
        ConfigurableTool tool = new ConfigurableTool();
        ErrorManager.setErrorListener((ANTLRErrorListener)new LoggingErrorListener(this.getLog()));
        try {
            this.configure(tool);
            if (ErrorManager.getNumErrors() > 0) {
                throw new MojoExecutionException("Unable to configure antlr properly.");
            }
            tool.process();
            if (ErrorManager.getNumErrors() > 0) {
                throw new MojoExecutionException("Antlr grammar processing failed with errors.");
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Antlr grammar processing failed.", e);
        }
        if (this.project != null) {
            this.addSourceRoot(this.getOutputDirectory());
        }
    }

    private void configure(ConfigurableTool tool) throws TokenStreamException, RecognitionException, IOException, InclusionScanException, MojoExecutionException {
        if (this.messageFormat != null) {
            ErrorManager.setFormat((String)this.messageFormat);
        }
        tool.setOutputDirectory(this.getOutputDirectory().getPath());
        tool.setBaseDirectory(this.getSourceDirectory().getPath());
        File libFile = this.getLibDirectory();
        if (libFile != null) {
            if (!libFile.exists()) {
                libFile.mkdirs();
            }
            tool.setLibDirectory(libFile.getPath());
        }
        if (this.debug) {
            tool.setDebug();
        }
        if (this.trace) {
            tool.setTrace();
        }
        if (this.profile) {
            tool.setProfile();
        }
        if (this.report) {
            tool.setReport();
        }
        if (this.nfa) {
            tool.setNfa();
        }
        if (this.dfa) {
            tool.setDfa();
        }
        if (this.printGrammar) {
            tool.setPrintGrammar();
        }
        DFA.MAX_TIME_PER_DFA_CREATION = this.conversionTimeout;
        SuffixMapping mapping = new SuffixMapping("g", Collections.EMPTY_SET);
        Set includes = this.getIncludesPatterns();
        SimpleSourceInclusionScanner scan = new SimpleSourceInclusionScanner(includes, this.excludes);
        scan.addSourceMapping((SourceMapping)mapping);
        Set grammarFiles = scan.getIncludedSources(this.getSourceDirectory(), null);
        if (grammarFiles.isEmpty()) {
            this.getLog().info((CharSequence)"No grammars to process");
        } else {
            String sourceDirectory = this.getSourceDirectory().getPath();
            String grammarRelPath = null;
            for (File grammarFile : grammarFiles) {
                grammarRelPath = this.findRelativeSource(sourceDirectory, grammarFile.getPath());
                tool.addGrammarFile(grammarRelPath);
            }
            tool.sortGrammarFiles();
        }
    }

    public Set getIncludesPatterns() {
        if (this.includes == null || this.includes.isEmpty()) {
            return Collections.singleton("**/*.g");
        }
        return this.includes;
    }

    private String findRelativeSource(String sourceDirectory, String grammarFileName) {
        if (grammarFileName.startsWith(sourceDirectory)) {
            grammarFileName = grammarFileName.substring(sourceDirectory.length() + 1);
        }
        return grammarFileName;
    }
}

