/*
 * Decompiled with CFR 0.152.
 */
package org.antframework.configcenter.spring.boot;

import org.antframework.boot.core.Contexts;
import org.antframework.configcenter.client.Config;
import org.antframework.configcenter.spring.ConfigsContexts;
import org.antframework.configcenter.spring.boot.ConfigcenterProperties;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class EnvironmentInitializer
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private final int order;

    public EnvironmentInitializer() {
        String initOrder = Contexts.getProperty((String)"configcenter.init-order");
        this.order = initOrder != null ? Integer.parseInt(initOrder) : -2147483618;
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        if (!ConfigcenterProperties.INSTANCE.isEnable()) {
            return;
        }
        ConfigcenterPropertySource propertySource = new ConfigcenterPropertySource(ConfigsContexts.getConfig(ConfigcenterProperties.INSTANCE.getRequiredAppId()));
        MutablePropertySources propertySources = event.getEnvironment().getPropertySources();
        if (ConfigcenterProperties.INSTANCE.getPriorTo() == null) {
            propertySources.addLast((PropertySource)propertySource);
        } else {
            propertySources.addBefore(ConfigcenterProperties.INSTANCE.getPriorTo(), (PropertySource)propertySource);
        }
        if (Contexts.getAppId() == null) {
            System.setProperty("spring.application.name", ConfigcenterProperties.INSTANCE.getRequiredAppId());
        }
    }

    public int getOrder() {
        return this.order;
    }

    public static class ConfigcenterPropertySource
    extends EnumerablePropertySource<Config> {
        public static final String PROPERTY_SOURCE_NAME = "configcenter";

        public ConfigcenterPropertySource(Config source) {
            super(PROPERTY_SOURCE_NAME, (Object)source);
        }

        public boolean containsProperty(String name) {
            return ((Config)this.source).getProperties().contains(name);
        }

        public String[] getPropertyNames() {
            return ((Config)this.source).getProperties().getPropertyKeys();
        }

        public Object getProperty(String name) {
            return ((Config)this.source).getProperties().getProperty(name);
        }
    }
}

