/*
 * Decompiled with CFR 0.152.
 */
package org.antframework.configcenter.spring.boot;

import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.antframework.boot.core.Contexts;
import org.antframework.boot.env.Envs;
import org.antframework.boot.env.listener.ChangedProperty;
import org.antframework.configcenter.client.Config;
import org.antframework.configcenter.client.ConfigsContext;
import org.antframework.configcenter.client.core.ChangedProperty;
import org.antframework.configcenter.spring.ConfigsContexts;
import org.antframework.configcenter.spring.boot.ConfigcenterProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public class ConfigsContextLifeCycle
implements GenericApplicationListener {
    private static final Logger log = LoggerFactory.getLogger(ConfigsContextLifeCycle.class);
    private Timer refreshTimer = null;

    public boolean supportsEventType(ResolvableType eventType) {
        return ApplicationReadyEvent.class.isAssignableFrom(eventType.getRawClass()) || ApplicationFailedEvent.class.isAssignableFrom(eventType.getRawClass()) || ContextClosedEvent.class.isAssignableFrom(eventType.getRawClass());
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return SpringApplication.class.isAssignableFrom(sourceType) || ApplicationContext.class.isAssignableFrom(sourceType);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (!ConfigcenterProperties.INSTANCE.isEnable()) {
            return;
        }
        if (event instanceof ApplicationReadyEvent) {
            this.readyConfigsContext();
        } else {
            this.close();
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private void readyConfigsContext() {
        ConfigsContext context = ConfigsContexts.getContext();
        for (String appId : context.getAppIds()) {
            Config config = context.getConfig(appId);
            config.getListeners().addListener(properties -> {
                List changedProperties = properties.stream().filter(property -> {
                    if (!Objects.equals(appId, ConfigcenterProperties.INSTANCE.getRequiredAppId())) {
                        return true;
                    }
                    String actualNewValue = Contexts.getEnvironment().getProperty(property.getKey());
                    return Objects.equals(property.getNewValue(), actualNewValue) || property.getType() == ChangedProperty.ChangeType.REMOVE;
                }).map(property -> new ChangedProperty(ChangedProperty.ChangeType.valueOf((String)property.getType().name()), property.getKey(), property.getOldValue(), property.getNewValue())).collect(Collectors.toList());
                if (!changedProperties.isEmpty()) {
                    Envs.getConfigListeners().onChange(appId, changedProperties);
                }
            });
        }
        boolean enable = (Boolean)Contexts.getEnvironment().getProperty("configcenter.auto-refresh-configs.enable", Boolean.class, (Object)Boolean.TRUE);
        if (enable) {
            context.listenServer();
            this.initTimer();
        }
    }

    private void initTimer() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    ConfigsContexts.getContext().refresh();
                }
                catch (Throwable e) {
                    log.error("\u5b9a\u65f6\u5237\u65b0configcenter\u914d\u7f6e\u51fa\u9519", e);
                }
            }
        };
        long period = (Long)Contexts.getEnvironment().getProperty("configcenter.auto-refresh-configs.period", Long.class, (Object)300000L);
        Assert.isTrue((period > 0L ? 1 : 0) != 0, (String)String.format("\u81ea\u52a8\u5237\u65b0configcenter\u914d\u7f6e\u7684\u5468\u671f[%s]\u5fc5\u987b\u5927\u4e8e0\uff0c\u5f53\u524d\u503c=%d", "configcenter.auto-refresh-configs.period", period));
        this.refreshTimer = new Timer("Timer-refreshConfigsContext", true);
        this.refreshTimer.schedule(task, period, period);
    }

    private void close() {
        ConfigsContexts.getContext().close();
        if (this.refreshTimer != null) {
            this.refreshTimer.cancel();
        }
    }
}

