/*
 * Decompiled with CFR 0.152.
 */
package org.antframework.configcenter.spring.boot;

import java.util.Objects;
import org.antframework.boot.core.Contexts;
import org.antframework.common.util.other.IPUtils;
import org.antframework.common.util.tostring.ToString;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="configcenter")
@Validated
public class ConfigcenterProperties {
    public static final String INIT_ORDER_KEY = "configcenter.init-order";
    public static final String AUTO_REFRESH_CONFIGS_ENABLE_KEY = "configcenter.auto-refresh-configs.enable";
    public static final String AUTO_REFRESH_CONFIGS_PERIOD_KEY = "configcenter.auto-refresh-configs.period";
    public static final ConfigcenterProperties INSTANCE = (ConfigcenterProperties)Contexts.buildProperties(ConfigcenterProperties.class);
    private boolean enable = true;
    private String appId = null;
    private String profileId = null;
    private String target = IPUtils.getIPV4();
    @NotBlank
    private String serverUrl;
    @NotBlank
    private String home = Contexts.getHome() + "/configcenter";
    private String priorTo = null;

    public String getRequiredAppId() {
        String appId = this.appId;
        if (appId == null) {
            appId = Contexts.getAppId();
        }
        Assert.notNull((Object)appId, (String)String.format("\u672a\u8bbe\u7f6e\u5e94\u7528id\uff08\u914d\u7f6ekey\uff1aconfigcenter.app-id\u6216\u8005%s\uff09", "spring.application.name"));
        return appId;
    }

    public String getRequiredProfileId() {
        if (this.profileId != null) {
            return this.profileId;
        }
        String[] profileIds = Contexts.getEnvironment().getActiveProfiles();
        if (profileIds.length <= 0) {
            throw new IllegalArgumentException(String.format("\u672a\u8bbe\u7f6e\u73af\u5883id\uff08\u914d\u7f6ekey\uff1aconfigcenter.profile-id\u6216\u8005%s\uff09", "spring.profiles.active"));
        }
        if (profileIds.length > 1) {
            throw new IllegalArgumentException(String.format("\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a\u73af\u5883id\uff08\u914d\u7f6ekey\uff1aconfigcenter.profile-id\u6216\u8005%s\uff09\uff0c\u5f53\u524d\u8bbe\u7f6e\u4e86\u591a\u4e2a\u73af\u5883id%s", "spring.profiles.active", ToString.toString((Object)profileIds)));
        }
        return profileIds[0];
    }

    public String computeHome() {
        if (Objects.equals(this.home, Boolean.FALSE.toString())) {
            return null;
        }
        return this.home;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getPriorTo() {
        return this.priorTo;
    }

    public void setPriorTo(String priorTo) {
        this.priorTo = priorTo;
    }
}

