/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.api.sharedpreferences;

import android.content.SharedPreferences;
import org.androidannotations.api.sharedpreferences.AbstractPrefField;

public final class IntPrefField
extends AbstractPrefField<Integer> {
    IntPrefField(SharedPreferences sharedPreferences, String key, Integer defaultValue) {
        super(sharedPreferences, key, defaultValue);
    }

    @Override
    public Integer getOr(Integer defaultValue) {
        try {
            return this.sharedPreferences.getInt(this.key, defaultValue.intValue());
        }
        catch (ClassCastException e) {
            try {
                String value = this.sharedPreferences.getString(this.key, "" + defaultValue);
                return Integer.parseInt(value);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    @Override
    protected void putInternal(Integer value) {
        this.apply(this.edit().putInt(this.key, value.intValue()));
    }
}

