/*
 * Decompiled with CFR 0.152.
 */
package org.anasthase.androidseekbarpreference;

import android.content.Context;
import android.content.res.TypedArray;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.SeekBar;
import android.widget.TextView;
import java.util.IllegalFormatException;
import org.anasthase.androidseekbarpreference.R;

public class SeekBarPreference
extends Preference {
    private View mContainer = null;
    private int mDefaultValue;
    private int mMinValue;
    private int mMaxValue;
    private int mStepValue;
    private int mDisplayDividerValue;
    private boolean mUseDisplayDividerValue;
    private String mFormat;
    private int mSteppedMinValue;
    private int mSteppedMaxValue;
    private TextView mTitle;
    private TextView mSummary;
    private TextView mValue;
    private SeekBar mSeekBar;
    private SeekBar.OnSeekBarChangeListener mListener = null;

    public SeekBarPreference(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SeekBarPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.SeekBarPreference);
            this.mMinValue = a.getInt(R.styleable.SeekBarPreference_minValue, 0);
            this.mMaxValue = a.getInt(R.styleable.SeekBarPreference_maxValue, 10);
            this.mStepValue = a.getInt(R.styleable.SeekBarPreference_stepValue, 1);
            this.mDefaultValue = a.getInt(R.styleable.SeekBarPreference_android_defaultValue, 0);
            if (a.hasValue(R.styleable.SeekBarPreference_displayDividerValue)) {
                this.mUseDisplayDividerValue = true;
                this.mDisplayDividerValue = a.getInt(R.styleable.SeekBarPreference_displayDividerValue, 1);
            } else {
                this.mUseDisplayDividerValue = false;
                this.mDisplayDividerValue = 1;
            }
            if (this.mMinValue < 0) {
                this.mMinValue = 0;
            }
            if (this.mMaxValue <= this.mMinValue) {
                this.mMaxValue = this.mMinValue + 1;
            }
            if (this.mDefaultValue < this.mMinValue) {
                this.mDefaultValue = this.mMinValue;
            } else if (this.mDefaultValue > this.mMaxValue) {
                this.mDefaultValue = this.mMaxValue;
            }
            if (this.mStepValue <= 0) {
                this.mStepValue = 1;
            }
            this.mFormat = a.getString(R.styleable.SeekBarPreference_format);
            a.recycle();
        } else {
            this.mMinValue = 0;
            this.mMaxValue = 10;
            this.mStepValue = 1;
            this.mDefaultValue = 0;
        }
        this.mSteppedMinValue = Math.round(this.mMinValue / this.mStepValue);
        this.mSteppedMaxValue = Math.round(this.mMaxValue / this.mStepValue);
    }

    protected View onCreateView(ViewGroup parent) {
        if (this.mContainer == null) {
            LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
            this.mContainer = inflater.inflate(R.layout.seekbar_preference, null);
            this.mTitle = (TextView)this.mContainer.findViewById(R.id.SeekBarPreferenceTitle);
            this.mTitle.setText(this.getTitle());
            this.mSummary = (TextView)this.mContainer.findViewById(R.id.SeekBarPreferenceSummary);
            if (!TextUtils.isEmpty((CharSequence)this.getSummary())) {
                this.mSummary.setText(this.getSummary());
            } else {
                this.mSummary.setVisibility(8);
            }
            this.mValue = (TextView)this.mContainer.findViewById(R.id.SeekBarPreferenceValue);
            this.mSeekBar = (SeekBar)this.mContainer.findViewById(R.id.SeekBarPreferenceSeekBar);
            this.mSeekBar.setMax(this.mSteppedMaxValue - this.mSteppedMinValue);
            this.setValue(PreferenceManager.getDefaultSharedPreferences((Context)this.getContext()).getInt(this.getKey(), this.mDefaultValue));
            this.mSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

                public void onStopTrackingTouch(SeekBar seekBar) {
                    if (SeekBarPreference.this.mListener != null) {
                        SeekBarPreference.this.mListener.onStopTrackingTouch(seekBar);
                    }
                    SeekBarPreference.this.saveValue();
                }

                public void onStartTrackingTouch(SeekBar seekBar) {
                    if (SeekBarPreference.this.mListener != null) {
                        SeekBarPreference.this.mListener.onStartTrackingTouch(seekBar);
                    }
                }

                public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                    if (SeekBarPreference.this.mListener != null) {
                        SeekBarPreference.this.mListener.onProgressChanged(seekBar, SeekBarPreference.this.getValue(), fromUser);
                    }
                    SeekBarPreference.this.updateDisplay(progress);
                }
            });
        }
        return this.mContainer;
    }

    public void setOnSeekBarChangeListener(SeekBar.OnSeekBarChangeListener listener) {
        this.mListener = listener;
    }

    public int getMinValue() {
        return this.mMinValue;
    }

    public void setMinValue(int value) {
        this.mMinValue = value;
        this.updateAllValues();
    }

    public int getMaxValue() {
        return this.mMaxValue;
    }

    public void setMaxValue(int value) {
        this.mMaxValue = value;
        this.updateAllValues();
    }

    public int getStepValue() {
        return this.mStepValue;
    }

    public void setStepValue(int value) {
        this.mStepValue = value;
        this.updateAllValues();
    }

    public String getFormat() {
        return this.mFormat;
    }

    public void setFormat(String format) {
        this.mFormat = format;
        this.updateDisplay();
    }

    public void setFormat(int formatResId) {
        this.setFormat(this.getContext().getResources().getString(formatResId));
    }

    public int getValue() {
        return (this.mSeekBar.getProgress() + this.mSteppedMinValue) * this.mStepValue;
    }

    public void setValue(int value) {
        value = this.getBoundedValue(value) - this.mSteppedMinValue;
        this.mSeekBar.setProgress(value);
        this.updateDisplay(value);
    }

    public void setTitle(CharSequence title) {
        super.setTitle(title);
        this.mTitle.setText(title);
    }

    public void setTitle(int titleResId) {
        super.setTitle(titleResId);
        this.mTitle.setText(titleResId);
    }

    public void setSummary(CharSequence summary) {
        super.setSummary(summary);
        this.mSummary.setText(summary);
    }

    public void setSummary(int summaryResId) {
        super.setSummary(summaryResId);
        this.mSummary.setText(summaryResId);
    }

    private void updateAllValues() {
        int currentValue = this.getValue();
        if (this.mMaxValue <= this.mMinValue) {
            this.mMaxValue = this.mMinValue + 1;
        }
        this.mSteppedMinValue = Math.round(this.mMinValue / this.mStepValue);
        this.mSteppedMaxValue = Math.round(this.mMaxValue / this.mStepValue);
        this.mSeekBar.setMax(this.mSteppedMaxValue - this.mSteppedMinValue);
        currentValue = this.getBoundedValue(currentValue) - this.mSteppedMinValue;
        this.mSeekBar.setProgress(currentValue);
        this.updateDisplay(currentValue);
    }

    private int getBoundedValue(int value) {
        if ((value = Math.round(value / this.mStepValue)) < this.mSteppedMinValue) {
            value = this.mSteppedMinValue;
        }
        if (value > this.mSteppedMaxValue) {
            value = this.mSteppedMaxValue;
        }
        return value;
    }

    private void updateDisplay() {
        this.updateDisplay(this.mSeekBar.getProgress());
    }

    private void updateDisplay(int value) {
        if (!TextUtils.isEmpty((CharSequence)this.mFormat)) {
            String text;
            this.mValue.setVisibility(0);
            value = (value + this.mSteppedMinValue) * this.mStepValue;
            try {
                if (this.mUseDisplayDividerValue) {
                    float floatValue = (float)value / (float)this.mDisplayDividerValue;
                    text = String.format(this.mFormat, Float.valueOf(floatValue));
                } else {
                    text = String.format(this.mFormat, value);
                }
            }
            catch (IllegalFormatException e) {
                text = Integer.toString(value);
            }
            this.mValue.setText((CharSequence)text);
        } else {
            this.mValue.setVisibility(8);
        }
    }

    private void saveValue() {
        PreferenceManager.getDefaultSharedPreferences((Context)this.getContext()).edit().putInt(this.getKey(), this.getValue()).apply();
    }
}

