/*
 * Decompiled with CFR 0.152.
 */
package org.altmail.displaytextview;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.support.v7.widget.AppCompatTextView;
import android.text.Layout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.TextView;
import org.altmail.displaytextview.R;

public class DisplayTextView
extends AppCompatTextView
implements ValueAnimator.AnimatorUpdateListener {
    private CharSequence mText;
    private final TextPaint mPaint;
    private float mProgress = 1.0f;
    private float mMaxTextSize;
    private float mTextSize;
    private int mAnimationDuration;
    private int mCharacterAnimatedTogether;
    private boolean mMultiLineAnimation;
    private boolean mAnimationDurationChanged;
    private boolean mInterpolatorChanged;
    private boolean mAnimatorListenerChanged;
    private boolean mHideUntilAnimation;
    private Interpolator mInterpolator;
    private float[] mCharWidthList;
    private Animator.AnimatorListener mAnimatorListener;
    private final ValueAnimator mValueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
    private static final int MAX_ALPHA = 255;
    private static final int DEFAULT_ANIMATION_DURATION_PER_CHARACTER = 150;
    private static final int DEFAULT_MAX_SIZE_FACTOR = 2;
    private static final int DEFAULT_CHARACTERS_ANIMATED_TOGETHER = 2;
    private static final float HALF_DIVIDER = 2.0f;
    private static final float FLOAT_TO_INT_ROUND_VALUE = 0.5f;
    private static final int LINEAR_INTERPOLATOR_ID = 0;
    private static final int DECELERATE_INTERPOLATOR_ID = 1;
    private static final int ACCELERATE_INTERPOLATOR_ID = 2;
    private static final int ACCELERATE_DECELERATE_INTERPOLATOR_ID = 3;
    private static final float ANIMATION_MIN_VALUE = 0.0f;
    private static final float ANIMATION_MAX_VALUE = 1.0f;
    private static final double ZOOM_DIFF_DIVIDER = 2.9;

    public DisplayTextView(Context context) {
        this(context, null);
    }

    public DisplayTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DisplayTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int interpolator;
        boolean autoSizePadding;
        this.mText = this.getText();
        this.mPaint = this.getPaint();
        this.initAnimation();
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.DisplayTextView);
            this.mMaxTextSize = typedArray.getDimension(R.styleable.DisplayTextView_MaxTextSize, this.getDefaultMaxTextSize());
            this.mMultiLineAnimation = typedArray.getBoolean(R.styleable.DisplayTextView_MultiLineAnimation, true);
            this.mCharacterAnimatedTogether = typedArray.getInteger(R.styleable.DisplayTextView_CharacterAnimatedTogether, 2);
            this.mAnimationDuration = typedArray.getInt(R.styleable.DisplayTextView_AnimationDuration, this.getDefaultAnimationDuration());
            this.mHideUntilAnimation = typedArray.getBoolean(R.styleable.DisplayTextView_hideUntilAnimation, true);
            autoSizePadding = typedArray.getBoolean(R.styleable.DisplayTextView_AutoSizePadding, true);
            interpolator = typedArray.getInteger(R.styleable.DisplayTextView_TextViewInterpolator, 0);
            typedArray.recycle();
        } else {
            this.mMaxTextSize = this.getDefaultMaxTextSize();
            this.mMultiLineAnimation = true;
            this.mCharacterAnimatedTogether = 2;
            this.mAnimationDuration = this.getDefaultAnimationDuration();
            this.mHideUntilAnimation = true;
            autoSizePadding = true;
            interpolator = 0;
        }
        if (autoSizePadding) {
            this.autoSizePadding();
        }
        switch (interpolator) {
            case 0: {
                this.mInterpolator = new LinearInterpolator();
                break;
            }
            case 1: {
                this.mInterpolator = new DecelerateInterpolator();
                break;
            }
            case 2: {
                this.mInterpolator = new AccelerateInterpolator();
                break;
            }
            case 3: {
                this.mInterpolator = new AccelerateDecelerateInterpolator();
            }
        }
        this.mValueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        this.mAnimatorListenerChanged = true;
        this.mAnimationDurationChanged = true;
        this.mInterpolatorChanged = true;
        this.mTextSize = this.getTextSize();
    }

    public void onDraw(Canvas canvas) {
        if (!this.mHideUntilAnimation) {
            Layout layout = this.getLayout();
            double d = 1.0 / (double)this.mText.length() * (double)((float)(this.mCharacterAnimatedTogether + 1) / 2.0f);
            int paddingTop = this.getPaddingTop();
            TextPaint paint = this.mPaint;
            float progress = this.mProgress;
            float textSize = this.mTextSize;
            boolean multiLineAnimation = this.mMultiLineAnimation;
            double characterAnimatedTogether = this.mCharacterAnimatedTogether;
            CharSequence text = this.mText;
            float[] charWidthList = this.mCharWidthList;
            float maxTextSize = this.mMaxTextSize;
            int paddingLeft = Build.VERSION.SDK_INT >= 17 ? this.getPaddingStart() : this.getPaddingLeft();
            paint.setColor(this.getCurrentTextColor());
            int gapIndex = 0;
            for (int i = 0; i < layout.getLineCount(); ++i) {
                int lineStart = layout.getLineStart(i);
                int lineEnd = layout.getLineEnd(i);
                float lineLeft = layout.getLineLeft(i) + (float)paddingLeft;
                float lineBaseline = layout.getLineBaseline(i) + paddingTop;
                String lineText = text.subSequence(lineStart, lineEnd).toString();
                for (int j = 0; j < lineText.length(); ++j) {
                    int pos;
                    int n = pos = multiLineAnimation ? j : gapIndex;
                    if ((double)progress <= (double)pos * (d / characterAnimatedTogether) + d) {
                        if ((double)progress > (double)pos * (d / characterAnimatedTogether)) {
                            double tmpProgress = (double)progress - (double)pos * (d / characterAnimatedTogether);
                            int alpha = (int)(tmpProgress / d * 255.0);
                            double zoomDiff = (double)(maxTextSize - textSize) * (1.0 - tmpProgress / d);
                            double zoomSize = (double)textSize + zoomDiff;
                            paint.setAlpha(alpha);
                            paint.setTextSize((float)zoomSize);
                            canvas.drawText(String.valueOf(lineText.charAt(j)), (float)((double)lineLeft - zoomDiff / 2.9), (float)((double)lineBaseline + zoomDiff / 2.9), (Paint)paint);
                        }
                    } else {
                        paint.setAlpha(255);
                        paint.setTextSize(textSize);
                        canvas.drawText(String.valueOf(lineText.charAt(j)), lineLeft, lineBaseline, (Paint)paint);
                    }
                    lineLeft += charWidthList[gapIndex++];
                }
            }
        }
    }

    public void startAnimation() {
        if (this.mValueAnimator.isStarted()) {
            this.mValueAnimator.cancel();
        }
        this.initAnimation();
        if (this.mAnimationDuration == 0 || this.mAnimationDurationChanged) {
            this.mValueAnimator.setDuration((long)this.mAnimationDuration);
            this.mAnimationDurationChanged = false;
        }
        if (this.mInterpolator != null && this.mInterpolatorChanged) {
            this.mValueAnimator.setInterpolator((TimeInterpolator)this.mInterpolator);
            this.mInterpolatorChanged = false;
        }
        if (this.mAnimatorListener != null && this.mAnimatorListenerChanged) {
            this.mValueAnimator.removeAllListeners();
            this.mValueAnimator.addListener(this.mAnimatorListener);
            this.mAnimatorListenerChanged = false;
        }
        if (this.mHideUntilAnimation) {
            this.mHideUntilAnimation = false;
        }
        this.mValueAnimator.start();
    }

    private void initAnimation() {
        this.mPaint.setTextSize(this.mTextSize);
        this.mCharWidthList = new float[this.mText.length()];
        for (int i = 0; i < this.mText.length(); ++i) {
            this.mCharWidthList[i] = this.mPaint.measureText(String.valueOf(this.mText.charAt(i)));
        }
    }

    private void autoSizePadding() {
        int newPadding = (int)((this.mMaxTextSize - this.mTextSize) / 2.0f + 0.5f);
        this.setPadding(newPadding, newPadding, newPadding, newPadding);
    }

    public void setMaxTextSize(float maxTextSize, boolean paddingAutoSize) {
        this.setMaxTextSize(2, maxTextSize, paddingAutoSize);
    }

    public void setMaxTextSize(int unit, float maxTextSize, boolean paddingAutoSize) {
        if (!this.mValueAnimator.isStarted()) {
            this.mMaxTextSize = TypedValue.applyDimension((int)unit, (float)maxTextSize, (DisplayMetrics)this.getResources().getDisplayMetrics());
            if (paddingAutoSize) {
                this.autoSizePadding();
            }
        }
    }

    public void setAnimationDuration(int animationDuration) {
        this.mAnimationDuration = animationDuration;
        this.mAnimationDurationChanged = true;
    }

    public void setCharacterAnimatedTogether(int characterAnimatedTogether) {
        if (!this.mValueAnimator.isStarted()) {
            this.mCharacterAnimatedTogether = characterAnimatedTogether;
        }
    }

    public void setMultiLineAnimation(boolean multiLineAnimation) {
        if (!this.mValueAnimator.isStarted()) {
            this.mMultiLineAnimation = multiLineAnimation;
        }
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
        this.mInterpolatorChanged = true;
    }

    public void setAnimatorListener(Animator.AnimatorListener animatorListener) {
        this.mAnimatorListener = animatorListener;
        this.mAnimatorListenerChanged = true;
    }

    public void setHideUntilAnimation(boolean hideUntilAnimation) {
        this.mHideUntilAnimation = hideUntilAnimation;
        this.invalidate();
    }

    private float getDefaultMaxTextSize() {
        return this.getTextSize() * 2.0f;
    }

    private int getDefaultAnimationDuration() {
        return this.mText.length() * 150;
    }

    public float getFinalTextSize() {
        return this.mTextSize;
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (this.paramChangeAllowed()) {
            if (this.mPaint != null) {
                this.mText = text;
                this.initAnimation();
            }
            super.setText(text, type);
        }
    }

    public void setTextSize(int unit, float size) {
        if (this.paramChangeAllowed()) {
            super.setTextSize(unit, size);
            if (this.mPaint != null) {
                this.mTextSize = this.getTextSize();
                this.initAnimation();
            }
        }
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        this.mProgress = ((Float)animation.getAnimatedValue()).floatValue();
        this.invalidate();
    }

    private boolean paramChangeAllowed() {
        return this.mValueAnimator == null || !this.mValueAnimator.isStarted();
    }
}

