/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.altbeacon.beacon.logging.LogManager;

public class Callback
implements Serializable {
    private static final String TAG = "Callback";
    private transient Intent intent;
    private String intentPackageName;

    public Callback(String intentPackageName) {
        this.intentPackageName = intentPackageName;
        this.initializeIntent();
    }

    private void initializeIntent() {
        if (this.intentPackageName != null) {
            this.intent = new Intent();
            this.intent.setComponent(new ComponentName(this.intentPackageName, "org.altbeacon.beacon.BeaconIntentProcessor"));
        }
    }

    public Intent getIntent() {
        return this.intent;
    }

    public boolean call(Context context, String dataName, Parcelable data) {
        if (this.intent != null) {
            LogManager.d(TAG, "attempting callback via intent: %s", this.intent.getComponent());
            this.intent.putExtra(dataName, data);
            context.startService(this.intent);
            return true;
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeIntent();
    }
}

