/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import java.lang.reflect.Constructor;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.RssiFilter;
import org.altbeacon.beacon.service.RunningAverageRssiFilter;

public class RangedBeacon {
    private static final String TAG = "RangedBeacon";
    public static final long DEFAULT_MAX_TRACKING_AGE = 5000L;
    public static long maxTrackingAge = 5000L;
    public static final long DEFAULT_SAMPLE_EXPIRATION_MILLISECONDS = 20000L;
    private static long sampleExpirationMilliseconds = 20000L;
    private boolean mTracked = true;
    protected long lastTrackedTimeMillis = 0L;
    Beacon mBeacon;
    protected RssiFilter filter = null;

    public RangedBeacon(Beacon beacon) {
        try {
            Constructor<?> cons = BeaconManager.getRssiFilterImplClass().getConstructors()[0];
            this.filter = (RssiFilter)cons.newInstance(new Object[0]);
        }
        catch (Exception e) {
            LogManager.e(TAG, "Could not construct RssiFilterImplClass %s", BeaconManager.getRssiFilterImplClass().getName());
        }
        RunningAverageRssiFilter.setSampleExpirationMilliseconds(sampleExpirationMilliseconds);
        this.updateBeacon(beacon);
    }

    public void updateBeacon(Beacon beacon) {
        this.mBeacon = beacon;
        this.addMeasurement(this.mBeacon.getRssi());
    }

    public boolean isTracked() {
        return this.mTracked;
    }

    public void setTracked(boolean tracked) {
        this.mTracked = tracked;
    }

    public Beacon getBeacon() {
        return this.mBeacon;
    }

    public void commitMeasurements() {
        if (!this.filter.noMeasurementsAvailable()) {
            double runningAverage = this.filter.calculateRssi();
            this.mBeacon.setRunningAverageRssi(runningAverage);
            LogManager.d(TAG, "calculated new runningAverageRssi: %s", runningAverage);
        } else {
            LogManager.d(TAG, "No measurements available to calculate running average", new Object[0]);
        }
    }

    public void addMeasurement(Integer rssi) {
        if (rssi != 127) {
            this.mTracked = true;
            this.lastTrackedTimeMillis = System.currentTimeMillis();
            this.filter.addMeasurement(rssi);
        }
    }

    public static void setSampleExpirationMilliseconds(long milliseconds) {
        sampleExpirationMilliseconds = milliseconds;
    }

    public static void setMaxTrackinAge(int maxTrackinAge) {
        maxTrackingAge = maxTrackinAge;
    }

    public boolean noMeasurementsAvailable() {
        return this.filter.noMeasurementsAvailable();
    }

    public long getTrackingAge() {
        return System.currentTimeMillis() - this.lastTrackedTimeMillis;
    }

    public boolean isExpired() {
        return this.getTrackingAge() > maxTrackingAge;
    }
}

