/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service.scanner;

import android.annotation.TargetApi;
import android.bluetooth.le.ScanFilter;
import java.util.ArrayList;
import java.util.List;
import org.altbeacon.beacon.BeaconParser;

@TargetApi(value=21)
public class ScanFilterUtils {
    public List<ScanFilterData> createScanFilterDataForBeaconParser(BeaconParser beaconParser) {
        ArrayList<ScanFilterData> scanFilters = new ArrayList<ScanFilterData>();
        for (int manufacturer : beaconParser.getHardwareAssistManufacturers()) {
            long typeCode = beaconParser.getMatchingBeaconTypeCode();
            int startOffset = beaconParser.getMatchingBeaconTypeCodeStartOffset();
            int endOffset = beaconParser.getMatchingBeaconTypeCodeEndOffset();
            byte[] filter = new byte[endOffset + 1 - 2];
            byte[] mask = new byte[endOffset + 1 - 2];
            byte[] typeCodeBytes = BeaconParser.longToByteArray(typeCode, endOffset - startOffset + 1);
            for (int layoutIndex = 2; layoutIndex <= endOffset; ++layoutIndex) {
                int filterIndex = layoutIndex - 2;
                if (layoutIndex < startOffset) {
                    filter[filterIndex] = 0;
                    mask[filterIndex] = 0;
                    continue;
                }
                filter[filterIndex] = typeCodeBytes[layoutIndex - startOffset];
                mask[filterIndex] = -1;
            }
            ScanFilterData sfd = new ScanFilterData();
            sfd.manufacturer = manufacturer;
            sfd.filter = filter;
            sfd.mask = mask;
            scanFilters.add(sfd);
        }
        return scanFilters;
    }

    public List<ScanFilter> createScanFiltersForBeaconParsers(List<BeaconParser> beaconParsers) {
        ArrayList<ScanFilter> scanFilters = new ArrayList<ScanFilter>();
        for (BeaconParser beaconParser : beaconParsers) {
            List<ScanFilterData> sfds = this.createScanFilterDataForBeaconParser(beaconParser);
            for (ScanFilterData sfd : sfds) {
                ScanFilter.Builder builder = new ScanFilter.Builder();
                builder.setManufacturerData(sfd.manufacturer, sfd.filter, sfd.mask);
                ScanFilter scanFilter = builder.build();
                scanFilters.add(scanFilter);
            }
        }
        return scanFilters;
    }

    class ScanFilterData {
        public int manufacturer;
        public byte[] filter;
        public byte[] mask;

        ScanFilterData() {
        }
    }
}

