/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.altbeacon.beacon.logging.LogManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/altbeacon/beacon/utils/PermissionsInspector;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "hasDeclaredBluetoothScanPermissions", "", "hasPermission", "permission", "", "permissionFlag", "", "(Ljava/lang/String;Ljava/lang/Integer;)Z", "Companion", "android-beacon-library_release"})
public final class PermissionsInspector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    private static final String TAG = PermissionsInspector.class.getSimpleName();

    public PermissionsInspector(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public final boolean hasDeclaredBluetoothScanPermissions() {
        boolean ok = true;
        if (!PermissionsInspector.hasPermission$default(this, "android.permission.BLUETOOTH", null, 2, null)) {
            LogManager.e(TAG, "BLUETOOTH permission not declared in AndroidManifest.xml.  Will not be able to scan for bluetooth beacons", new Object[0]);
            ok = false;
        }
        if (!PermissionsInspector.hasPermission$default(this, "android.permission.BLUETOOTH_ADMIN", null, 2, null)) {
            LogManager.e(TAG, "BLUETOOTH_ADMIN permission not declared in AndroidManifest.xml.  Will not be able to scan for bluetooth beacons", new Object[0]);
            ok = false;
        }
        if (!PermissionsInspector.hasPermission$default(this, "android.permission.ACCESS_FINE_LOCATION", null, 2, null) && !PermissionsInspector.hasPermission$default(this, "android.permission.ACCESS_COARSE_LOCATION", null, 2, null)) {
            LogManager.e(TAG, "Neither ACCESS_FINE_LOCATION nor ACCESS_COARSE_LOCATION permission declared in AndroidManifest.xml.  Will not be able to scan for bluetooth beacons", new Object[0]);
            ok = false;
        }
        if (this.hasPermission("android.permission.BLUETOOTH_SCAN", 65536)) {
            LogManager.e(TAG, "The neverForLocation permission flag is attached to BLUETOOTH_SCAN permission AndroidManifest.xml.  This will block detection of bluetooth beacons.  Please remove this from your AndroidManifest.xml, and if you don't see it, check the merged manifest in Android Studio, because it may have been added by another library you are using.", new Object[0]);
            ok = false;
        }
        if (!PermissionsInspector.hasPermission$default(this, "android.permission.ACCESS_BACKGROUND_LOCATION", null, 2, null)) {
            LogManager.w(TAG, "ACCESS_BACKGROUND_LOCATION permission not declared in AndroidManifest.xml.  Will not be able to scan for bluetooth beacons", new Object[0]);
        }
        return ok;
    }

    public final boolean hasPermission(@NotNull String permission2, @Nullable Integer permissionFlag) {
        Intrinsics.checkNotNullParameter((Object)permission2, (String)"permission");
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 4096);
            Intrinsics.checkNotNullExpressionValue((Object)packageInfo, (String)"context.getPackageManage\u2026PERMISSIONS\n            )");
            PackageInfo info = packageInfo;
            if (info.requestedPermissions != null) {
                Intrinsics.checkNotNullExpressionValue((Object)info.requestedPermissions, (String)"info.requestedPermissions");
                for (String p : info.requestedPermissions) {
                    if (!Intrinsics.areEqual((Object)p, (Object)permission2)) continue;
                    if (permissionFlag != null && Build.VERSION.SDK_INT >= 16) {
                        Intrinsics.checkNotNullExpressionValue((Object)info.requestedPermissionsFlags, (String)"info.requestedPermissionsFlags");
                        for (int flag : info.requestedPermissionsFlags) {
                            if ((flag & permissionFlag) == 0) continue;
                            return true;
                        }
                        return false;
                    }
                    return true;
                }
            }
        }
        catch (RuntimeException e) {
            LogManager.e(TAG, "Can't read permissions", new Object[0]);
        }
        return false;
    }

    public static /* synthetic */ boolean hasPermission$default(PermissionsInspector permissionsInspector, String string, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return permissionsInspector.hasPermission(string, n);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/altbeacon/beacon/utils/PermissionsInspector$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "android-beacon-library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

