/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.ServiceStartNotAllowedException;
import android.bluetooth.BluetoothManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.altbeacon.beacon.AltBeaconParser;
import org.altbeacon.beacon.BeaconConsumer;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.BleNotAvailableException;
import org.altbeacon.beacon.InternalBeaconConsumer;
import org.altbeacon.beacon.MonitorNotifier;
import org.altbeacon.beacon.RangeNotifier;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.RegionViewModel;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.logging.Loggers;
import org.altbeacon.beacon.powersave.BackgroundPowerSaverInternal;
import org.altbeacon.beacon.service.BeaconService;
import org.altbeacon.beacon.service.Callback;
import org.altbeacon.beacon.service.IntentScanStrategyCoordinator;
import org.altbeacon.beacon.service.MonitoringStatus;
import org.altbeacon.beacon.service.RangeState;
import org.altbeacon.beacon.service.RangedBeacon;
import org.altbeacon.beacon.service.RegionMonitoringState;
import org.altbeacon.beacon.service.RunningAverageRssiFilter;
import org.altbeacon.beacon.service.ScanJobScheduler;
import org.altbeacon.beacon.service.SettingsData;
import org.altbeacon.beacon.service.StartRMData;
import org.altbeacon.beacon.service.scanner.NonBeaconLeScanCallback;
import org.altbeacon.beacon.simulator.BeaconSimulator;
import org.altbeacon.beacon.utils.ChangeAwareCopyOnWriteArrayList;
import org.altbeacon.beacon.utils.ChangeAwareCopyOnWriteArrayListNotifier;
import org.altbeacon.beacon.utils.ProcessUtils;

public class BeaconManager {
    @NonNull
    private static final String TAG = "BeaconManager";
    @NonNull
    private final Context mContext;
    @Nullable
    protected static volatile BeaconManager sInstance = null;
    @NonNull
    private final ConcurrentMap<InternalBeaconConsumer, ConsumerInfo> consumers = new ConcurrentHashMap<InternalBeaconConsumer, ConsumerInfo>();
    @Nullable
    private Messenger serviceMessenger = null;
    @NonNull
    protected final Set<RangeNotifier> rangeNotifiers = new CopyOnWriteArraySet<RangeNotifier>();
    @Nullable
    protected RangeNotifier dataRequestNotifier = null;
    @NonNull
    protected final Set<MonitorNotifier> monitorNotifiers = new CopyOnWriteArraySet<MonitorNotifier>();
    @NonNull
    private final Set<Region> rangedRegions = new CopyOnWriteArraySet<Region>();
    @NonNull
    private final Set<Region> autoBindRangedRegions = new HashSet<Region>();
    @NonNull
    private final Set<Region> autoBindMonitoredRegions = new HashSet<Region>();
    @NonNull
    private final List<BeaconParser> beaconParsers;
    @Nullable
    private NonBeaconLeScanCallback mNonBeaconLeScanCallback;
    private boolean mRegionStatePersistenceEnabled = true;
    private boolean mBackgroundMode = false;
    private boolean mBackgroundModeUninitialized = true;
    private boolean mMainProcess = false;
    @Nullable
    private Boolean mScannerInSameProcess = null;
    private boolean mScheduledScanJobsEnabled = false;
    private boolean mScheduledScanJobsEnabledByFallback = false;
    @Nullable
    private IntentScanStrategyCoordinator mIntentScanStrategyCoordinator = null;
    private static boolean sAndroidLScanningDisabled = false;
    private static boolean sManifestCheckingDisabled = false;
    @Nullable
    private Notification mForegroundServiceNotification = null;
    private int mForegroundServiceNotificationId = -1;
    private Handler mServiceSyncHandler = new Handler(Looper.getMainLooper());
    private boolean mServiceSyncScheduled = false;
    private static final Object SINGLETON_LOCK = new Object();
    public static final long DEFAULT_FOREGROUND_SCAN_PERIOD = 1100L;
    public static final long DEFAULT_FOREGROUND_BETWEEN_SCAN_PERIOD = 0L;
    public static final long DEFAULT_BACKGROUND_SCAN_PERIOD = 10000L;
    public static final long DEFAULT_BACKGROUND_BETWEEN_SCAN_PERIOD = 300000L;
    public static final long DEFAULT_EXIT_PERIOD = 10000L;
    private static long sExitRegionPeriod = 10000L;
    private long foregroundScanPeriod = 1100L;
    private long foregroundBetweenScanPeriod = 0L;
    private long backgroundScanPeriod = 10000L;
    private long backgroundBetweenScanPeriod = 300000L;
    private HashMap<Region, RegionViewModel> mRegionViewModels = new HashMap();
    @Nullable
    protected static BeaconSimulator beaconSimulator;
    protected static String distanceModelUpdateUrl;
    protected static Class rssiFilterImplClass;
    @Nullable
    private BeaconConsumer autoBindConsumer = null;
    @Nullable
    BackgroundPowerSaverInternal mInternalBackgroundPowerSaver = null;

    public static void setDebug(boolean debug) {
        if (debug) {
            LogManager.setLogger(Loggers.verboseLogger());
            LogManager.setVerboseLoggingEnabled(true);
        } else {
            LogManager.setLogger(Loggers.empty());
            LogManager.setVerboseLoggingEnabled(false);
        }
    }

    @NonNull
    public RegionViewModel getRegionViewModel(Region region) {
        RegionViewModel regionViewModel = this.mRegionViewModels.get(region);
        if (regionViewModel != null) {
            return regionViewModel;
        }
        regionViewModel = new RegionViewModel();
        this.mRegionViewModels.put(region, regionViewModel);
        return regionViewModel;
    }

    public boolean isRegionViewModelInitialized(Region region) {
        return this.mRegionViewModels.get(region) != null;
    }

    public void setForegroundScanPeriod(long p) {
        LogManager.d(TAG, "API setForegroundScanPeriod " + p, new Object[0]);
        this.foregroundScanPeriod = p;
    }

    public void setForegroundBetweenScanPeriod(long p) {
        LogManager.d(TAG, "API setForegroundBetweenScanPeriod " + p, new Object[0]);
        this.foregroundBetweenScanPeriod = p;
    }

    public void setBackgroundScanPeriod(long p) {
        LogManager.d(TAG, "API setBackgroundScanPeriod " + p, new Object[0]);
        this.backgroundScanPeriod = p;
    }

    public void setBackgroundBetweenScanPeriod(long p) {
        LogManager.d(TAG, "API setBackgroundBetweenScanPeriod " + p, new Object[0]);
        this.backgroundBetweenScanPeriod = p;
        if (Build.VERSION.SDK_INT >= 26 && this.backgroundBetweenScanPeriod < 900000L) {
            LogManager.w(TAG, "Setting a short backgroundBetweenScanPeriod has no effect on Android 8+, which is limited to scanning every ~15 minutes", new Object[0]);
        }
    }

    public static void setRegionExitPeriod(long regionExitPeriod) {
        LogManager.d(TAG, "API setRegionExitPeriod " + regionExitPeriod, new Object[0]);
        sExitRegionPeriod = regionExitPeriod;
        BeaconManager instance = sInstance;
        if (instance != null) {
            instance.applySettings();
        }
    }

    public static long getRegionExitPeriod() {
        return sExitRegionPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static BeaconManager getInstanceForApplication(@NonNull Context context) {
        BeaconManager instance = sInstance;
        if (instance == null) {
            Object object = SINGLETON_LOCK;
            synchronized (object) {
                instance = sInstance;
                if (instance == null) {
                    sInstance = instance = new BeaconManager(context);
                    LogManager.d(TAG, "API BeaconManager constructed ", new Object[0]);
                }
            }
        }
        return instance;
    }

    protected BeaconManager(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
        this.checkIfMainProcess();
        if (!sManifestCheckingDisabled) {
            this.verifyServiceDeclaration();
        }
        ChangeAwareCopyOnWriteArrayList<BeaconParser> beaconParsers = new ChangeAwareCopyOnWriteArrayList<BeaconParser>();
        beaconParsers.setNotifier(new ChangeAwareCopyOnWriteArrayListNotifier(){

            @Override
            public void onChange() {
                LogManager.d(BeaconManager.TAG, "API Beacon parsers changed", new Object[0]);
                BeaconManager.this.applySettings();
            }
        });
        this.beaconParsers = beaconParsers;
        this.beaconParsers.add(new AltBeaconParser());
        this.setScheduledScanJobsEnabledDefault();
    }

    public boolean isMainProcess() {
        return this.mMainProcess;
    }

    public boolean isScannerInDifferentProcess() {
        return this.mScannerInSameProcess != null && this.mScannerInSameProcess == false;
    }

    public void setScannerInSameProcess(boolean isScanner) {
        LogManager.d(TAG, "API setScannerInSameProcess " + isScanner, new Object[0]);
        this.mScannerInSameProcess = isScanner;
    }

    protected void checkIfMainProcess() {
        ProcessUtils processUtils = new ProcessUtils(this.mContext);
        String processName = processUtils.getProcessName();
        String packageName = processUtils.getPackageName();
        int pid = processUtils.getPid();
        this.mMainProcess = processUtils.isMainProcess();
        LogManager.i(TAG, "BeaconManager started up on pid " + pid + " named '" + processName + "' for application package '" + packageName + "'.  isMainProcess=" + this.mMainProcess, new Object[0]);
    }

    @NonNull
    public List<BeaconParser> getBeaconParsers() {
        return this.beaconParsers;
    }

    @TargetApi(value=18)
    public boolean checkAvailability() throws BleNotAvailableException {
        if (!this.isBleAvailableOrSimulated()) {
            throw new BleNotAvailableException("Bluetooth LE not supported by this device");
        }
        return ((BluetoothManager)this.mContext.getSystemService("bluetooth")).getAdapter().isEnabled();
    }

    @Deprecated
    public void bind(@NonNull BeaconConsumer consumer) {
        LogManager.d(TAG, "API bind", new Object[0]);
        this.bindInternal(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindInternal(@NonNull InternalBeaconConsumer consumer) {
        if (!this.isBleAvailableOrSimulated()) {
            LogManager.w(TAG, "Method invocation will be ignored.", new Object[0]);
            return;
        }
        ConcurrentMap<InternalBeaconConsumer, ConsumerInfo> concurrentMap = this.consumers;
        synchronized (concurrentMap) {
            boolean needToBind;
            ConsumerInfo newConsumerInfo = new ConsumerInfo();
            ConsumerInfo alreadyBoundConsumerInfo = this.consumers.putIfAbsent(consumer, newConsumerInfo);
            boolean bl = needToBind = this.mScheduledScanJobsEnabledByFallback || alreadyBoundConsumerInfo == null;
            if (!needToBind) {
                LogManager.d(TAG, "This consumer is already bound", new Object[0]);
            } else {
                if (this.mScheduledScanJobsEnabledByFallback) {
                    LogManager.d(TAG, "Need to rebind for switch to foreground service", consumer);
                    this.mScheduledScanJobsEnabledByFallback = false;
                } else {
                    LogManager.d(TAG, "This consumer is not bound.  Binding now: %s", consumer);
                }
                if (this.mIntentScanStrategyCoordinator != null) {
                    if (Build.VERSION.SDK_INT >= 26) {
                        this.mIntentScanStrategyCoordinator.start();
                    }
                    consumer.onBeaconServiceConnect();
                } else if (this.mScheduledScanJobsEnabled) {
                    LogManager.d(TAG, "Not starting beacon scanning service. Using scheduled jobs", new Object[0]);
                    consumer.onBeaconServiceConnect();
                } else {
                    LogManager.d(TAG, "Binding to service", new Object[0]);
                    Intent intent = new Intent(consumer.getApplicationContext(), BeaconService.class);
                    if (Build.VERSION.SDK_INT >= 26 && this.getForegroundServiceNotification() != null) {
                        if (this.isAnyConsumerBound() && !this.mScheduledScanJobsEnabledByFallback) {
                            LogManager.i(TAG, "Not starting foreground beacon scanning service.  A consumer is already bound, so it should be started", new Object[0]);
                        } else {
                            this.verifyLocationPermissionGrantedForForegroundService();
                            LogManager.i(TAG, "Attempting to starting foreground beacon scanning service.", new Object[0]);
                            try {
                                this.mContext.startForegroundService(intent);
                                if (this.mScheduledScanJobsEnabledByFallback) {
                                    LogManager.i(TAG, "Successfully switched to foreground service from fallback", new Object[0]);
                                    this.mScheduledScanJobsEnabledByFallback = false;
                                    ScanJobScheduler.getInstance().cancelSchedule(this.mContext);
                                } else {
                                    LogManager.i(TAG, "successfully started foreground beacon scanning service.", new Object[0]);
                                }
                            }
                            catch (ServiceStartNotAllowedException e) {
                                LogManager.w(TAG, "Foreground service blocked by ServiceStartNotAllowedException.  Falling back to job scheduler", new Object[0]);
                                this.mScheduledScanJobsEnabledByFallback = true;
                                this.syncSettingsToService();
                                return;
                            }
                        }
                    }
                    consumer.bindService(intent, newConsumerInfo.beaconServiceConnection, 1);
                }
                LogManager.d(TAG, "consumer count is now: %s", this.consumers.size());
            }
        }
    }

    public void handleStategyFailover() {
        boolean shouldFailover = false;
        if (this.mScheduledScanJobsEnabledByFallback) {
            if (this.isAnyConsumerBound()) {
                shouldFailover = true;
            } else {
                this.mScheduledScanJobsEnabledByFallback = false;
            }
        }
        if (this.mIntentScanStrategyCoordinator != null && this.mIntentScanStrategyCoordinator.getDisableOnFailure() && this.mIntentScanStrategyCoordinator.getLastStrategyFailureDetectionCount() > 0) {
            shouldFailover = true;
            this.mIntentScanStrategyCoordinator = null;
        }
        if (shouldFailover) {
            LogManager.i(TAG, "unbinding all consumers for stategy failover", new Object[0]);
            ArrayList oldConsumers = new ArrayList(this.consumers.keySet());
            for (InternalBeaconConsumer consumer : oldConsumers) {
                this.unbindInternal(consumer);
            }
            LogManager.i(TAG, "binding all consumers for strategy failover", new Object[0]);
            for (InternalBeaconConsumer consumer : oldConsumers) {
                this.bindInternal(consumer);
            }
            LogManager.i(TAG, "Done with failover", new Object[0]);
        }
    }

    @Deprecated
    public void unbind(@NonNull BeaconConsumer consumer) {
        LogManager.d(TAG, "API unbind", new Object[0]);
        this.unbindInternal(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindInternal(@NonNull InternalBeaconConsumer consumer) {
        block10: {
            if (!this.isBleAvailableOrSimulated()) {
                LogManager.w(TAG, "Method invocation will be ignored.", new Object[0]);
                return;
            }
            ConcurrentMap<InternalBeaconConsumer, ConsumerInfo> concurrentMap = this.consumers;
            synchronized (concurrentMap) {
                block9: {
                    if (!this.consumers.containsKey(consumer)) break block9;
                    LogManager.d(TAG, "Unbinding", new Object[0]);
                    if (this.mIntentScanStrategyCoordinator != null) {
                        LogManager.d(TAG, "Not unbinding as we are using intent scanning strategy", new Object[0]);
                    } else if (this.mScheduledScanJobsEnabled || this.mScheduledScanJobsEnabledByFallback) {
                        LogManager.d(TAG, "Not unbinding from scanning service as we are using scan jobs.", new Object[0]);
                    } else {
                        consumer.unbindService(((ConsumerInfo)this.consumers.get((Object)consumer)).beaconServiceConnection);
                    }
                    LogManager.d(TAG, "Before unbind, consumer count is " + this.consumers.size(), new Object[0]);
                    this.consumers.remove(consumer);
                    LogManager.d(TAG, "After unbind, consumer count is " + this.consumers.size(), new Object[0]);
                    if (this.consumers.size() != 0) break block10;
                    this.serviceMessenger = null;
                    if (!this.mScheduledScanJobsEnabled && !this.mScheduledScanJobsEnabledByFallback && this.mIntentScanStrategyCoordinator == null || Build.VERSION.SDK_INT < 21) break block10;
                    LogManager.i(TAG, "Cancelling scheduled jobs after unbind of last consumer.", new Object[0]);
                    ScanJobScheduler.getInstance().cancelSchedule(this.mContext);
                    break block10;
                }
                LogManager.d(TAG, "This consumer is not bound to: %s", consumer);
                LogManager.d(TAG, "Bound consumers: ", new Object[0]);
                Set consumers = this.consumers.entrySet();
                for (Map.Entry consumerEntry : consumers) {
                    LogManager.d(TAG, String.valueOf(consumerEntry.getValue()), new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean isBound(@NonNull BeaconConsumer consumer) {
        ConcurrentMap<InternalBeaconConsumer, ConsumerInfo> concurrentMap = this.consumers;
        synchronized (concurrentMap) {
            return consumer != null && this.consumers.get(consumer) != null && (this.mScheduledScanJobsEnabled || this.mScheduledScanJobsEnabledByFallback || this.serviceMessenger != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAnyConsumerBound() {
        ConcurrentMap<InternalBeaconConsumer, ConsumerInfo> concurrentMap = this.consumers;
        synchronized (concurrentMap) {
            return !this.consumers.isEmpty() && (this.mIntentScanStrategyCoordinator != null || this.mScheduledScanJobsEnabled || this.mScheduledScanJobsEnabledByFallback || this.serviceMessenger != null);
        }
    }

    @Deprecated
    public void setBackgroundMode(boolean backgroundMode) {
        LogManager.d(TAG, "API setBackgroundMode " + backgroundMode, new Object[0]);
        this.setBackgroundModeInternal(backgroundMode);
    }

    public void setBackgroundModeInternal(boolean backgroundMode) {
        LogManager.d(TAG, "API setBackgroundModeIternal " + backgroundMode, new Object[0]);
        if (!this.isBleAvailableOrSimulated()) {
            LogManager.w(TAG, "Method invocation will be ignored.", new Object[0]);
            return;
        }
        this.mBackgroundModeUninitialized = false;
        if (backgroundMode != this.mBackgroundMode) {
            if (!backgroundMode && this.getIntentScanStrategyCoordinator() != null) {
                this.getIntentScanStrategyCoordinator().performPeriodicProcessing(this.mContext);
            }
            this.mBackgroundMode = backgroundMode;
            try {
                this.updateScanPeriods();
            }
            catch (RemoteException e) {
                LogManager.e(TAG, "Cannot contact service to set scan periods", new Object[0]);
            }
        }
    }

    public void setEnableScheduledScanJobs(boolean enabled) {
        LogManager.d(TAG, "API setEnableScheduledScanJobs " + enabled, new Object[0]);
        if (this.isAnyConsumerBound()) {
            LogManager.e(TAG, "ScanJob may not be configured because a consumer is already bound.", new Object[0]);
            throw new IllegalStateException("Method must be called before starting ranging or monitoring");
        }
        if (enabled && Build.VERSION.SDK_INT < 21) {
            LogManager.e(TAG, "ScanJob may not be configured because JobScheduler is not availble prior to Android 5.0", new Object[0]);
            return;
        }
        if (!enabled && Build.VERSION.SDK_INT >= 26) {
            LogManager.w(TAG, "Disabling ScanJobs on Android 8+ may disable delivery of beacon callbacks in the background unless a foreground service is active.", new Object[0]);
        }
        if (enabled) {
            this.mScheduledScanJobsEnabledByFallback = false;
        }
        this.mScheduledScanJobsEnabled = enabled;
        if (!this.mScheduledScanJobsEnabled && !this.mScheduledScanJobsEnabledByFallback && Build.VERSION.SDK_INT >= 21) {
            ScanJobScheduler.getInstance().cancelSchedule(this.mContext);
        }
    }

    public void setIntentScanningStrategyEnabled(boolean enabled) {
        LogManager.d(TAG, "API setIntentScanningStrategyEnabled " + enabled, new Object[0]);
        if (this.isAnyConsumerBound()) {
            LogManager.e(TAG, "IntentScanningStrategy may not be configured because a consumer is already bound.", new Object[0]);
            throw new IllegalStateException("Method must be called before starting ranging or monitoring");
        }
        if (enabled && Build.VERSION.SDK_INT < 26) {
            LogManager.e(TAG, "IntentScanningStrategy may not be configured because Intent Scanning is not availble prior to Android 8.0", new Object[0]);
            return;
        }
        if (enabled && Build.VERSION.SDK_INT >= 26) {
            this.mScheduledScanJobsEnabled = false;
            this.mScheduledScanJobsEnabledByFallback = false;
            ScanJobScheduler.getInstance().cancelSchedule(this.mContext);
            this.mIntentScanStrategyCoordinator = new IntentScanStrategyCoordinator(this.mContext);
        } else {
            this.mIntentScanStrategyCoordinator = null;
        }
    }

    public IntentScanStrategyCoordinator getIntentScanStrategyCoordinator() {
        return this.mIntentScanStrategyCoordinator;
    }

    public boolean getScheduledScanJobsEnabled() {
        return this.mScheduledScanJobsEnabled;
    }

    public boolean getBackgroundMode() {
        return this.mBackgroundMode;
    }

    public long getBackgroundScanPeriod() {
        return this.backgroundScanPeriod;
    }

    public long getBackgroundBetweenScanPeriod() {
        return this.backgroundBetweenScanPeriod;
    }

    public long getForegroundScanPeriod() {
        return this.foregroundScanPeriod;
    }

    public long getForegroundBetweenScanPeriod() {
        return this.foregroundBetweenScanPeriod;
    }

    public boolean isBackgroundModeUninitialized() {
        return this.mBackgroundModeUninitialized;
    }

    @Deprecated
    public void setRangeNotifier(@Nullable RangeNotifier notifier) {
        LogManager.d(TAG, "API setRangeNotifier " + notifier, new Object[0]);
        this.rangeNotifiers.clear();
        if (null != notifier) {
            this.addRangeNotifier(notifier);
        }
    }

    public void addRangeNotifier(@NonNull RangeNotifier notifier) {
        LogManager.d(TAG, "API addRangeNotifier " + notifier, new Object[0]);
        if (notifier != null) {
            this.rangeNotifiers.add(notifier);
        }
    }

    public boolean removeRangeNotifier(@NonNull RangeNotifier notifier) {
        LogManager.d(TAG, "API removeRangeNotifier " + notifier, new Object[0]);
        return this.rangeNotifiers.remove(notifier);
    }

    public void removeAllRangeNotifiers() {
        LogManager.d(TAG, "API removeAllRangeNotifiers", new Object[0]);
        this.rangeNotifiers.clear();
    }

    @Deprecated
    public void setMonitorNotifier(@Nullable MonitorNotifier notifier) {
        LogManager.d(TAG, "API setMonitorNotifier " + notifier, new Object[0]);
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        this.monitorNotifiers.clear();
        if (null != notifier) {
            this.addMonitorNotifier(notifier);
        }
    }

    public void addMonitorNotifier(@NonNull MonitorNotifier notifier) {
        LogManager.d(TAG, "API addMonitorNotifier " + notifier, new Object[0]);
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        if (notifier != null) {
            this.monitorNotifiers.add(notifier);
        }
    }

    @Deprecated
    public boolean removeMonitoreNotifier(@NonNull MonitorNotifier notifier) {
        return this.removeMonitorNotifier(notifier);
    }

    public boolean removeMonitorNotifier(@NonNull MonitorNotifier notifier) {
        LogManager.d(TAG, "API removeMonitorNotifier " + notifier, new Object[0]);
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return false;
        }
        return this.monitorNotifiers.remove(notifier);
    }

    public void removeAllMonitorNotifiers() {
        LogManager.d(TAG, "API removeAllMonitorNotifiers", new Object[0]);
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        this.monitorNotifiers.clear();
    }

    @Deprecated
    public void setRegionStatePeristenceEnabled(boolean enabled) {
        this.setRegionStatePersistenceEnabled(enabled);
    }

    public void setRegionStatePersistenceEnabled(boolean enabled) {
        LogManager.d(TAG, "API setRegionStatePerisistenceEnabled " + enabled, new Object[0]);
        this.mRegionStatePersistenceEnabled = enabled;
        if (!this.isScannerInDifferentProcess()) {
            if (enabled) {
                MonitoringStatus.getInstanceForApplication(this.mContext).startStatusPreservation();
            } else {
                MonitoringStatus.getInstanceForApplication(this.mContext).stopStatusPreservation();
            }
        }
        this.applySettings();
    }

    public boolean isRegionStatePersistenceEnabled() {
        return this.mRegionStatePersistenceEnabled;
    }

    public void requestStateForRegion(@NonNull Region region) {
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        MonitoringStatus status = MonitoringStatus.getInstanceForApplication(this.mContext);
        RegionMonitoringState stateObj = status.stateOf(region);
        int state = 0;
        if (stateObj != null && stateObj.getInside()) {
            state = 1;
        }
        for (MonitorNotifier notifier : this.monitorNotifiers) {
            notifier.didDetermineStateForRegion(state, region);
        }
    }

    @Deprecated
    @TargetApi(value=18)
    public void startRangingBeaconsInRegion(@NonNull Region region) throws RemoteException {
        LogManager.d(TAG, "API startRangingBeaconsInRegion " + region, new Object[0]);
        LogManager.d(TAG, "startRangingBeaconsInRegion", new Object[0]);
        if (!this.isBleAvailableOrSimulated()) {
            LogManager.w(TAG, "Method invocation will be ignored.", new Object[0]);
            return;
        }
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        this.rangedRegions.remove(region);
        this.rangedRegions.add(region);
        this.applyChangesToServices(2, region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    public void startRangingBeacons(@NonNull Region region) {
        LogManager.d(TAG, "API startRangingBeacons " + region, new Object[0]);
        LogManager.d(TAG, "startRanging", new Object[0]);
        this.ensureBackgroundPowerSaver();
        if (this.isAnyConsumerBound()) {
            try {
                this.startRangingBeaconsInRegion(region);
            }
            catch (RemoteException e) {
                LogManager.e(TAG, "Failed to start ranging", new Object[]{e});
            }
        } else {
            Set<Region> set = this.autoBindRangedRegions;
            synchronized (set) {
                this.autoBindRangedRegions.remove(region);
                this.autoBindRangedRegions.add(region);
            }
            this.autoBind();
        }
    }

    @Deprecated
    @TargetApi(value=18)
    public void stopRangingBeaconsInRegion(@NonNull Region region) throws RemoteException {
        LogManager.d(TAG, "API stopRangingBeacons " + region, new Object[0]);
        LogManager.d(TAG, "stopRangingBeaconsInRegion", new Object[0]);
        if (!this.isBleAvailableOrSimulated()) {
            LogManager.w(TAG, "Method invocation will be ignored.", new Object[0]);
            return;
        }
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        this.rangedRegions.remove(region);
        this.applyChangesToServices(3, region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    public void stopRangingBeacons(@NonNull Region region) {
        LogManager.d(TAG, "API stopRangingBeacons " + region, new Object[0]);
        LogManager.d(TAG, "stopRangingBeacons", new Object[0]);
        this.ensureBackgroundPowerSaver();
        if (this.isAnyConsumerBound()) {
            try {
                this.stopRangingBeaconsInRegion(region);
            }
            catch (RemoteException e) {
                LogManager.e(TAG, "Cannot stop ranging", new Object[]{e});
            }
        } else {
            Set<Region> set = this.autoBindMonitoredRegions;
            synchronized (set) {
                this.autoBindRangedRegions.remove(region);
            }
        }
        this.autoUnbindIfNeeded();
    }

    public void applySettings() {
        LogManager.d(TAG, "API applySettings", new Object[0]);
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        if (!this.isAnyConsumerBound()) {
            LogManager.d(TAG, "Not synchronizing settings to service, as it has not started up yet", new Object[0]);
        } else {
            this.syncSettingsToService();
        }
    }

    protected synchronized void syncSettingsToService() {
        if (this.mIntentScanStrategyCoordinator != null) {
            this.mIntentScanStrategyCoordinator.applySettings();
            return;
        }
        if (this.mScheduledScanJobsEnabled || this.mScheduledScanJobsEnabledByFallback) {
            if (Build.VERSION.SDK_INT >= 21) {
                ScanJobScheduler.getInstance().applySettingsToScheduledJob(this.mContext, this);
            }
            return;
        }
        if (!this.isAnyConsumerBound()) {
            LogManager.d(TAG, "No settings sync to running service -- service not bound", new Object[0]);
            return;
        }
        if (!this.mServiceSyncScheduled) {
            this.mServiceSyncScheduled = true;
            LogManager.d(TAG, "API Scheduling settings sync to running service.", new Object[0]);
            this.mServiceSyncHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    BeaconManager.this.mServiceSyncScheduled = false;
                    try {
                        LogManager.d(BeaconManager.TAG, "API Performing settings sync to running service.", new Object[0]);
                        BeaconManager.this.applyChangesToServices(7, null);
                    }
                    catch (RemoteException e) {
                        LogManager.e(BeaconManager.TAG, "Failed to sync settings to service", new Object[]{e});
                    }
                }
            }, 100L);
        } else {
            LogManager.d(TAG, "Already scheduled settings sync to running service.", new Object[0]);
        }
    }

    @Deprecated
    @TargetApi(value=18)
    public void startMonitoringBeaconsInRegion(@NonNull Region region) throws RemoteException {
        LogManager.d(TAG, "API startMonitoringBeaconsInRegion " + region, new Object[0]);
        if (!this.isBleAvailableOrSimulated()) {
            LogManager.w(TAG, "Method invocation will be ignored.", new Object[0]);
            return;
        }
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        if (!this.isScannerInDifferentProcess()) {
            MonitoringStatus.getInstanceForApplication(this.mContext).addRegion(region, new Callback(this.callbackPackageName()));
        }
        this.applyChangesToServices(4, region);
        if (this.isScannerInDifferentProcess()) {
            MonitoringStatus.getInstanceForApplication(this.mContext).addLocalRegion(region);
        }
        this.requestStateForRegion(region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    public void startMonitoring(@NonNull Region region) {
        LogManager.d(TAG, "API startMonitoring " + region, new Object[0]);
        this.ensureBackgroundPowerSaver();
        if (this.isAnyConsumerBound()) {
            try {
                this.startMonitoringBeaconsInRegion(region);
            }
            catch (RemoteException e) {
                LogManager.e(TAG, "Failed to start monitoring", new Object[]{e});
            }
        } else {
            Set<Region> set = this.autoBindMonitoredRegions;
            synchronized (set) {
                this.autoBindMonitoredRegions.remove(region);
                this.autoBindMonitoredRegions.add(region);
            }
            this.autoBind();
        }
    }

    @Deprecated
    @TargetApi(value=18)
    public void stopMonitoringBeaconsInRegion(@NonNull Region region) throws RemoteException {
        LogManager.d(TAG, "API stopMonitoringBeaconsInRegion " + region, new Object[0]);
        if (!this.isBleAvailableOrSimulated()) {
            LogManager.w(TAG, "Method invocation will be ignored.", new Object[0]);
            return;
        }
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        if (!this.isScannerInDifferentProcess()) {
            MonitoringStatus.getInstanceForApplication(this.mContext).removeRegion(region);
        }
        this.applyChangesToServices(5, region);
        if (this.isScannerInDifferentProcess()) {
            MonitoringStatus.getInstanceForApplication(this.mContext).removeLocalRegion(region);
        }
        this.autoUnbindIfNeeded();
    }

    private void autoUnbindIfNeeded() {
        if (this.getMonitoredRegions().size() == 0 && this.getRangedRegions().size() == 0 && this.autoBindConsumer != null) {
            this.unbindInternal(this.autoBindConsumer);
            this.autoBindConsumer = null;
            this.autoBindRangedRegions.clear();
            this.autoBindMonitoredRegions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    public void stopMonitoring(@NonNull Region region) {
        LogManager.d(TAG, "API stopMonitoring " + region, new Object[0]);
        this.ensureBackgroundPowerSaver();
        if (this.isAnyConsumerBound()) {
            try {
                this.stopMonitoringBeaconsInRegion(region);
            }
            catch (RemoteException e) {
                LogManager.e(TAG, "Failed to stop monitoring", new Object[]{e});
            }
        } else {
            Set<Region> set = this.autoBindMonitoredRegions;
            synchronized (set) {
                this.autoBindMonitoredRegions.remove(region);
                MonitoringStatus.getInstanceForApplication(this.mContext).removeRegion(region);
            }
        }
    }

    @TargetApi(value=18)
    public void updateScanPeriods() throws RemoteException {
        LogManager.d(TAG, "API updateScanPeriods", new Object[0]);
        if (!this.isBleAvailableOrSimulated()) {
            LogManager.w(TAG, "Method invocation will be ignored.", new Object[0]);
            return;
        }
        if (this.determineIfCalledFromSeparateScannerProcess()) {
            return;
        }
        LogManager.d(TAG, "updating background flag to %s", this.mBackgroundMode);
        LogManager.d(TAG, "updating scan periods to %s, %s", this.getScanPeriod(), this.getBetweenScanPeriod());
        if (this.isAnyConsumerBound()) {
            this.applyChangesToServices(6, null);
        }
    }

    @TargetApi(value=18)
    private void applyChangesToServices(int type, Region region) throws RemoteException {
        if (!this.isAnyConsumerBound()) {
            LogManager.w(TAG, "The BeaconManager is not bound to the service.  Call beaconManager.bind(BeaconConsumer consumer) and wait for a callback to onBeaconServiceConnect()", new Object[0]);
            return;
        }
        if (this.mIntentScanStrategyCoordinator != null) {
            this.mIntentScanStrategyCoordinator.applySettings();
            return;
        }
        if (this.mScheduledScanJobsEnabled || this.mScheduledScanJobsEnabledByFallback) {
            if (Build.VERSION.SDK_INT >= 21) {
                ScanJobScheduler.getInstance().applySettingsToScheduledJob(this.mContext, this);
            }
            return;
        }
        Message msg = Message.obtain(null, (int)type, (int)0, (int)0);
        if (type == 6) {
            msg.setData(new StartRMData(this.getScanPeriod(), this.getBetweenScanPeriod(), this.mBackgroundMode).toBundle());
        } else if (type == 7) {
            msg.setData(new SettingsData().collect(this.mContext).toBundle());
        } else {
            msg.setData(new StartRMData(region, this.callbackPackageName(), this.getScanPeriod(), this.getBetweenScanPeriod(), this.mBackgroundMode).toBundle());
        }
        this.serviceMessenger.send(msg);
    }

    private String callbackPackageName() {
        String packageName = this.mContext.getPackageName();
        LogManager.d(TAG, "callback packageName: %s", packageName);
        return packageName;
    }

    @Deprecated
    @Nullable
    public MonitorNotifier getMonitoringNotifier() {
        Iterator<MonitorNotifier> iterator = this.monitorNotifiers.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @NonNull
    public Set<MonitorNotifier> getMonitoringNotifiers() {
        return Collections.unmodifiableSet(this.monitorNotifiers);
    }

    @Deprecated
    @Nullable
    public RangeNotifier getRangingNotifier() {
        Iterator<RangeNotifier> iterator = this.rangeNotifiers.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @NonNull
    public Set<RangeNotifier> getRangingNotifiers() {
        return Collections.unmodifiableSet(this.rangeNotifiers);
    }

    @NonNull
    public Collection<Region> getMonitoredRegions() {
        return MonitoringStatus.getInstanceForApplication(this.mContext).getActiveRegions();
    }

    @NonNull
    public Collection<Region> getRangedRegions() {
        return Collections.unmodifiableSet(this.rangedRegions);
    }

    @Deprecated
    public static void logDebug(String tag, String message) {
        LogManager.d(tag, message, new Object[0]);
    }

    @Deprecated
    public static void logDebug(String tag, String message, Throwable t) {
        LogManager.d(t, tag, message, new Object[0]);
    }

    public static String getDistanceModelUpdateUrl() {
        return distanceModelUpdateUrl;
    }

    public static void setDistanceModelUpdateUrl(@NonNull String url) {
        BeaconManager.warnIfScannerNotInSameProcess();
        distanceModelUpdateUrl = url;
    }

    public static void setRssiFilterImplClass(@NonNull Class c) {
        BeaconManager.warnIfScannerNotInSameProcess();
        rssiFilterImplClass = c;
    }

    public static Class getRssiFilterImplClass() {
        return rssiFilterImplClass;
    }

    public static void setUseTrackingCache(boolean useTrackingCache) {
        RangeState.setUseTrackingCache(useTrackingCache);
        if (sInstance != null) {
            sInstance.applySettings();
        }
    }

    public void setMaxTrackingAge(int maxTrackingAge) {
        LogManager.d(TAG, "API setMaxTrackingAge " + maxTrackingAge, new Object[0]);
        RangedBeacon.setMaxTrackinAge(maxTrackingAge);
    }

    public static void setBeaconSimulator(BeaconSimulator beaconSimulator) {
        LogManager.d(TAG, "API setBeaconSimulator " + beaconSimulator, new Object[0]);
        BeaconManager.warnIfScannerNotInSameProcess();
        BeaconManager.beaconSimulator = beaconSimulator;
    }

    @Nullable
    public static BeaconSimulator getBeaconSimulator() {
        return beaconSimulator;
    }

    protected void setDataRequestNotifier(@Nullable RangeNotifier notifier) {
        LogManager.d(TAG, "API setDataRequestNotifier " + notifier, new Object[0]);
        this.dataRequestNotifier = notifier;
    }

    @Nullable
    protected RangeNotifier getDataRequestNotifier() {
        return this.dataRequestNotifier;
    }

    @Nullable
    public NonBeaconLeScanCallback getNonBeaconLeScanCallback() {
        return this.mNonBeaconLeScanCallback;
    }

    public void setNonBeaconLeScanCallback(@Nullable NonBeaconLeScanCallback callback2) {
        LogManager.d(TAG, "API setNonBeaconLeScanCallback " + callback2, new Object[0]);
        this.mNonBeaconLeScanCallback = callback2;
    }

    private boolean isBleAvailableOrSimulated() {
        if (BeaconManager.getBeaconSimulator() != null) {
            return true;
        }
        return this.isBleAvailable();
    }

    private boolean isBleAvailable() {
        boolean available = false;
        if (Build.VERSION.SDK_INT < 18) {
            LogManager.w(TAG, "Bluetooth LE not supported prior to API 18.", new Object[0]);
        } else if (!this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            LogManager.w(TAG, "This device does not support bluetooth LE.", new Object[0]);
        } else {
            available = true;
        }
        return available;
    }

    private long getScanPeriod() {
        if (this.mBackgroundMode) {
            return this.backgroundScanPeriod;
        }
        return this.foregroundScanPeriod;
    }

    private long getBetweenScanPeriod() {
        if (this.mBackgroundMode) {
            return this.backgroundBetweenScanPeriod;
        }
        return this.foregroundBetweenScanPeriod;
    }

    private void verifyServiceDeclaration() {
        Intent intent;
        PackageManager packageManager = this.mContext.getPackageManager();
        List resolveInfo = packageManager.queryIntentServices(intent = new Intent(this.mContext, BeaconService.class), 65536);
        if (resolveInfo != null && resolveInfo.isEmpty()) {
            throw new ServiceNotDeclaredException();
        }
    }

    private void verifyLocationPermissionGrantedForForegroundService() {
        LogManager.d(TAG, "Running SDK 34? %b.  Targeting SDK 34? %b", Build.VERSION.SDK_INT >= 34, this.mContext.getApplicationInfo().targetSdkVersion >= 34);
        if (Build.VERSION.SDK_INT >= 34 && this.mContext.getApplicationInfo().targetSdkVersion >= 34) {
            LogManager.d(TAG, "Checking fine location permission as required for foreground service", new Object[0]);
            if (this.mContext.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0) {
                throw new SecurityException("Foreground service may not be enabled until after user grants Manifest.permission.ACCESS_FINE_LOCATION when target SdkVersion is set to SDK 34 or above.  See: https://altbeacon.github.io/android-beacon-library/foreground-service.html");
            }
        }
    }

    public static boolean isAndroidLScanningDisabled() {
        return sAndroidLScanningDisabled;
    }

    public static void setAndroidLScanningDisabled(boolean disabled) {
        LogManager.d(TAG, "API setAndroidLScanningDisabled " + disabled, new Object[0]);
        sAndroidLScanningDisabled = disabled;
        BeaconManager instance = sInstance;
        if (instance != null) {
            instance.applySettings();
        }
    }

    @Deprecated
    public static void setsManifestCheckingDisabled(boolean disabled) {
        sManifestCheckingDisabled = disabled;
    }

    public static void setManifestCheckingDisabled(boolean disabled) {
        LogManager.d(TAG, "API setManifestCheckingDisabled " + disabled, new Object[0]);
        sManifestCheckingDisabled = disabled;
    }

    public static boolean getManifestCheckingDisabled() {
        return sManifestCheckingDisabled;
    }

    public void enableForegroundServiceScanning(Notification notification, int notificationId) throws IllegalStateException {
        LogManager.d(TAG, "API enableForegroundServiceScanning " + notification, new Object[0]);
        if (this.isAnyConsumerBound()) {
            throw new IllegalStateException("May not be called after consumers are already bound.");
        }
        if (notification == null) {
            throw new NullPointerException("Notification cannot be null");
        }
        this.setEnableScheduledScanJobs(false);
        this.mForegroundServiceNotification = notification;
        this.mForegroundServiceNotificationId = notificationId;
    }

    public void retryForegroundServiceScanning() {
        if (this.foregroundServiceStartFailed()) {
            this.handleStategyFailover();
        }
    }

    public boolean foregroundServiceStartFailed() {
        return this.mScheduledScanJobsEnabledByFallback;
    }

    public void disableForegroundServiceScanning() throws IllegalStateException {
        LogManager.d(TAG, "API disableForegroundServiceScanning", new Object[0]);
        if (this.isAnyConsumerBound()) {
            throw new IllegalStateException("May not be called after consumers are already bound");
        }
        this.mForegroundServiceNotification = null;
        this.setScheduledScanJobsEnabledDefault();
    }

    public Notification getForegroundServiceNotification() {
        return this.mForegroundServiceNotification;
    }

    public int getForegroundServiceNotificationId() {
        return this.mForegroundServiceNotificationId;
    }

    private boolean determineIfCalledFromSeparateScannerProcess() {
        if (this.isScannerInDifferentProcess() && !this.isMainProcess()) {
            LogManager.w(TAG, "Ranging/Monitoring may not be controlled from a separate BeaconScanner process.  To remove this warning, please wrap this call in: if (beaconManager.isMainProcess())", new Object[0]);
            return true;
        }
        return false;
    }

    private static void warnIfScannerNotInSameProcess() {
        BeaconManager instance = sInstance;
        if (instance != null && instance.isScannerInDifferentProcess()) {
            LogManager.w(TAG, "Unsupported configuration change made for BeaconScanner in separate process", new Object[0]);
        }
    }

    private void setScheduledScanJobsEnabledDefault() {
        this.mScheduledScanJobsEnabled = Build.VERSION.SDK_INT >= 26;
    }

    public boolean isAutoBindActive() {
        return this.autoBindConsumer != null;
    }

    public boolean shutdownIfIdle() {
        if (this.autoBindConsumer != null && this.rangedRegions.size() == 0 && this.getMonitoredRegions().size() == 0 && this.autoBindConsumer != null) {
            this.unbindInternal(this.autoBindConsumer);
            this.autoBindConsumer = null;
            return true;
        }
        return false;
    }

    private void ensureBackgroundPowerSaver() {
        if (this.mInternalBackgroundPowerSaver == null) {
            this.mInternalBackgroundPowerSaver = new BackgroundPowerSaverInternal(this.mContext);
            this.mInternalBackgroundPowerSaver.enableDefaultBackgroundStateInference();
        }
    }

    private synchronized void autoBind() {
        if (this.autoBindConsumer == null) {
            this.autoBindConsumer = new BeaconConsumer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onBeaconServiceConnect() {
                    if (!BeaconManager.this.isBleAvailableOrSimulated()) {
                        LogManager.w(BeaconManager.TAG, "Method invocation will be ignored -- no BLE.", new Object[0]);
                        return;
                    }
                    Set<Region> set = BeaconManager.this.autoBindRangedRegions;
                    synchronized (set) {
                        for (Region region : BeaconManager.this.autoBindRangedRegions) {
                            try {
                                BeaconManager.this.startRangingBeaconsInRegion(region);
                            }
                            catch (RemoteException e) {
                                LogManager.e(BeaconManager.TAG, "Failed to start ranging", new Object[]{e});
                            }
                        }
                        BeaconManager.this.autoBindRangedRegions.clear();
                    }
                    set = BeaconManager.this.autoBindMonitoredRegions;
                    synchronized (set) {
                        for (Region region : BeaconManager.this.autoBindMonitoredRegions) {
                            try {
                                BeaconManager.this.startMonitoringBeaconsInRegion(region);
                            }
                            catch (RemoteException e) {
                                LogManager.e(BeaconManager.TAG, "Failed to start monitoring", new Object[]{e});
                            }
                        }
                        BeaconManager.this.autoBindMonitoredRegions.clear();
                    }
                }

                @Override
                public Context getApplicationContext() {
                    return BeaconManager.this.mContext;
                }

                @Override
                public void unbindService(ServiceConnection connection) {
                    BeaconManager.this.mContext.unbindService(connection);
                }

                @Override
                public boolean bindService(Intent intent, ServiceConnection connection, int mode) {
                    return BeaconManager.this.mContext.bindService(intent, connection, mode);
                }
            };
        }
        this.bindInternal(this.autoBindConsumer);
    }

    static {
        distanceModelUpdateUrl = "https://s3.amazonaws.com/android-beacon-library/android-distance.json";
        rssiFilterImplClass = RunningAverageRssiFilter.class;
    }

    private class ConsumerInfo {
        public boolean isConnected = false;
        @NonNull
        public BeaconServiceConnection beaconServiceConnection;

        public ConsumerInfo() {
            this.beaconServiceConnection = new BeaconServiceConnection();
        }
    }

    private class BeaconServiceConnection
    implements ServiceConnection {
        private BeaconServiceConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName className, IBinder service) {
            LogManager.d(BeaconManager.TAG, "we have a connection to the service now", new Object[0]);
            if (BeaconManager.this.mScannerInSameProcess == null) {
                BeaconManager.this.mScannerInSameProcess = false;
            }
            BeaconManager.this.serviceMessenger = new Messenger(service);
            BeaconManager.this.applySettings();
            ConcurrentMap<InternalBeaconConsumer, ConsumerInfo> concurrentMap = BeaconManager.this.consumers;
            synchronized (concurrentMap) {
                for (Map.Entry entry : BeaconManager.this.consumers.entrySet()) {
                    if (((ConsumerInfo)entry.getValue()).isConnected) continue;
                    ((InternalBeaconConsumer)entry.getKey()).onBeaconServiceConnect();
                    ((ConsumerInfo)entry.getValue()).isConnected = true;
                }
            }
        }

        public void onServiceDisconnected(ComponentName className) {
            LogManager.e(BeaconManager.TAG, "onServiceDisconnected", new Object[0]);
            BeaconManager.this.serviceMessenger = null;
        }
    }

    public class ServiceNotDeclaredException
    extends RuntimeException {
        public ServiceNotDeclaredException() {
            super("The BeaconService is not properly declared in AndroidManifest.xml.  If using Eclipse, please verify that your project.properties has manifestmerger.enabled=true");
        }
    }
}

