/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Build;
import androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.distance.ModelSpecificDistanceCalculator;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.BeaconService;
import org.altbeacon.beacon.service.ExtraDataBeaconTracker;
import org.altbeacon.beacon.service.ScanHelper;
import org.altbeacon.beacon.service.ScanJobScheduler;
import org.altbeacon.beacon.service.ScanState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 42\u00020\u0001:\u00014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020%J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020(H\u0002J\u000e\u0010*\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020\u0003J\u0018\u0010+\u001a\u00020%2\u000e\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010.0-H\u0007J\u0006\u0010/\u001a\u00020%J\b\u00100\u001a\u00020%H\u0007J\u0010\u00101\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020\u0003H\u0007J\b\u00102\u001a\u00020%H\u0007J\b\u00103\u001a\u00020%H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0018\"\u0004\b#\u0010\u001a\u00a8\u00065"}, d2={"Lorg/altbeacon/beacon/service/IntentScanStrategyCoordinator;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "disableOnFailure", "", "getDisableOnFailure", "()Z", "setDisableOnFailure", "(Z)V", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getExecutor", "()Ljava/util/concurrent/ExecutorService;", "initialized", "lastCycleEnd", "", "lastStrategyFailureDetectionCount", "", "getLastStrategyFailureDetectionCount", "()I", "setLastStrategyFailureDetectionCount", "(I)V", "longScanForcingEnabled", "scanHelper", "Lorg/altbeacon/beacon/service/ScanHelper;", "scanState", "Lorg/altbeacon/beacon/service/ScanState;", "started", "strategyFailureDetectionCount", "getStrategyFailureDetectionCount", "setStrategyFailureDetectionCount", "applySettings", "", "ensureInitialized", "getManifestMetadataValue", "", "key", "performPeriodicProcessing", "processScanResults", "scanResults", "Ljava/util/ArrayList;", "Landroid/bluetooth/le/ScanResult;", "reinitialize", "restartBackgroundScan", "runBackupScan", "start", "stop", "Companion", "android-beacon-library_release"})
public final class IntentScanStrategyCoordinator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    private ScanHelper scanHelper;
    private ScanState scanState;
    private boolean initialized;
    private boolean started;
    private boolean longScanForcingEnabled;
    private long lastCycleEnd;
    private int strategyFailureDetectionCount;
    private int lastStrategyFailureDetectionCount;
    private boolean disableOnFailure;
    private final ExecutorService executor;
    @NotNull
    private static final String TAG = "IntentScanCoord";

    public IntentScanStrategyCoordinator(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.executor = Executors.newFixedThreadPool(1);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public final int getStrategyFailureDetectionCount() {
        return this.strategyFailureDetectionCount;
    }

    public final void setStrategyFailureDetectionCount(int n) {
        this.strategyFailureDetectionCount = n;
    }

    public final int getLastStrategyFailureDetectionCount() {
        return this.lastStrategyFailureDetectionCount;
    }

    public final void setLastStrategyFailureDetectionCount(int n) {
        this.lastStrategyFailureDetectionCount = n;
    }

    public final boolean getDisableOnFailure() {
        return this.disableOnFailure;
    }

    public final void setDisableOnFailure(boolean bl) {
        this.disableOnFailure = bl;
    }

    public final ExecutorService getExecutor() {
        return this.executor;
    }

    public final void ensureInitialized() {
        if (!this.initialized) {
            this.initialized = true;
            this.scanHelper = new ScanHelper(this.context);
            if (Beacon.getDistanceCalculator() == null) {
                ModelSpecificDistanceCalculator defaultDistanceCalculator = new ModelSpecificDistanceCalculator(this.context, BeaconManager.getDistanceModelUpdateUrl());
                Beacon.setDistanceCalculator(defaultDistanceCalculator);
            }
            this.reinitialize();
        }
    }

    public final void reinitialize() {
        ScanState scanState;
        ScanState scanState2;
        ScanState scanState3;
        ScanState scanState4;
        ScanState scanState5;
        if (!this.initialized) {
            this.ensureInitialized();
            return;
        }
        ScanState newScanState = ScanState.restore(this.context);
        if (newScanState == null) {
            newScanState = new ScanState(this.context);
        }
        if ((scanState5 = (this.scanState = newScanState)) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanState");
            scanState5 = null;
        }
        scanState5.setLastScanStartTimeMillis(System.currentTimeMillis());
        ScanHelper scanHelper = this.scanHelper;
        if (scanHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
            scanHelper = null;
        }
        if ((scanState4 = this.scanState) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanState");
            scanState4 = null;
        }
        scanHelper.setMonitoringStatus(scanState4.getMonitoringStatus());
        ScanHelper scanHelper2 = this.scanHelper;
        if (scanHelper2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
            scanHelper2 = null;
        }
        if ((scanState3 = this.scanState) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanState");
            scanState3 = null;
        }
        scanHelper2.setRangedRegionState(scanState3.getRangedRegionState());
        ScanHelper scanHelper3 = this.scanHelper;
        if (scanHelper3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
            scanHelper3 = null;
        }
        if ((scanState2 = this.scanState) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanState");
            scanState2 = null;
        }
        scanHelper3.setBeaconParsers(scanState2.getBeaconParsers());
        ScanHelper scanHelper4 = this.scanHelper;
        if (scanHelper4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
            scanHelper4 = null;
        }
        if ((scanState = this.scanState) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanState");
            scanState = null;
        }
        scanHelper4.setExtraDataBeaconTracker(scanState.getExtraBeaconDataTracker());
    }

    public final void applySettings() {
        ScanState scanState = this.scanState;
        if (scanState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanState");
            scanState = null;
        }
        scanState.applyChanges(BeaconManager.getInstanceForApplication(this.context));
        this.reinitialize();
        if (Build.VERSION.SDK_INT >= 26) {
            this.restartBackgroundScan();
        }
    }

    @RequiresApi(value=26)
    public final void start() {
        ScanState scanState;
        ScanHelper scanHelper;
        ScanHelper scanHelper2;
        this.started = true;
        this.ensureInitialized();
        BeaconManager beaconManager = BeaconManager.getInstanceForApplication(this.context);
        Intrinsics.checkNotNullExpressionValue((Object)beaconManager, (String)"getInstanceForApplication(context)");
        BeaconManager beaconManager2 = beaconManager;
        ScanHelper scanHelper3 = this.scanHelper;
        if (scanHelper3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
            scanHelper3 = null;
        }
        scanHelper3.setExtraDataBeaconTracker(new ExtraDataBeaconTracker());
        beaconManager2.setScannerInSameProcess(true);
        String longScanForcingEnabledString = this.getManifestMetadataValue("longScanForcingEnabled");
        if (longScanForcingEnabledString != null && Intrinsics.areEqual((Object)longScanForcingEnabledString, (Object)"true")) {
            LogManager.i("BeaconService", "longScanForcingEnabled to keep scans going on Android N for > 30 minutes", new Object[0]);
            this.longScanForcingEnabled = true;
        }
        if ((scanHelper2 = this.scanHelper) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
            scanHelper2 = null;
        }
        scanHelper2.reloadParsers();
        LogManager.d(TAG, "starting background scan", new Object[0]);
        HashSet<Region> regions = new HashSet<Region>();
        HashSet<Region> wildcardRegions = new HashSet<Region>();
        for (Region region : beaconManager2.getRangedRegions()) {
            if (region.getIdentifiers().size() == 0) {
                wildcardRegions.add(region);
                continue;
            }
            regions.add(region);
        }
        for (Region region : beaconManager2.getMonitoredRegions()) {
            if (region.getIdentifiers().size() == 0) {
                wildcardRegions.add(region);
                continue;
            }
            regions.add(region);
        }
        if (wildcardRegions.size() > 0) {
            if (regions.size() > 0) {
                LogManager.w(TAG, "Wildcard regions are being used for beacon ranging or monitoring.  The wildcard regions are ignored with intent scan strategy active.", new Object[0]);
            } else {
                regions = wildcardRegions;
            }
        }
        if ((scanHelper = this.scanHelper) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
            scanHelper = null;
        }
        if ((scanState = this.scanState) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanState");
            scanState = null;
        }
        scanHelper.startAndroidOBackgroundScan(scanState.getBeaconParsers(), new ArrayList(regions));
        this.lastCycleEnd = System.currentTimeMillis();
        ScanJobScheduler.getInstance().scheduleForIntentScanStrategy(this.context);
    }

    private final String getManifestMetadataValue(String key) {
        Object value = null;
        try {
            ServiceInfo serviceInfo = this.context.getPackageManager().getServiceInfo(new ComponentName(this.context, BeaconService.class), 128);
            Intrinsics.checkNotNullExpressionValue((Object)serviceInfo, (String)"context.getPackageManage\u2026T_META_DATA\n            )");
            PackageItemInfo info = (PackageItemInfo)serviceInfo;
            if (info.metaData != null) {
                return String.valueOf(info.metaData.get(key));
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return null;
    }

    @RequiresApi(value=26)
    public final void stop() {
        this.ensureInitialized();
        LogManager.d(TAG, "stopping background scan", new Object[0]);
        ScanHelper scanHelper = this.scanHelper;
        if (scanHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
            scanHelper = null;
        }
        scanHelper.stopAndroidOBackgroundScan();
        ScanJobScheduler.getInstance().cancelSchedule(this.context);
        this.started = false;
    }

    @RequiresApi(value=26)
    public final void restartBackgroundScan() {
        ScanState scanState;
        this.ensureInitialized();
        LogManager.d(TAG, "restarting background scan", new Object[0]);
        ScanHelper scanHelper = this.scanHelper;
        if (scanHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
            scanHelper = null;
        }
        scanHelper.stopAndroidOBackgroundScan();
        ScanHelper scanHelper2 = this.scanHelper;
        if (scanHelper2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
            scanHelper2 = null;
        }
        if ((scanState = this.scanState) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanState");
            scanState = null;
        }
        scanHelper2.startAndroidOBackgroundScan(scanState.getBeaconParsers());
    }

    @RequiresApi(value=26)
    public final void processScanResults(@NotNull ArrayList<ScanResult> scanResults) {
        Intrinsics.checkNotNullParameter(scanResults, (String)"scanResults");
        this.ensureInitialized();
        for (ScanResult scanResult : scanResults) {
            if (scanResult == null) continue;
            ScanHelper scanHelper = this.scanHelper;
            if (scanHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
                scanHelper = null;
            }
            ScanRecord scanRecord = scanResult.getScanRecord();
            scanHelper.processScanResult(scanResult.getDevice(), scanResult.getRssi(), (byte[])(scanRecord != null ? scanRecord.getBytes() : null), scanResult.getTimestampNanos() / (long)1000);
        }
        long now = System.currentTimeMillis();
        BeaconManager beaconManager = BeaconManager.getInstanceForApplication(this.context);
        Intrinsics.checkNotNullExpressionValue((Object)beaconManager, (String)"getInstanceForApplication(context)");
        BeaconManager beaconManager2 = beaconManager;
        long scanPeriod = beaconManager2.getForegroundScanPeriod();
        if (beaconManager2.getBackgroundMode()) {
            scanPeriod = beaconManager2.getBackgroundScanPeriod();
        }
        if (now - this.lastCycleEnd > scanPeriod) {
            LogManager.d(TAG, "End of scan cycle", new Object[0]);
            this.lastCycleEnd = now;
            ScanHelper scanHelper = this.scanHelper;
            if (scanHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
                scanHelper = null;
            }
            scanHelper.getCycledLeScanCallback().onCycleEnd();
        }
    }

    public final void performPeriodicProcessing(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 26) {
            this.processScanResults(new ArrayList<ScanResult>());
            this.runBackupScan(context);
        }
    }

    @RequiresApi(value=21)
    public final void runBackupScan(@NotNull Context context) {
        boolean anythingDetectedWithIntentScan;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.started) {
            LogManager.i(TAG, "Not doing backup scan because we are not started", new Object[0]);
            return;
        }
        ScanHelper scanHelper = this.scanHelper;
        if (scanHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
            scanHelper = null;
        }
        if (anythingDetectedWithIntentScan = scanHelper.anyBeaconsDetectedThisCycle()) {
            LogManager.d(TAG, "We have detected beacons with the intent scan.  No need to do a backup scan.", new Object[0]);
            this.strategyFailureDetectionCount = 0;
            this.lastStrategyFailureDetectionCount = 0;
            return;
        }
        LogManager.i(TAG, "Starting backup scan on background thread", new Object[0]);
        this.executor.execute(() -> IntentScanStrategyCoordinator.runBackupScan$lambda$0(context, this));
    }

    private static final void runBackupScan$lambda$0(Context $context, IntentScanStrategyCoordinator this$0) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        LogManager.i(TAG, "Starting backup scan", new Object[0]);
        Object object = $context.getSystemService("bluetooth");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.bluetooth.BluetoothManager");
        BluetoothManager manager = (BluetoothManager)object;
        BluetoothAdapter adapter = manager.getAdapter();
        boolean beaconDetected = false;
        long scanStartTime = System.currentTimeMillis();
        if (adapter != null) {
            BluetoothLeScanner scanner = adapter.getBluetoothLeScanner();
            if (scanner != null) {
                ScanCallback callback2 = new ScanCallback(this$0, scanner){
                    final /* synthetic */ IntentScanStrategyCoordinator this$0;
                    final /* synthetic */ BluetoothLeScanner $scanner;
                    {
                        this.this$0 = $receiver;
                        this.$scanner = $scanner;
                    }

                    public void onScanResult(int callbackType, @NotNull ScanResult result) {
                        ScanRecord scanRecord;
                        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                        super.onScanResult(callbackType, result);
                        ScanHelper scanHelper = IntentScanStrategyCoordinator.access$getScanHelper$p(this.this$0);
                        if (scanHelper == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
                            scanHelper = null;
                        }
                        ScanRecord scanRecord2 = scanRecord = result.getScanRecord();
                        scanHelper.processScanResult(result.getDevice(), result.getRssi(), (byte[])(scanRecord2 != null ? scanRecord2.getBytes() : null), result.getTimestampNanos());
                        try {
                            this.$scanner.stopScan((ScanCallback)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }

                    public void onBatchScanResults(@NotNull List<ScanResult> results) {
                        Intrinsics.checkNotNullParameter(results, (String)"results");
                        super.onBatchScanResults(results);
                    }

                    public void onScanFailed(int errorCode) {
                        super.onScanFailed(errorCode);
                        LogManager.d(IntentScanStrategyCoordinator.Companion.getTAG(), "Sending onScanFailed event", new Object[0]);
                    }
                };
                try {
                    scanner.startScan(callback2);
                    while (true) {
                        LogManager.d(TAG, "Waiting for beacon detection...", new Object[0]);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (System.currentTimeMillis() - scanStartTime > 30000L) break;
                        ScanHelper scanHelper = this$0.scanHelper;
                        ScanHelper scanHelper2 = scanHelper;
                        if (scanHelper2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"scanHelper");
                            scanHelper2 = null;
                        }
                        if (!scanHelper2.anyBeaconsDetectedThisCycle()) continue;
                        if (this$0.strategyFailureDetectionCount == this$0.lastStrategyFailureDetectionCount) {
                            LogManager.e(TAG, "We have detected a beacon with the backup scan without a filter.  We never detected one with the intent scan with a filter.  This technique will not work.", new Object[0]);
                        }
                        this$0.lastStrategyFailureDetectionCount = this$0.strategyFailureDetectionCount;
                        int n = this$0.strategyFailureDetectionCount;
                        this$0.strategyFailureDetectionCount = n + 1;
                    }
                    LogManager.d(TAG, "Timeout running backup scan to look for beacons", new Object[0]);
                    scanner.stopScan(callback2);
                }
                catch (IllegalStateException e) {
                    LogManager.d(TAG, "Bluetooth is off.  Cannot run backup scan", new Object[0]);
                }
                catch (NullPointerException e) {
                    Object[] objectArray = new Object[]{e};
                    LogManager.e(TAG, "NullPointerException. Cannot run backup scan", objectArray);
                }
            } else {
                LogManager.d(TAG, "Cannot get scanner", new Object[0]);
            }
        }
        LogManager.d(TAG, "backup scan complete", new Object[0]);
        if (this$0.disableOnFailure && this$0.strategyFailureDetectionCount > 0) {
            BeaconManager.getInstanceForApplication($context).handleStategyFailover();
        }
        if (Build.VERSION.SDK_INT >= 26) {
            this$0.processScanResults(new ArrayList<ScanResult>());
        }
    }

    public static final /* synthetic */ ScanHelper access$getScanHelper$p(IntentScanStrategyCoordinator $this) {
        return $this.scanHelper;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/altbeacon/beacon/service/IntentScanStrategyCoordinator$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "android-beacon-library_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

