/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.logging.LogManager;

public class Callback
implements Serializable {
    private static final String TAG = "Callback";

    public Callback(String intentPackageName) {
    }

    public boolean call(Context context, String dataName, Bundle data) {
        boolean useLocalBroadcast = BeaconManager.getInstanceForApplication(context).getScheduledScanJobsEnabled();
        boolean success = false;
        if (useLocalBroadcast) {
            String action = null;
            action = dataName == "rangingData" ? "org.altbeacon.beacon.range_notification" : "org.altbeacon.beacon.monitor_notification";
            Intent intent = new Intent(action);
            intent.putExtra(dataName, data);
            LogManager.d(TAG, "attempting callback via local broadcast intent: %s", action);
            success = LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
        } else {
            Intent intent = new Intent();
            intent.setComponent(new ComponentName(context.getPackageName(), "org.altbeacon.beacon.BeaconIntentProcessor"));
            intent.putExtra(dataName, data);
            LogManager.d(TAG, "attempting callback via global broadcast intent: %s", intent.getComponent());
            try {
                context.startService(intent);
                success = true;
            }
            catch (Exception e) {
                LogManager.e(TAG, "Failed attempting to start service: " + intent.getComponent().flattenToString(), e);
            }
        }
        return success;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

