/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.bluetooth.le.ScanResult;
import android.content.ComponentName;
import android.content.Context;
import android.os.Build;
import android.os.PersistableBundle;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.List;
import org.altbeacon.beacon.BeaconLocalBroadcastProcessor;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.ScanJob;
import org.altbeacon.beacon.service.ScanState;

@RequiresApi(api=21)
public class ScanJobScheduler {
    private static final String TAG = ScanJobScheduler.class.getSimpleName();
    private static final Object SINGLETON_LOCK = new Object();
    private static final long MIN_MILLIS_BETWEEN_SCAN_JOB_SCHEDULING = 10000L;
    @Nullable
    private static volatile ScanJobScheduler sInstance = null;
    @NonNull
    private Long mScanJobScheduleTime = 0L;
    @NonNull
    private List<ScanResult> mBackgroundScanResultQueue = new ArrayList<ScanResult>();
    @Nullable
    private BeaconLocalBroadcastProcessor mBeaconNotificationProcessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ScanJobScheduler getInstance() {
        ScanJobScheduler instance = sInstance;
        if (instance == null) {
            Object object = SINGLETON_LOCK;
            synchronized (object) {
                instance = sInstance;
                if (instance == null) {
                    sInstance = instance = new ScanJobScheduler();
                }
            }
        }
        return instance;
    }

    private ScanJobScheduler() {
    }

    private void ensureNotificationProcessorSetup(Context context) {
        if (this.mBeaconNotificationProcessor == null) {
            this.mBeaconNotificationProcessor = new BeaconLocalBroadcastProcessor(context);
            this.mBeaconNotificationProcessor.register();
        }
    }

    List<ScanResult> dumpBackgroundScanResultQueue() {
        List<ScanResult> retval = this.mBackgroundScanResultQueue;
        this.mBackgroundScanResultQueue = new ArrayList<ScanResult>();
        return retval;
    }

    private void applySettingsToScheduledJob(Context context, BeaconManager beaconManager, ScanState scanState) {
        scanState.applyChanges(beaconManager);
        LogManager.d(TAG, "Applying scan job settings with background mode " + scanState.getBackgroundMode(), new Object[0]);
        this.schedule(context, scanState, false);
    }

    public void applySettingsToScheduledJob(Context context, BeaconManager beaconManager) {
        LogManager.d(TAG, "Applying settings to ScanJob", new Object[0]);
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        ScanState scanState = ScanState.restore(context);
        this.applySettingsToScheduledJob(context, beaconManager, scanState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAfterBackgroundWakeup(Context context, List<ScanResult> scanResults) {
        if (scanResults != null) {
            this.mBackgroundScanResultQueue.addAll(scanResults);
        }
        ScanJobScheduler scanJobScheduler = this;
        synchronized (scanJobScheduler) {
            if (System.currentTimeMillis() - this.mScanJobScheduleTime <= 10000L) {
                LogManager.d(TAG, "Not scheduling an immediate scan job because we just did recently.", new Object[0]);
                return;
            }
            LogManager.d(TAG, "scheduling an immediate scan job because last did " + (System.currentTimeMillis() - this.mScanJobScheduleTime) + "seconds ago.", new Object[0]);
            this.mScanJobScheduleTime = System.currentTimeMillis();
        }
        ScanState scanState = ScanState.restore(context);
        this.schedule(context, scanState, true);
    }

    private void schedule(Context context, ScanState scanState, boolean backgroundWakeup) {
        int error;
        long millisToNextJobStart;
        this.ensureNotificationProcessorSetup(context);
        long betweenScanPeriod = scanState.getScanJobIntervalMillis() - scanState.getScanJobRuntimeMillis();
        if (backgroundWakeup) {
            LogManager.d(TAG, "We just woke up in the background based on a new scan result.  Start scan job immediately.", new Object[0]);
            millisToNextJobStart = 0L;
        } else {
            millisToNextJobStart = betweenScanPeriod > 0L ? SystemClock.elapsedRealtime() % (long)scanState.getScanJobIntervalMillis() : 0L;
            if (millisToNextJobStart < 50L) {
                millisToNextJobStart = 50L;
            }
        }
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (backgroundWakeup || !scanState.getBackgroundMode().booleanValue()) {
            if (millisToNextJobStart < (long)(scanState.getScanJobIntervalMillis() - 50)) {
                LogManager.d(TAG, "Scheduling immediate ScanJob to run in " + millisToNextJobStart + " millis", new Object[0]);
                JobInfo immediateJob = new JobInfo.Builder(2, new ComponentName(context, ScanJob.class)).setPersisted(true).setExtras(new PersistableBundle()).setMinimumLatency(millisToNextJobStart).setOverrideDeadline(millisToNextJobStart).build();
                error = jobScheduler.schedule(immediateJob);
                if (error < 0) {
                    LogManager.e(TAG, "Failed to schedule scan job.  Beacons will not be detected. Error: " + error, new Object[0]);
                }
            }
        } else {
            LogManager.d(TAG, "Not scheduling an immediate scan because we are in background mode.   Cancelling existing immediate scan.", new Object[0]);
            jobScheduler.cancel(2);
        }
        JobInfo.Builder periodicJobBuilder = new JobInfo.Builder(1, new ComponentName(context, ScanJob.class)).setPersisted(true).setExtras(new PersistableBundle());
        if (Build.VERSION.SDK_INT >= 24) {
            periodicJobBuilder.setPeriodic((long)scanState.getScanJobIntervalMillis(), 0L).build();
        } else {
            periodicJobBuilder.setPeriodic((long)scanState.getScanJobIntervalMillis()).build();
        }
        LogManager.d(TAG, "Scheduling ScanJob to run every " + scanState.getScanJobIntervalMillis() + " millis", new Object[0]);
        error = jobScheduler.schedule(periodicJobBuilder.build());
        if (error < 0) {
            LogManager.e(TAG, "Failed to schedule scan job.  Beacons will not be detected. Error: " + error, new Object[0]);
        }
    }
}

