/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import java.util.List;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.distance.ModelSpecificDistanceCalculator;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.RegionMonitoringState;
import org.altbeacon.beacon.service.ScanHelper;
import org.altbeacon.beacon.service.ScanJobScheduler;
import org.altbeacon.beacon.service.ScanState;
import org.altbeacon.beacon.utils.ProcessUtils;

@TargetApi(value=21)
public class ScanJob
extends JobService {
    private static final String TAG = ScanJob.class.getSimpleName();
    public static final int PERIODIC_SCAN_JOB_ID = 1;
    public static final int IMMMEDIATE_SCAN_JOB_ID = 2;
    private ScanState mScanState;
    private Handler mStopHandler = new Handler();
    private ScanHelper mScanHelper;
    private boolean mInitialized = false;

    public boolean onStartJob(final JobParameters jobParameters) {
        boolean startedScan;
        this.mScanHelper = new ScanHelper((Context)this);
        if (jobParameters.getJobId() == 2) {
            LogManager.i(TAG, "Running immdiate scan job: instance is " + (Object)((Object)this), new Object[0]);
        } else {
            LogManager.i(TAG, "Running periodic scan job: instance is " + (Object)((Object)this), new Object[0]);
        }
        List<ScanResult> queuedScanResults = ScanJobScheduler.getInstance().dumpBackgroundScanResultQueue();
        LogManager.d(TAG, "Processing %d queued scan resuilts", queuedScanResults.size());
        for (ScanResult result : queuedScanResults) {
            ScanRecord scanRecord = result.getScanRecord();
            if (scanRecord == null) continue;
            this.mScanHelper.processScanResult(result.getDevice(), result.getRssi(), scanRecord.getBytes());
        }
        LogManager.d(TAG, "Done processing queued scan resuilts", new Object[0]);
        if (this.mInitialized) {
            LogManager.d(TAG, "Scanning already started.  Resetting for current parameters", new Object[0]);
            startedScan = this.restartScanning();
        } else {
            startedScan = this.startScanning();
        }
        this.mStopHandler.removeCallbacksAndMessages(null);
        if (startedScan) {
            LogManager.i(TAG, "Scan job running for " + this.mScanState.getScanJobRuntimeMillis() + " millis", new Object[0]);
            this.mStopHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    LogManager.i(TAG, "Scan job runtime expired", new Object[0]);
                    ScanJob.this.stopScanning();
                    ScanJob.this.mScanState.save();
                    ScanJob.this.startPassiveScanIfNeeded();
                    ScanJob.this.jobFinished(jobParameters, false);
                }
            }, (long)this.mScanState.getScanJobRuntimeMillis());
        } else {
            LogManager.i(TAG, "Scanning not started so Scan job is complete.", new Object[0]);
            this.jobFinished(jobParameters, false);
        }
        return true;
    }

    private void startPassiveScanIfNeeded() {
        LogManager.d(TAG, "Checking to see if we need to start a passive scan", new Object[0]);
        boolean insideAnyRegion = false;
        for (Region region : this.mScanState.getMonitoringStatus().regions()) {
            RegionMonitoringState state = this.mScanState.getMonitoringStatus().stateOf(region);
            if (state == null || !state.getInside()) continue;
            insideAnyRegion = true;
        }
        if (insideAnyRegion) {
            LogManager.i(TAG, "We are inside a beacon region.  We will not scan between cycles.", new Object[0]);
        } else if (Build.VERSION.SDK_INT >= 26) {
            this.mScanHelper.startAndroidOBackgroundScan(this.mScanState.getBeaconParsers());
        } else {
            LogManager.d(TAG, "This is not Android O.  No scanning between cycles when using ScanJob", new Object[0]);
        }
    }

    public boolean onStopJob(JobParameters params) {
        if (params.getJobId() == 1) {
            LogManager.i(TAG, "onStopJob called for periodic scan", new Object[0]);
        } else {
            LogManager.i(TAG, "onStopJob called for immediate scan", new Object[0]);
        }
        this.mStopHandler.removeCallbacksAndMessages(null);
        this.stopScanning();
        this.startPassiveScanIfNeeded();
        return false;
    }

    private void stopScanning() {
        this.mInitialized = false;
        this.mScanHelper.getCycledScanner().stop();
        this.mScanHelper.getCycledScanner().destroy();
        LogManager.d(TAG, "Scanning stopped", new Object[0]);
    }

    private boolean restartScanning() {
        this.mScanState = ScanState.restore((Context)this);
        this.mScanState.setLastScanStartTimeMillis(System.currentTimeMillis());
        this.mScanHelper.setMonitoringStatus(this.mScanState.getMonitoringStatus());
        this.mScanHelper.setRangedRegionState(this.mScanState.getRangedRegionState());
        this.mScanHelper.setBeaconParsers(this.mScanState.getBeaconParsers());
        this.mScanHelper.setExtraDataBeaconTracker(this.mScanState.getExtraBeaconDataTracker());
        if (this.mScanHelper.getCycledScanner() == null) {
            this.mScanHelper.createCycledLeScanner(this.mScanState.getBackgroundMode(), null);
        }
        if (Build.VERSION.SDK_INT >= 26) {
            this.mScanHelper.stopAndroidOBackgroundScan();
        }
        long scanPeriod = this.mScanState.getBackgroundMode() != false ? this.mScanState.getBackgroundScanPeriod() : this.mScanState.getForegroundScanPeriod();
        long betweenScanPeriod = this.mScanState.getBackgroundMode() != false ? this.mScanState.getBackgroundBetweenScanPeriod() : this.mScanState.getForegroundBetweenScanPeriod();
        this.mScanHelper.getCycledScanner().setScanPeriods(scanPeriod, betweenScanPeriod, this.mScanState.getBackgroundMode());
        this.mInitialized = true;
        if (scanPeriod <= 0L) {
            LogManager.w(TAG, "Starting scan with scan period of zero.  Exiting ScanJob.", new Object[0]);
            this.mScanHelper.getCycledScanner().stop();
            return false;
        }
        if (this.mScanHelper.getRangedRegionState().size() > 0 || this.mScanHelper.getMonitoringStatus().regions().size() > 0) {
            this.mScanHelper.getCycledScanner().start();
            return true;
        }
        this.mScanHelper.getCycledScanner().stop();
        return false;
    }

    private boolean startScanning() {
        BeaconManager beaconManager = BeaconManager.getInstanceForApplication(this.getApplicationContext());
        beaconManager.setScannerInSameProcess(true);
        if (beaconManager.isMainProcess()) {
            LogManager.i(TAG, "scanJob version %s is starting up on the main process", "2.12.2");
        } else {
            LogManager.i(TAG, "beaconScanJob library version %s is starting up on a separate process", "2.12.2");
            ProcessUtils processUtils = new ProcessUtils((Context)this);
            LogManager.i(TAG, "beaconScanJob PID is " + processUtils.getPid() + " with process name " + processUtils.getProcessName(), new Object[0]);
        }
        ModelSpecificDistanceCalculator defaultDistanceCalculator = new ModelSpecificDistanceCalculator((Context)this, BeaconManager.getDistanceModelUpdateUrl());
        Beacon.setDistanceCalculator(defaultDistanceCalculator);
        return this.restartScanning();
    }
}

