/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.altbeacon.beacon.logging.LogManager;

public class Callback
implements Serializable {
    private static final String TAG = "Callback";
    private transient Intent mIntent;
    private String mIntentPackageName;

    public Callback(String intentPackageName) {
        this.mIntentPackageName = intentPackageName;
        this.initializeIntent();
    }

    private void initializeIntent() {
        if (this.mIntentPackageName != null) {
            this.mIntent = new Intent();
            this.mIntent.setComponent(new ComponentName(this.mIntentPackageName, "org.altbeacon.beacon.BeaconIntentProcessor"));
        }
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    public boolean call(Context context, String dataName, Bundle data) {
        if (this.mIntent == null) {
            this.initializeIntent();
        }
        boolean success = false;
        if (this.mIntent != null) {
            LogManager.d(TAG, "attempting callback via intent: %s", this.mIntent.getComponent());
            this.mIntent.putExtra(dataName, data);
            try {
                context.startService(this.mIntent);
                success = true;
            }
            catch (Exception e) {
                LogManager.e(TAG, "Failed attempting to start service: " + this.mIntent.getComponent().flattenToString(), e);
            }
        }
        return success;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeIntent();
    }
}

