/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.content.Context;
import android.os.Build;
import android.os.ParcelUuid;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.logging.LogManager;

@TargetApi(value=21)
public class BeaconTransmitter {
    public static final int SUPPORTED = 0;
    public static final int NOT_SUPPORTED_MIN_SDK = 1;
    public static final int NOT_SUPPORTED_BLE = 2;
    @Deprecated
    public static final int NOT_SUPPORTED_MULTIPLE_ADVERTISEMENTS = 3;
    public static final int NOT_SUPPORTED_CANNOT_GET_ADVERTISER = 4;
    public static final int NOT_SUPPORTED_CANNOT_GET_ADVERTISER_MULTIPLE_ADVERTISEMENTS = 5;
    private static final String TAG = "BeaconTransmitter";
    private BluetoothAdapter mBluetoothAdapter;
    private BluetoothLeAdvertiser mBluetoothLeAdvertiser;
    private int mAdvertiseMode = 0;
    private int mAdvertiseTxPowerLevel = 3;
    private Beacon mBeacon;
    private BeaconParser mBeaconParser;
    private AdvertiseCallback mAdvertisingClientCallback;
    private boolean mStarted;
    private AdvertiseCallback mAdvertiseCallback;

    public BeaconTransmitter(Context context, BeaconParser parser) {
        this.mBeaconParser = parser;
        BluetoothManager bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
        if (bluetoothManager != null) {
            this.mBluetoothAdapter = bluetoothManager.getAdapter();
            this.mBluetoothLeAdvertiser = this.mBluetoothAdapter.getBluetoothLeAdvertiser();
            LogManager.d(TAG, "new BeaconTransmitter constructed.  mbluetoothLeAdvertiser is %s", this.mBluetoothLeAdvertiser);
        } else {
            LogManager.e(TAG, "Failed to get BluetoothManager", new Object[0]);
        }
    }

    public boolean isStarted() {
        return this.mStarted;
    }

    public void setBeacon(Beacon beacon) {
        this.mBeacon = beacon;
    }

    public void setBeaconParser(BeaconParser beaconParser) {
        this.mBeaconParser = beaconParser;
    }

    public int getAdvertiseMode() {
        return this.mAdvertiseMode;
    }

    public void setAdvertiseMode(int mAdvertiseMode) {
        this.mAdvertiseMode = mAdvertiseMode;
    }

    public int getAdvertiseTxPowerLevel() {
        return this.mAdvertiseTxPowerLevel;
    }

    public void setAdvertiseTxPowerLevel(int mAdvertiseTxPowerLevel) {
        this.mAdvertiseTxPowerLevel = mAdvertiseTxPowerLevel;
    }

    public void startAdvertising(Beacon beacon) {
        this.startAdvertising(beacon, null);
    }

    public void startAdvertising(Beacon beacon, AdvertiseCallback callback) {
        this.mBeacon = beacon;
        this.mAdvertisingClientCallback = callback;
        this.startAdvertising();
    }

    public void startAdvertising() {
        if (this.mBeacon == null) {
            throw new NullPointerException("Beacon cannot be null.  Set beacon before starting advertising");
        }
        int manufacturerCode = this.mBeacon.getManufacturer();
        int serviceUuid = this.mBeacon.getServiceUuid();
        if (this.mBeaconParser == null) {
            throw new NullPointerException("You must supply a BeaconParser instance to BeaconTransmitter.");
        }
        byte[] advertisingBytes = this.mBeaconParser.getBeaconAdvertisementData(this.mBeacon);
        String byteString = "";
        for (int i = 0; i < advertisingBytes.length; ++i) {
            byteString = byteString + String.format("%02X", advertisingBytes[i]);
            byteString = byteString + " ";
        }
        LogManager.d(TAG, "Starting advertising with ID1: %s ID2: %s ID3: %s and data: %s of size %s", this.mBeacon.getId1(), this.mBeacon.getIdentifiers().size() > 1 ? this.mBeacon.getId2() : "", this.mBeacon.getIdentifiers().size() > 2 ? this.mBeacon.getId3() : "", byteString, advertisingBytes.length);
        try {
            AdvertiseData.Builder dataBuilder = new AdvertiseData.Builder();
            if (serviceUuid > 0) {
                byte[] serviceUuidBytes = new byte[]{(byte)(serviceUuid >> 8 & 0xFF), (byte)(serviceUuid & 0xFF)};
                ParcelUuid parcelUuid = BeaconTransmitter.parseUuidFrom(serviceUuidBytes);
                dataBuilder.addServiceData(parcelUuid, advertisingBytes);
            } else {
                dataBuilder.addManufacturerData(manufacturerCode, advertisingBytes);
            }
            AdvertiseSettings.Builder settingsBuilder = new AdvertiseSettings.Builder();
            settingsBuilder.setAdvertiseMode(this.mAdvertiseMode);
            settingsBuilder.setTxPowerLevel(this.mAdvertiseTxPowerLevel);
            settingsBuilder.setConnectable(false);
            this.mBluetoothLeAdvertiser.startAdvertising(settingsBuilder.build(), dataBuilder.build(), this.getAdvertiseCallback());
            LogManager.d(TAG, "Started advertisement with callback: %s", this.getAdvertiseCallback());
        }
        catch (Exception e) {
            LogManager.e(e, TAG, "Cannot start advertising due to exception", new Object[0]);
        }
    }

    public void stopAdvertising() {
        if (!this.mStarted) {
            LogManager.d(TAG, "Skipping stop advertising -- not started", new Object[0]);
            return;
        }
        LogManager.d(TAG, "Stopping advertising with object %s", this.mBluetoothLeAdvertiser);
        this.mAdvertisingClientCallback = null;
        this.mBluetoothLeAdvertiser.stopAdvertising(this.getAdvertiseCallback());
        this.mStarted = false;
    }

    public static int checkTransmissionSupported(Context context) {
        int returnCode = 0;
        if (Build.VERSION.SDK_INT < 21) {
            returnCode = 1;
        } else if (!context.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            returnCode = 2;
        } else {
            try {
                if (((BluetoothManager)context.getSystemService("bluetooth")).getAdapter().getBluetoothLeAdvertiser() == null) {
                    returnCode = !((BluetoothManager)context.getSystemService("bluetooth")).getAdapter().isMultipleAdvertisementSupported() ? 5 : 4;
                }
            }
            catch (Exception e) {
                returnCode = 4;
            }
        }
        return returnCode;
    }

    private AdvertiseCallback getAdvertiseCallback() {
        if (this.mAdvertiseCallback == null) {
            this.mAdvertiseCallback = new AdvertiseCallback(){

                public void onStartFailure(int errorCode) {
                    LogManager.e(BeaconTransmitter.TAG, "Advertisement start failed, code: %s", errorCode);
                    if (BeaconTransmitter.this.mAdvertisingClientCallback != null) {
                        BeaconTransmitter.this.mAdvertisingClientCallback.onStartFailure(errorCode);
                    }
                }

                public void onStartSuccess(AdvertiseSettings settingsInEffect) {
                    LogManager.i(BeaconTransmitter.TAG, "Advertisement start succeeded.", new Object[0]);
                    BeaconTransmitter.this.mStarted = true;
                    if (BeaconTransmitter.this.mAdvertisingClientCallback != null) {
                        BeaconTransmitter.this.mAdvertisingClientCallback.onStartSuccess(settingsInEffect);
                    }
                }
            };
        }
        return this.mAdvertiseCallback;
    }

    private static ParcelUuid parseUuidFrom(byte[] uuidBytes) {
        long shortUuid;
        int UUID_BYTES_16_BIT = 2;
        int UUID_BYTES_32_BIT = 4;
        int UUID_BYTES_128_BIT = 16;
        ParcelUuid BASE_UUID = ParcelUuid.fromString((String)"00000000-0000-1000-8000-00805F9B34FB");
        if (uuidBytes == null) {
            throw new IllegalArgumentException("uuidBytes cannot be null");
        }
        int length = uuidBytes.length;
        if (length != 2 && length != 4 && length != 16) {
            throw new IllegalArgumentException("uuidBytes length invalid - " + length);
        }
        if (length == 16) {
            ByteBuffer buf = ByteBuffer.wrap(uuidBytes).order(ByteOrder.LITTLE_ENDIAN);
            long msb = buf.getLong(8);
            long lsb = buf.getLong(0);
            return new ParcelUuid(new UUID(msb, lsb));
        }
        if (length == 2) {
            shortUuid = uuidBytes[0] & 0xFF;
            shortUuid += (long)((uuidBytes[1] & 0xFF) << 8);
        } else {
            shortUuid = uuidBytes[0] & 0xFF;
            shortUuid += (long)((uuidBytes[1] & 0xFF) << 8);
            shortUuid += (long)((uuidBytes[2] & 0xFF) << 16);
            shortUuid += (long)((uuidBytes[3] & 0xFF) << 24);
        }
        long msb = BASE_UUID.getUuid().getMostSignificantBits() + (shortUuid << 32);
        long lsb = BASE_UUID.getUuid().getLeastSignificantBits();
        return new ParcelUuid(new UUID(msb, lsb));
    }
}

