/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.logging.LogManager;

public class RangedBeacon {
    private static final String TAG = "RangedBeacon";
    public static long DEFAULT_SAMPLE_EXPIRATION_MILLISECONDS;
    private static long sampleExpirationMilliseconds;
    private boolean mTracked = true;
    private ArrayList<Measurement> mMeasurements = new ArrayList();
    Beacon mBeacon;

    public RangedBeacon(Beacon beacon) {
        this.updateBeacon(beacon);
    }

    public void updateBeacon(Beacon beacon) {
        this.mBeacon = beacon;
        this.addMeasurement(this.mBeacon.getRssi());
    }

    public boolean isTracked() {
        return this.mTracked;
    }

    public void setTracked(boolean tracked) {
        this.mTracked = tracked;
    }

    public Beacon getBeacon() {
        return this.mBeacon;
    }

    public void commitMeasurements() {
        if (this.mMeasurements.size() > 0) {
            double runningAverage = this.calculateRunningAverage();
            this.mBeacon.setRunningAverageRssi(runningAverage);
            LogManager.d(TAG, "calculated new runningAverageRssi: %s", runningAverage);
        } else {
            LogManager.d(TAG, "No measurements available to calculate running average", new Object[0]);
        }
    }

    public static void setSampleExpirationMilliseconds(long milliseconds) {
        sampleExpirationMilliseconds = milliseconds;
    }

    public void addMeasurement(Integer rssi) {
        this.mTracked = true;
        Measurement measurement = new Measurement();
        measurement.rssi = rssi;
        measurement.timestamp = new Date().getTime();
        this.mMeasurements.add(measurement);
    }

    public boolean noMeasurementsAvailable() {
        return this.mMeasurements.size() == 0;
    }

    private synchronized void refreshMeasurements() {
        Date now = new Date();
        ArrayList<Measurement> newMeasurements = new ArrayList<Measurement>();
        for (Measurement measurement : this.mMeasurements) {
            if (now.getTime() - measurement.timestamp >= sampleExpirationMilliseconds) continue;
            newMeasurements.add(measurement);
        }
        this.mMeasurements = newMeasurements;
        Collections.sort(this.mMeasurements);
    }

    private double calculateRunningAverage() {
        this.refreshMeasurements();
        int size = this.mMeasurements.size();
        int startIndex = 0;
        int endIndex = size - 1;
        if (size > 2) {
            startIndex = size / 10 + 1;
            endIndex = size - size / 10 - 2;
        }
        double sum = 0.0;
        for (int i = startIndex; i <= endIndex; ++i) {
            sum += (double)this.mMeasurements.get((int)i).rssi.intValue();
        }
        double runningAverage = sum / (double)(endIndex - startIndex + 1);
        LogManager.d(TAG, "Running average mRssi based on %s measurements: %s", size, runningAverage);
        return runningAverage;
    }

    static {
        sampleExpirationMilliseconds = DEFAULT_SAMPLE_EXPIRATION_MILLISECONDS = 20000L;
    }

    private class Measurement
    implements Comparable<Measurement> {
        Integer rssi;
        long timestamp;

        private Measurement() {
        }

        @Override
        public int compareTo(Measurement arg0) {
            return this.rssi.compareTo(arg0.rssi);
        }
    }
}

