/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service.scanner;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import java.util.Date;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.service.scanner.CycledLeScanCallback;
import org.altbeacon.beacon.service.scanner.CycledLeScannerForJellyBeanMr2;
import org.altbeacon.beacon.service.scanner.CycledLeScannerForLollipop;
import org.altbeacon.beacon.startup.StartupBroadcastReceiver;
import org.altbeacon.bluetooth.BluetoothCrashResolver;

@TargetApi(value=18)
public abstract class CycledLeScanner {
    private static final String TAG = "CycledLeScanner";
    private BluetoothAdapter mBluetoothAdapter;
    private long mLastScanCycleStartTime = 0L;
    private long mLastScanCycleEndTime = 0L;
    protected long mNextScanCycleStartTime = 0L;
    private long mScanCycleStopTime = 0L;
    private boolean mScanning;
    protected boolean mScanningPaused;
    private boolean mScanCyclerStarted = false;
    private boolean mScanningEnabled = false;
    protected final Context mContext;
    private long mScanPeriod;
    protected long mBetweenScanPeriod;
    protected final Handler mHandler = new Handler();
    protected final BluetoothCrashResolver mBluetoothCrashResolver;
    protected final CycledLeScanCallback mCycledLeScanCallback;
    protected boolean mBackgroundFlag = false;
    protected boolean mRestartNeeded = false;
    private PendingIntent mWakeUpOperation = null;

    protected CycledLeScanner(Context context, long scanPeriod, long betweenScanPeriod, boolean backgroundFlag, CycledLeScanCallback cycledLeScanCallback, BluetoothCrashResolver crashResolver) {
        this.mScanPeriod = scanPeriod;
        this.mBetweenScanPeriod = betweenScanPeriod;
        this.mContext = context;
        this.mCycledLeScanCallback = cycledLeScanCallback;
        this.mBluetoothCrashResolver = crashResolver;
        this.mBackgroundFlag = backgroundFlag;
    }

    public static CycledLeScanner createScanner(Context context, long scanPeriod, long betweenScanPeriod, boolean backgroundFlag, CycledLeScanCallback cycledLeScanCallback, BluetoothCrashResolver crashResolver) {
        boolean useAndroidLScanner;
        if (Build.VERSION.SDK_INT < 18) {
            Log.w((String)TAG, (String)"Not supported prior to API 18.");
            return null;
        }
        if (Build.VERSION.SDK_INT < 21) {
            Log.i((String)TAG, (String)"This is not Android 5.0.  We are using old scanning APIs");
            useAndroidLScanner = false;
        } else if (BeaconManager.isAndroidLScanningDisabled()) {
            Log.i((String)TAG, (String)"This Android 5.0, but L scanning is disabled. We are using old scanning APIs");
            useAndroidLScanner = false;
        } else {
            Log.i((String)TAG, (String)"This Android 5.0.  We are using new scanning APIs");
            useAndroidLScanner = true;
        }
        if (useAndroidLScanner) {
            return new CycledLeScannerForLollipop(context, scanPeriod, betweenScanPeriod, backgroundFlag, cycledLeScanCallback, crashResolver);
        }
        return new CycledLeScannerForJellyBeanMr2(context, scanPeriod, betweenScanPeriod, backgroundFlag, cycledLeScanCallback, crashResolver);
    }

    public void setScanPeriods(long scanPeriod, long betweenScanPeriod, boolean backgroundFlag) {
        long proposedScanStopTime;
        long proposedNextScanStartTime;
        BeaconManager.logDebug(TAG, "Set scan periods called with " + scanPeriod + ", " + betweenScanPeriod + "  Background mode must have changed.");
        if (this.mBackgroundFlag != backgroundFlag) {
            this.mRestartNeeded = true;
        }
        this.mBackgroundFlag = backgroundFlag;
        this.mScanPeriod = scanPeriod;
        this.mBetweenScanPeriod = betweenScanPeriod;
        if (this.mBackgroundFlag) {
            BeaconManager.logDebug(TAG, "We are in the background.  Setting wakeup alarm");
            this.setWakeUpAlarm();
        } else {
            BeaconManager.logDebug(TAG, "We are not in the background.  Cancelling wakeup alarm");
            this.cancelWakeUpAlarm();
        }
        long now = new Date().getTime();
        if (this.mNextScanCycleStartTime > now && (proposedNextScanStartTime = this.mLastScanCycleEndTime + betweenScanPeriod) < this.mNextScanCycleStartTime) {
            this.mNextScanCycleStartTime = proposedNextScanStartTime;
            Log.i((String)TAG, (String)("Adjusted nextScanStartTime to be " + new Date(this.mNextScanCycleStartTime)));
        }
        if (this.mScanCycleStopTime > now && (proposedScanStopTime = this.mLastScanCycleStartTime + scanPeriod) < this.mScanCycleStopTime) {
            this.mScanCycleStopTime = proposedScanStopTime;
            Log.i((String)TAG, (String)("Adjusted scanStopTime to be " + new Date(this.mScanCycleStopTime)));
        }
    }

    public void start() {
        BeaconManager.logDebug(TAG, "start called");
        this.mScanningEnabled = true;
        if (!this.mScanCyclerStarted) {
            this.scanLeDevice(true);
        } else {
            BeaconManager.logDebug(TAG, "scanning already started");
        }
    }

    @SuppressLint(value={"NewApi"})
    public void stop() {
        BeaconManager.logDebug(TAG, "stop called");
        this.mScanningEnabled = false;
        if (this.mScanCyclerStarted) {
            this.scanLeDevice(false);
        }
        if (this.mBluetoothAdapter != null) {
            this.stopScan();
            this.mLastScanCycleEndTime = new Date().getTime();
        }
    }

    protected abstract void stopScan();

    protected abstract boolean deferScanIfNeeded();

    protected abstract void startScan();

    @SuppressLint(value={"NewApi"})
    protected void scanLeDevice(Boolean enable) {
        this.mScanCyclerStarted = true;
        if (this.getBluetoothAdapter() == null) {
            Log.e((String)TAG, (String)"No bluetooth adapter.  beaconService cannot scan.");
        }
        if (enable.booleanValue()) {
            block17: {
                if (this.deferScanIfNeeded()) {
                    return;
                }
                BeaconManager.logDebug(TAG, "starting a new scan cycle");
                if (!this.mScanning || this.mScanningPaused || this.mRestartNeeded) {
                    this.mScanning = true;
                    this.mScanningPaused = false;
                    try {
                        if (this.getBluetoothAdapter() == null) break block17;
                        if (this.getBluetoothAdapter().isEnabled()) {
                            if (this.mBluetoothCrashResolver != null && this.mBluetoothCrashResolver.isRecoveryInProgress()) {
                                Log.w((String)TAG, (String)"Skipping scan because crash recovery is in progress.");
                            } else if (this.mScanningEnabled) {
                                if (this.mRestartNeeded) {
                                    this.mRestartNeeded = false;
                                    BeaconManager.logDebug(TAG, "restarting a bluetooth le scan");
                                } else {
                                    BeaconManager.logDebug(TAG, "starting a new bluetooth le scan");
                                }
                                try {
                                    this.startScan();
                                }
                                catch (Exception e) {
                                    Log.w((String)"Internal Android exception scanning for beacons: ", (Throwable)e);
                                }
                            } else {
                                BeaconManager.logDebug(TAG, "Scanning unnecessary - no monitoring or ranging active.");
                            }
                            this.mLastScanCycleStartTime = new Date().getTime();
                            break block17;
                        }
                        Log.w((String)TAG, (String)"Bluetooth is disabled.  Cannot scan for beacons.");
                    }
                    catch (Exception e) {
                        Log.e((String)"TAG", (String)"Exception starting bluetooth scan.  Perhaps bluetooth is disabled or unavailable?", (Throwable)e);
                    }
                } else {
                    BeaconManager.logDebug(TAG, "We are already scanning");
                }
            }
            this.mScanCycleStopTime = new Date().getTime() + this.mScanPeriod;
            this.scheduleScanCycleStop();
            BeaconManager.logDebug(TAG, "Scan started");
        } else {
            BeaconManager.logDebug(TAG, "disabling scan");
            this.mScanning = false;
            this.stopScan();
            this.mLastScanCycleEndTime = new Date().getTime();
        }
    }

    protected void scheduleScanCycleStop() {
        long millisecondsUntilStop = this.mScanCycleStopTime - new Date().getTime();
        if (millisecondsUntilStop > 0L) {
            BeaconManager.logDebug(TAG, "Waiting to stop scan cycle for another " + millisecondsUntilStop + " milliseconds");
            if (this.mBackgroundFlag) {
                this.setWakeUpAlarm();
            }
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    CycledLeScanner.this.scheduleScanCycleStop();
                }
            }, millisecondsUntilStop > 1000L ? 1000L : millisecondsUntilStop);
        } else {
            this.finishScanCycle();
        }
    }

    protected abstract void finishScan();

    private void finishScanCycle() {
        BeaconManager.logDebug(TAG, "Done with scan cycle");
        this.mCycledLeScanCallback.onCycleEnd();
        if (this.mScanning) {
            if (this.getBluetoothAdapter() != null) {
                if (this.getBluetoothAdapter().isEnabled()) {
                    try {
                        BeaconManager.logDebug(TAG, "stopping bluetooth le scan");
                        this.finishScan();
                    }
                    catch (Exception e) {
                        Log.w((String)"Internal Android exception scanning for beacons: ", (Throwable)e);
                    }
                    this.mLastScanCycleEndTime = new Date().getTime();
                } else {
                    Log.w((String)TAG, (String)"Bluetooth is disabled.  Cannot scan for beacons.");
                }
            }
            this.mNextScanCycleStartTime = this.getNextScanStartTime();
            if (this.mScanningEnabled) {
                this.scanLeDevice(true);
            } else {
                BeaconManager.logDebug(TAG, "Scanning disabled.  No ranging or monitoring regions are active.");
                this.mScanCyclerStarted = false;
                this.cancelWakeUpAlarm();
            }
        }
    }

    protected BluetoothAdapter getBluetoothAdapter() {
        if (this.mBluetoothAdapter == null) {
            BluetoothManager bluetoothManager = (BluetoothManager)this.mContext.getApplicationContext().getSystemService("bluetooth");
            this.mBluetoothAdapter = bluetoothManager.getAdapter();
        }
        return this.mBluetoothAdapter;
    }

    protected void setWakeUpAlarm() {
        long milliseconds = 300000L;
        if (milliseconds < this.mBetweenScanPeriod) {
            milliseconds = this.mBetweenScanPeriod;
        }
        if (milliseconds < this.mScanPeriod) {
            milliseconds = this.mScanPeriod;
        }
        AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        Intent intent = new Intent();
        intent.setClassName(this.mContext, StartupBroadcastReceiver.class.getName());
        intent.putExtra("wakeup", true);
        this.cancelWakeUpAlarm();
        this.mWakeUpOperation = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0x10000000);
        alarmManager.set(2, System.currentTimeMillis() + milliseconds, this.mWakeUpOperation);
        BeaconManager.logDebug(TAG, "Set a wakeup alarm to go off in " + milliseconds + " ms: " + this.mWakeUpOperation);
    }

    protected void cancelWakeUpAlarm() {
        BeaconManager.logDebug(TAG, "cancel wakeup alarm: " + this.mWakeUpOperation);
        if (this.mWakeUpOperation != null) {
            AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
            alarmManager.cancel(this.mWakeUpOperation);
        }
    }

    private long getNextScanStartTime() {
        if (this.mBetweenScanPeriod == 0L) {
            return System.currentTimeMillis();
        }
        long fullScanCycle = this.mScanPeriod + this.mBetweenScanPeriod;
        long normalizedBetweenScanPeriod = this.mBetweenScanPeriod - System.currentTimeMillis() % fullScanCycle;
        BeaconManager.logDebug(TAG, "Normalizing between scan period from  " + this.mBetweenScanPeriod + " to " + normalizedBetweenScanPeriod);
        return System.currentTimeMillis() + normalizedBetweenScanPeriod;
    }
}

