/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.distance;

import android.util.Log;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.altbeacon.beacon.BeaconManager;

public class DistanceConfigFetcher {
    private static final String TAG = "DistanceConfigFetcher";
    protected String mResponse;
    protected Exception mException;
    private int mResponseCode = -1;
    private String mUrlString;
    private String mUserAgentString;

    public DistanceConfigFetcher(String urlString, String userAgentString) {
        this.mUrlString = urlString;
        this.mUserAgentString = userAgentString;
    }

    public int getResponseCode() {
        return this.mResponseCode;
    }

    public String getResponseString() {
        return this.mResponse;
    }

    public Exception getException() {
        return this.mException;
    }

    public void request() {
        this.mResponse = null;
        String currentUrlString = this.mUrlString;
        int requestCount = 0;
        StringBuilder responseBuilder = new StringBuilder();
        URLConnection conn = null;
        do {
            if (requestCount != 0) {
                if (BeaconManager.debug) {
                    Log.d((String)TAG, (String)("Following redirect from " + this.mUrlString + " to " + conn.getHeaderField("Location")));
                }
                currentUrlString = conn.getHeaderField("Location");
            }
            ++requestCount;
            this.mResponseCode = -1;
            URL url = null;
            try {
                url = new URL(currentUrlString);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Can't construct URL from: " + this.mUrlString));
                this.mException = e;
            }
            if (url == null) {
                if (!BeaconManager.debug) continue;
                Log.d((String)TAG, (String)"URL is null.  Cannot make request");
                continue;
            }
            try {
                conn = (HttpURLConnection)url.openConnection();
                conn.addRequestProperty("User-Agent", this.mUserAgentString);
                this.mResponseCode = ((HttpURLConnection)conn).getResponseCode();
                if (!BeaconManager.debug) continue;
                Log.d((String)TAG, (String)("response code is " + ((HttpURLConnection)conn).getResponseCode()));
            }
            catch (SecurityException e1) {
                Log.w((String)TAG, (String)"Can't reach sever.  Have you added android.permission.INTERNET to your manifest?", (Throwable)e1);
                this.mException = e1;
            }
            catch (FileNotFoundException e2) {
                Log.w((String)TAG, (String)"No data exists at \"+urlString", (Throwable)e2);
                this.mException = e2;
            }
            catch (IOException e3) {
                Log.w((String)TAG, (String)"Can't reach server", (Throwable)e3);
                this.mException = e3;
            }
        } while (requestCount < 10 && (this.mResponseCode == 302 || this.mResponseCode == 301 || this.mResponseCode == 303));
        if (this.mException == null) {
            try {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((inputLine = in.readLine()) != null) {
                    responseBuilder.append(inputLine);
                }
                in.close();
                this.mResponse = responseBuilder.toString();
            }
            catch (Exception e) {
                this.mException = e;
                Log.w((String)TAG, (String)"error reading beacon data", (Throwable)e);
            }
        }
    }
}

