/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.metrics;

import alluxio.ClientContext;
import alluxio.client.metrics.ClientMasterSync;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.master.MasterInquireClient;
import alluxio.util.IdUtils;
import alluxio.util.ThreadFactoryUtils;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MetricsHeartbeatContext {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsHeartbeatContext.class);
    private static final Map<MasterInquireClient.ConnectDetails, MetricsHeartbeatContext> MASTER_METRICS_HEARTBEAT = new ConcurrentHashMap<MasterInquireClient.ConnectDetails, MetricsHeartbeatContext>(2);
    private static boolean sAddedShudownHook = false;
    private static String sAppId = null;
    private static ScheduledExecutorService sExecutorService;
    private final MasterInquireClient.ConnectDetails mConnectDetails;
    private final ClientMasterSync mClientMasterSync;
    private final AlluxioConfiguration mConf;
    private int mCtxCount = 0;
    private ScheduledFuture<?> mMetricsMasterHeartbeatTask;

    private MetricsHeartbeatContext(ClientContext ctx, MasterInquireClient inquireClient) {
        this.mConnectDetails = inquireClient.getConnectDetails();
        this.mConf = ctx.getClusterConf();
        this.mClientMasterSync = new ClientMasterSync(sAppId, ctx, inquireClient);
    }

    private synchronized void addContext() {
        if (this.mCtxCount++ == 0) {
            this.mMetricsMasterHeartbeatTask = sExecutorService.scheduleWithFixedDelay(this.mClientMasterSync::heartbeat, this.mConf.getMs(PropertyKey.USER_METRICS_HEARTBEAT_INTERVAL_MS), this.mConf.getMs(PropertyKey.USER_METRICS_HEARTBEAT_INTERVAL_MS), TimeUnit.MILLISECONDS);
        }
    }

    private synchronized void heartbeat() {
        this.mClientMasterSync.heartbeat();
    }

    private synchronized void removeContext() {
        if (--this.mCtxCount <= 0) {
            this.close();
        }
    }

    private synchronized void close() {
        if (this.mMetricsMasterHeartbeatTask != null) {
            this.mMetricsMasterHeartbeatTask.cancel(false);
        }
        MASTER_METRICS_HEARTBEAT.remove(this.mConnectDetails);
        this.heartbeat();
        this.mClientMasterSync.close();
    }

    public static synchronized void addHeartbeat(ClientContext ctx, MasterInquireClient inquireClient) {
        Preconditions.checkNotNull((Object)ctx);
        Preconditions.checkNotNull((Object)inquireClient);
        if (sExecutorService == null) {
            sExecutorService = Executors.newSingleThreadScheduledExecutor(ThreadFactoryUtils.build((String)"metrics-master-heartbeat-%d", (boolean)true));
        }
        if (!sAddedShudownHook) {
            try {
                Runtime.getRuntime().addShutdownHook(new MetricsMasterSyncShutDownHook());
                sAddedShudownHook = true;
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SecurityException e) {
                LOG.info("Not registering metrics shutdown hook due to security exception. Regular heartbeats will still be performed to collect metrics data, but no final heartbeat will be performed on JVM exit. Security exception: {}", (Object)e.toString());
            }
        }
        if (sAppId == null) {
            sAppId = IdUtils.createOrGetAppIdFromConfig((AlluxioConfiguration)ctx.getClusterConf());
            LOG.info("Created metrics heartbeat with ID {}. This ID will be used for identifying info from the client. It can be set manually through the {} property", (Object)sAppId, (Object)"alluxio.user.app.id");
        }
        MetricsHeartbeatContext heartbeatCtx = MASTER_METRICS_HEARTBEAT.computeIfAbsent(inquireClient.getConnectDetails(), addr -> new MetricsHeartbeatContext(ctx, inquireClient));
        heartbeatCtx.addContext();
        LOG.debug("Registered metrics heartbeat with appId: {}", (Object)sAppId);
    }

    public static synchronized void removeHeartbeat(ClientContext ctx) {
        MasterInquireClient.ConnectDetails connectDetails = MasterInquireClient.Factory.getConnectDetails((AlluxioConfiguration)ctx.getClusterConf());
        MetricsHeartbeatContext heartbeatCtx = MASTER_METRICS_HEARTBEAT.get(connectDetails);
        if (heartbeatCtx != null) {
            heartbeatCtx.removeContext();
            LOG.debug("De-registered metrics heartbeat with appId: {}", (Object)sAppId);
        }
        if (MASTER_METRICS_HEARTBEAT.isEmpty()) {
            sExecutorService.shutdown();
            try {
                sExecutorService.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn("Metrics heartbeat executor did not shut down in a timely manner: {}", (Object)e.toString());
            }
            sExecutorService = null;
            sAppId = null;
        }
    }

    private static final class MetricsMasterSyncShutDownHook
    extends Thread {
        private final Thread mLastHeartbeatThread = new Thread(() -> {
            if (sExecutorService != null) {
                MASTER_METRICS_HEARTBEAT.forEach((key, value) -> ((MetricsHeartbeatContext)value).heartbeat());
            }
        });

        public MetricsMasterSyncShutDownHook() {
            this.mLastHeartbeatThread.setDaemon(true);
        }

        @Override
        public void run() {
            this.mLastHeartbeatThread.start();
            try {
                this.mLastHeartbeatThread.join(500L);
            }
            catch (InterruptedException e) {
                return;
            }
            finally {
                if (this.mLastHeartbeatThread.isAlive()) {
                    LOG.warn("Failed to heartbeat to the metrics master before exit");
                }
            }
        }
    }
}

