/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.meta;

import alluxio.AbstractMasterClient;
import alluxio.AlluxioURI;
import alluxio.client.meta.MetaMasterConfigClient;
import alluxio.conf.PropertyKey;
import alluxio.grpc.GetConfigHashPOptions;
import alluxio.grpc.GetConfigHashPResponse;
import alluxio.grpc.GetConfigurationPOptions;
import alluxio.grpc.GetConfigurationPResponse;
import alluxio.grpc.MetaMasterConfigurationServiceGrpc;
import alluxio.grpc.RemovePathConfigurationPRequest;
import alluxio.grpc.ServiceType;
import alluxio.grpc.SetPathConfigurationPRequest;
import alluxio.master.MasterClientContext;
import alluxio.wire.ConfigHash;
import alluxio.wire.Configuration;
import io.grpc.Channel;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RetryHandlingMetaMasterConfigClient
extends AbstractMasterClient
implements MetaMasterConfigClient {
    private MetaMasterConfigurationServiceGrpc.MetaMasterConfigurationServiceBlockingStub mClient = null;

    public RetryHandlingMetaMasterConfigClient(MasterClientContext conf) {
        super(conf);
    }

    protected ServiceType getRemoteServiceType() {
        return ServiceType.META_MASTER_CONFIG_SERVICE;
    }

    protected String getServiceName() {
        return "MetaMaster";
    }

    protected long getServiceVersion() {
        return 2L;
    }

    protected void afterConnect() {
        this.mClient = MetaMasterConfigurationServiceGrpc.newBlockingStub((Channel)this.mChannel);
    }

    @Override
    public Configuration getConfiguration(GetConfigurationPOptions options) throws IOException {
        return Configuration.fromProto((GetConfigurationPResponse)((GetConfigurationPResponse)this.retryRPC(() -> this.mClient.getConfiguration(options))));
    }

    @Override
    public ConfigHash getConfigHash() throws IOException {
        return ConfigHash.fromProto((GetConfigHashPResponse)((GetConfigHashPResponse)this.retryRPC(() -> this.mClient.getConfigHash(GetConfigHashPOptions.getDefaultInstance()))));
    }

    @Override
    public void setPathConfiguration(AlluxioURI path, Map<PropertyKey, String> properties) throws IOException {
        HashMap props = new HashMap();
        properties.forEach((key, value) -> props.put(key.getName(), value));
        this.retryRPC(() -> this.mClient.setPathConfiguration(SetPathConfigurationPRequest.newBuilder().setPath(path.getPath()).putAllProperties(props).build()));
    }

    @Override
    public void removePathConfiguration(AlluxioURI path, Set<PropertyKey> keys) throws IOException {
        HashSet<String> keySet = new HashSet<String>();
        for (PropertyKey key : keys) {
            keySet.add(key.getName());
        }
        this.retryRPC(() -> this.mClient.removePathConfiguration(RemovePathConfigurationPRequest.newBuilder().setPath(path.getPath()).addAllKeys((Iterable)keySet).build()));
    }

    @Override
    public void removePathConfiguration(AlluxioURI path) throws IOException {
        this.retryRPC(() -> this.mClient.removePathConfiguration(RemovePathConfigurationPRequest.newBuilder().setPath(path.getPath()).build()));
    }
}

