/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.options;

import alluxio.client.ReadType;
import alluxio.client.block.policy.BlockLocationPolicy;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.OpenFilePOptions;
import alluxio.master.block.BlockId;
import alluxio.proto.dataserver.Protocol;
import alluxio.util.FileSystemOptions;
import alluxio.wire.BlockInfo;
import alluxio.wire.FileBlockInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class InStreamOptions {
    private final URIStatus mStatus;
    private final OpenFilePOptions mProtoOptions;
    private BlockLocationPolicy mUfsReadLocationPolicy;
    private boolean mPositionShort;

    public InStreamOptions(URIStatus status, AlluxioConfiguration alluxioConf) {
        this(status, FileSystemOptions.openFileDefaults(alluxioConf), alluxioConf);
    }

    public InStreamOptions(URIStatus status, OpenFilePOptions options, AlluxioConfiguration alluxioConf) {
        OpenFilePOptions.Builder openOptionsBuilder = OpenFilePOptions.newBuilder().setReadType(((ReadType)alluxioConf.getEnum(PropertyKey.USER_FILE_READ_TYPE_DEFAULT, ReadType.class)).toProto()).setMaxUfsReadConcurrency(alluxioConf.getInt(PropertyKey.USER_UFS_BLOCK_READ_CONCURRENCY_MAX));
        OpenFilePOptions openOptions = openOptionsBuilder.mergeFrom(options).build();
        this.mStatus = status;
        this.mProtoOptions = openOptions;
        this.mUfsReadLocationPolicy = BlockLocationPolicy.Factory.create(alluxioConf.get(PropertyKey.USER_UFS_BLOCK_READ_LOCATION_POLICY), alluxioConf);
        this.mPositionShort = false;
    }

    public OpenFilePOptions getOptions() {
        return this.mProtoOptions;
    }

    @VisibleForTesting
    public void setUfsReadLocationPolicy(BlockLocationPolicy ufsReadLocationPolicy) {
        this.mUfsReadLocationPolicy = (BlockLocationPolicy)Preconditions.checkNotNull((Object)ufsReadLocationPolicy);
    }

    public void setPositionShort(boolean positionShort) {
        this.mPositionShort = positionShort;
    }

    public BlockLocationPolicy getUfsReadLocationPolicy() {
        return this.mUfsReadLocationPolicy;
    }

    public URIStatus getStatus() {
        return this.mStatus;
    }

    public boolean getPositionShort() {
        return this.mPositionShort;
    }

    public BlockInfo getBlockInfo(long blockId) {
        Preconditions.checkArgument((boolean)this.mStatus.getBlockIds().contains(blockId), (Object)"blockId");
        return this.mStatus.getFileBlockInfos().stream().map(FileBlockInfo::getBlockInfo).filter(blockInfo -> blockInfo.getBlockId() == blockId).findFirst().get();
    }

    public Protocol.OpenUfsBlockOptions getOpenUfsBlockOptions(long blockId) {
        Preconditions.checkArgument((boolean)this.mStatus.getBlockIds().contains(blockId), (Object)"blockId");
        boolean readFromUfs = this.mStatus.isPersisted();
        boolean storedAsUfsBlock = this.mStatus.getPersistenceState().equals("TO_BE_PERSISTED");
        boolean bl = readFromUfs = readFromUfs || storedAsUfsBlock;
        if (!readFromUfs) {
            return Protocol.OpenUfsBlockOptions.getDefaultInstance();
        }
        long blockStart = BlockId.getSequenceNumber((long)blockId) * this.mStatus.getBlockSizeBytes();
        BlockInfo info = this.getBlockInfo(blockId);
        Protocol.OpenUfsBlockOptions openUfsBlockOptions = Protocol.OpenUfsBlockOptions.newBuilder().setUfsPath(this.mStatus.getUfsPath()).setOffsetInFile(blockStart).setBlockSize(info.getLength()).setMaxUfsReadConcurrency(this.mProtoOptions.getMaxUfsReadConcurrency()).setNoCache(!ReadType.fromProto(this.mProtoOptions.getReadType()).isCache()).setMountId(this.mStatus.getMountId()).build();
        if (storedAsUfsBlock) {
            openUfsBlockOptions = openUfsBlockOptions.toBuilder().clearUfsPath().setBlockInUfsTier(true).setOffsetInFile(0L).build();
        }
        return openUfsBlockOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InStreamOptions)) {
            return false;
        }
        InStreamOptions that = (InStreamOptions)o;
        return Objects.equal((Object)this.mStatus, (Object)that.mStatus) && Objects.equal((Object)this.mProtoOptions, (Object)that.mProtoOptions) && Objects.equal((Object)this.mPositionShort, (Object)that.mPositionShort);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mStatus, this.mProtoOptions, this.mPositionShort});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("URIStatus", (Object)this.mStatus).add("OpenFileOptions", (Object)this.mProtoOptions).add("PositionShort", this.mPositionShort).toString();
    }
}

