/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.store;

import alluxio.client.file.cache.PageStore;
import alluxio.client.file.cache.store.LocalPageStoreOptions;
import alluxio.client.file.cache.store.PageStoreType;
import alluxio.client.file.cache.store.RocksPageStoreOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import java.nio.file.Path;

public abstract class PageStoreOptions {
    protected String mRootDir;
    protected long mPageSize;
    protected long mCacheSize;
    protected String mAlluxioVersion;

    public static PageStoreOptions create(AlluxioConfiguration conf) {
        PageStoreOptions options;
        PageStoreType storeType = (PageStoreType)conf.getEnum(PropertyKey.USER_CLIENT_CACHE_STORE_TYPE, PageStoreType.class);
        switch (storeType) {
            case LOCAL: {
                options = new LocalPageStoreOptions().setFileBuckets(conf.getInt(PropertyKey.USER_CLIENT_CACHE_LOCAL_STORE_FILE_BUCKETS));
                break;
            }
            case ROCKS: {
                options = new RocksPageStoreOptions();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unrecognized store type %s", storeType.name()));
            }
        }
        Path rootDir = PageStore.getStorePath(storeType, conf.get(PropertyKey.USER_CLIENT_CACHE_DIR));
        options.setRootDir(rootDir.toString());
        options.setPageSize(conf.getBytes(PropertyKey.USER_CLIENT_CACHE_PAGE_SIZE));
        options.setCacheSize(conf.getBytes(PropertyKey.USER_CLIENT_CACHE_SIZE));
        options.setAlluxioVersion(conf.get(PropertyKey.VERSION));
        return options;
    }

    public abstract PageStoreType getType();

    public <T> T toOptions() {
        return (T)this;
    }

    public void setRootDir(String rootDir) {
        this.mRootDir = rootDir;
    }

    public String getRootDir() {
        return this.mRootDir;
    }

    public long getPageSize() {
        return this.mPageSize;
    }

    public void setPageSize(long pageSize) {
        this.mPageSize = pageSize;
    }

    public long getCacheSize() {
        return this.mCacheSize;
    }

    public void setCacheSize(long cacheSize) {
        this.mCacheSize = cacheSize;
    }

    public String getAlluxioVersion() {
        return this.mAlluxioVersion;
    }

    public void setAlluxioVersion(String alluxioVersion) {
        this.mAlluxioVersion = alluxioVersion;
    }
}

