/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.evictor;

import alluxio.client.file.cache.CacheEvictor;
import alluxio.client.file.cache.PageId;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LRUCacheEvictor
implements CacheEvictor {
    private static final int LINKED_HASH_MAP_INIT_CAPACITY = 200;
    private static final float LINKED_HASH_MAP_INIT_LOAD_FACTOR = 0.75f;
    private static final boolean LINKED_HASH_MAP_ACCESS_ORDERED = true;
    private static final boolean UNUSED_MAP_VALUE = true;
    private final Map<PageId, Boolean> mLRUCache = Collections.synchronizedMap(new LinkedHashMap(200, 0.75f, true));

    @Override
    public void updateOnGet(PageId pageId) {
        this.mLRUCache.put(pageId, true);
    }

    @Override
    public void updateOnPut(PageId pageId) {
        this.mLRUCache.put(pageId, true);
    }

    @Override
    public void updateOnDelete(PageId pageId) {
        this.mLRUCache.remove(pageId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PageId evict() {
        Map<PageId, Boolean> map = this.mLRUCache;
        synchronized (map) {
            return this.mLRUCache.isEmpty() ? null : this.mLRUCache.keySet().iterator().next();
        }
    }

    @Override
    public void reset() {
        this.mLRUCache.clear();
    }
}

