/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.PageId;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PageInfo {
    private final PageId mPageId;
    private final long mPageSize;

    public PageInfo(PageId pageId, long pageSize) {
        this.mPageId = pageId;
        this.mPageSize = pageSize;
    }

    public PageId getPageId() {
        return this.mPageId;
    }

    public long getPageSize() {
        return this.mPageSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageInfo pageInfo = (PageInfo)o;
        return this.mPageSize == pageInfo.mPageSize && Objects.equals(this.mPageId, pageInfo.mPageId);
    }

    public int hashCode() {
        return Objects.hash(this.mPageId, this.mPageSize);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("PageId", (Object)this.mPageId).add("PageSize", this.mPageSize).toString();
    }
}

