/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.client.file.URIStatus;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MetadataCache {
    private final Cache<String, CachedItem> mCache;

    public MetadataCache(int maxSize, long expirationTimeMs) {
        this.mCache = CacheBuilder.newBuilder().maximumSize((long)maxSize).expireAfterWrite(expirationTimeMs, TimeUnit.MILLISECONDS).build();
    }

    @Nullable
    public URIStatus get(AlluxioURI path) {
        CachedItem item = (CachedItem)this.mCache.getIfPresent((Object)path.getPath());
        if (item != null && item.getStatus() != null) {
            return item.getStatus();
        }
        return null;
    }

    public void put(AlluxioURI path, URIStatus status) {
        this.mCache.put((Object)path.getPath(), (Object)new CachedItem(status));
    }

    public void put(String path, URIStatus status) {
        this.mCache.put((Object)path, (Object)new CachedItem(status));
    }

    public void put(AlluxioURI dir, List<URIStatus> statuses) {
        this.mCache.put((Object)dir.getPath(), (Object)new CachedItem(statuses));
        for (URIStatus status : statuses) {
            this.mCache.put((Object)status.getPath(), (Object)new CachedItem(status));
        }
    }

    @Nullable
    public List<URIStatus> listStatus(AlluxioURI dir) {
        CachedItem item = (CachedItem)this.mCache.getIfPresent((Object)dir.getPath());
        if (item != null && item.getDirStatuses() != null) {
            return item.getDirStatuses();
        }
        return null;
    }

    @VisibleForTesting
    public long size() {
        return this.mCache.size();
    }

    private class CachedItem {
        private final URIStatus mStatus;
        private final List<URIStatus> mDirStatuses;

        public CachedItem(URIStatus status) {
            this.mStatus = status;
            this.mDirStatuses = null;
        }

        public CachedItem(List<URIStatus> statuses) {
            this.mStatus = null;
            this.mDirStatuses = statuses;
        }

        @Nullable
        public URIStatus getStatus() {
            return this.mStatus;
        }

        @Nullable
        public List<URIStatus> getDirStatuses() {
            return this.mDirStatuses;
        }
    }
}

