/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.block.BlockMasterClientPool;
import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.stream.BlockWorkerClient;
import alluxio.client.block.stream.BlockWorkerClientPool;
import alluxio.client.file.FileSystemContextReinitializer;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.FileSystemMasterClientPool;
import alluxio.client.metrics.MetricsHeartbeatContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.path.SpecificPathConfiguration;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.GrpcServerAddress;
import alluxio.master.MasterClientContext;
import alluxio.master.MasterInquireClient;
import alluxio.metrics.MetricsSystem;
import alluxio.network.ChannelType;
import alluxio.refresh.RefreshPolicy;
import alluxio.refresh.TimeoutRefresh;
import alluxio.resource.CloseableResource;
import alluxio.resource.DynamicResourcePool;
import alluxio.security.authentication.AuthenticationUserUtils;
import alluxio.security.user.UserState;
import alluxio.util.IdUtils;
import alluxio.util.network.NettyUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.netty.channel.EventLoopGroup;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class FileSystemContext
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemContext.class);
    private final String mId;
    private AtomicBoolean mClosed = new AtomicBoolean(false);
    @GuardedBy(value="this")
    private boolean mMetricsEnabled;
    private volatile MasterClientContext mMasterClientContext;
    private volatile FileSystemMasterClientPool mFileSystemMasterClientPool;
    private volatile BlockMasterClientPool mBlockMasterClientPool;
    private final ConcurrentHashMap<ClientPoolKey, BlockWorkerClientPool> mBlockWorkerClientPool = new ConcurrentHashMap();
    private volatile EventLoopGroup mWorkerGroup;
    @GuardedBy(value="this")
    private boolean mLocalWorkerInitialized;
    @GuardedBy(value="this")
    private WorkerNetAddress mLocalWorker;
    private volatile FileSystemContextReinitializer mReinitializer;
    private boolean mUriValidationEnabled = true;
    @GuardedBy(value="this")
    private volatile List<BlockWorkerInfo> mWorkerInfoList = null;
    @GuardedBy(value="this")
    private final RefreshPolicy mWorkerRefreshPolicy;

    public static FileSystemContext create(AlluxioConfiguration conf) {
        Preconditions.checkNotNull((Object)conf);
        return FileSystemContext.create(null, conf);
    }

    public static FileSystemContext create(@Nullable Subject subject, @Nullable AlluxioConfiguration conf) {
        ClientContext ctx = ClientContext.create((Subject)subject, (AlluxioConfiguration)conf);
        MasterInquireClient inquireClient = MasterInquireClient.Factory.create((AlluxioConfiguration)ctx.getClusterConf(), (UserState)ctx.getUserState());
        FileSystemContext context = new FileSystemContext(ctx.getClusterConf());
        context.init(ctx, inquireClient);
        return context;
    }

    public static FileSystemContext create(ClientContext clientContext) {
        FileSystemContext ctx = new FileSystemContext(clientContext.getClusterConf());
        ctx.init(clientContext, MasterInquireClient.Factory.create((AlluxioConfiguration)clientContext.getClusterConf(), (UserState)clientContext.getUserState()));
        return ctx;
    }

    @VisibleForTesting
    public static FileSystemContext create(Subject subject, MasterInquireClient masterInquireClient, AlluxioConfiguration alluxioConf) {
        FileSystemContext context = new FileSystemContext(alluxioConf);
        ClientContext ctx = ClientContext.create((Subject)subject, (AlluxioConfiguration)alluxioConf);
        context.init(ctx, masterInquireClient);
        return context;
    }

    private FileSystemContext(AlluxioConfiguration conf) {
        this.mId = IdUtils.createFileSystemContextId();
        this.mWorkerRefreshPolicy = new TimeoutRefresh(conf.getMs(PropertyKey.USER_WORKER_LIST_REFRESH_INTERVAL));
    }

    private synchronized void init(ClientContext clientContext, MasterInquireClient masterInquireClient) {
        this.initContext(clientContext, masterInquireClient);
        this.mReinitializer = new FileSystemContextReinitializer(this);
    }

    private synchronized void initContext(ClientContext ctx, MasterInquireClient masterInquireClient) {
        this.mClosed.set(false);
        this.mMasterClientContext = MasterClientContext.newBuilder((ClientContext)ctx).setMasterInquireClient(masterInquireClient).build();
        this.mMetricsEnabled = this.getClusterConf().getBoolean(PropertyKey.USER_METRICS_COLLECTION_ENABLED);
        if (this.mMetricsEnabled) {
            MetricsSystem.startSinks((String)this.getClusterConf().get(PropertyKey.METRICS_CONF_FILE));
            MetricsHeartbeatContext.addHeartbeat(this.getClientContext(), masterInquireClient);
        }
        this.mFileSystemMasterClientPool = new FileSystemMasterClientPool(this.mMasterClientContext);
        this.mBlockMasterClientPool = new BlockMasterClientPool(this.mMasterClientContext);
        this.mWorkerGroup = NettyUtils.createEventLoop((ChannelType)NettyUtils.getUserChannel((AlluxioConfiguration)this.getClusterConf()), (int)this.getClusterConf().getInt(PropertyKey.USER_NETWORK_NETTY_WORKER_THREADS), (String)String.format("alluxio-client-nettyPool-%s-%%d", this.mId), (boolean)true);
        this.mUriValidationEnabled = ctx.getUriValidationEnabled();
    }

    @Override
    public synchronized void close() throws IOException {
        this.mReinitializer.close();
        this.closeContext();
    }

    private synchronized void closeContext() throws IOException {
        if (!this.mClosed.get()) {
            this.mClosed.set(true);
            this.mFileSystemMasterClientPool.close();
            this.mFileSystemMasterClientPool = null;
            this.mBlockMasterClientPool.close();
            this.mBlockMasterClientPool = null;
            for (BlockWorkerClientPool pool : this.mBlockWorkerClientPool.values()) {
                pool.close();
            }
            this.mWorkerGroup.shutdownGracefully(1L, 10L, TimeUnit.SECONDS);
            this.mBlockWorkerClientPool.clear();
            this.mLocalWorkerInitialized = false;
            this.mLocalWorker = null;
            if (this.mMetricsEnabled) {
                MetricsHeartbeatContext.removeHeartbeat(this.getClientContext());
            }
        } else {
            LOG.warn("Attempted to close FileSystemContext which has already been closed or not initialized.");
        }
    }

    public FileSystemContextReinitializer.ReinitBlockerResource blockReinit() {
        try {
            return this.mReinitializer.block();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void reinit(boolean updateClusterConf, boolean updatePathConf) throws UnavailableException, IOException {
        try (FileSystemContextReinitializer.ReinitAllowerResource r = this.mReinitializer.allow();){
            InetSocketAddress masterAddr;
            try {
                masterAddr = this.getMasterAddress();
            }
            catch (IOException e) {
                throw new UnavailableException("Failed to get master address during reinitialization", (Throwable)e);
            }
            try {
                this.getClientContext().loadConf(masterAddr, updateClusterConf, updatePathConf);
            }
            catch (AlluxioStatusException e) {
                throw new UnavailableException(String.format("Failed to load configuration from meta master (%s) during reinitialization", masterAddr), (Throwable)e);
            }
            this.closeContext();
            this.initContext(this.getClientContext(), MasterInquireClient.Factory.create((AlluxioConfiguration)this.getClusterConf(), (UserState)this.getClientContext().getUserState()));
            this.mReinitializer.onSuccess();
        }
    }

    public String getId() {
        return this.mId;
    }

    public MasterClientContext getMasterClientContext() {
        return this.mMasterClientContext;
    }

    public ClientContext getClientContext() {
        return this.mMasterClientContext;
    }

    public AlluxioConfiguration getClusterConf() {
        return this.getClientContext().getClusterConf();
    }

    public AlluxioConfiguration getPathConf(AlluxioURI path) {
        return new SpecificPathConfiguration(this.getClientContext().getClusterConf(), this.getClientContext().getPathConf(), path);
    }

    public synchronized InetSocketAddress getMasterAddress() throws UnavailableException {
        return this.mMasterClientContext.getMasterInquireClient().getPrimaryRpcAddress();
    }

    public synchronized boolean getUriValidationEnabled() {
        return this.mUriValidationEnabled;
    }

    public CloseableResource<FileSystemMasterClient> acquireMasterClientResource() {
        try (FileSystemContextReinitializer.ReinitBlockerResource r = this.blockReinit();){
            CloseableResource<FileSystemMasterClient> closeableResource = this.acquireClosableClientResource(this.mFileSystemMasterClientPool);
            return closeableResource;
        }
    }

    public CloseableResource<BlockMasterClient> acquireBlockMasterClientResource() {
        try (FileSystemContextReinitializer.ReinitBlockerResource r = this.blockReinit();){
            CloseableResource<BlockMasterClient> closeableResource = this.acquireClosableClientResource(this.mBlockMasterClientPool);
            return closeableResource;
        }
    }

    private <T> CloseableResource<T> acquireClosableClientResource(final DynamicResourcePool<T> pool) {
        try {
            return new CloseableResource<T>(pool.acquire()){

                public void close() {
                    pool.release(this.get());
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CloseableResource<BlockWorkerClient> acquireBlockWorkerClient(WorkerNetAddress workerNetAddress) throws IOException {
        try (FileSystemContextReinitializer.ReinitBlockerResource r = this.blockReinit();){
            CloseableResource<BlockWorkerClient> closeableResource = this.acquireBlockWorkerClientInternal(workerNetAddress, this.getClientContext());
            return closeableResource;
        }
    }

    private CloseableResource<BlockWorkerClient> acquireBlockWorkerClientInternal(final WorkerNetAddress workerNetAddress, final ClientContext context) throws IOException {
        SocketAddress address = NetworkAddressUtils.getDataPortSocketAddress((WorkerNetAddress)workerNetAddress, (AlluxioConfiguration)context.getClusterConf());
        GrpcServerAddress serverAddress = GrpcServerAddress.create((String)workerNetAddress.getHost(), (SocketAddress)address);
        ClientPoolKey key = new ClientPoolKey(address, AuthenticationUserUtils.getImpersonationUser((Subject)context.getSubject(), (AlluxioConfiguration)context.getClusterConf()));
        final ConcurrentHashMap<ClientPoolKey, BlockWorkerClientPool> poolMap = this.mBlockWorkerClientPool;
        return new CloseableResource<BlockWorkerClient>((BlockWorkerClient)poolMap.computeIfAbsent(key, k -> new BlockWorkerClientPool(context.getUserState(), serverAddress, context.getClusterConf().getInt(PropertyKey.USER_BLOCK_WORKER_CLIENT_POOL_SIZE), context.getClusterConf(), this.mWorkerGroup)).acquire()){

            public void close() {
                FileSystemContext.releaseBlockWorkerClient(workerNetAddress, (BlockWorkerClient)this.get(), context, poolMap);
            }
        };
    }

    private static void releaseBlockWorkerClient(WorkerNetAddress workerNetAddress, BlockWorkerClient client, ClientContext context, ConcurrentHashMap<ClientPoolKey, BlockWorkerClientPool> poolMap) {
        SocketAddress address = NetworkAddressUtils.getDataPortSocketAddress((WorkerNetAddress)workerNetAddress, (AlluxioConfiguration)context.getClusterConf());
        ClientPoolKey key = new ClientPoolKey(address, AuthenticationUserUtils.getImpersonationUser((Subject)context.getSubject(), (AlluxioConfiguration)context.getClusterConf()));
        if (poolMap.containsKey(key)) {
            poolMap.get(key).release(client);
        } else {
            LOG.warn("No client pool for key {}, closing client instead. Context may have been closed", (Object)key);
            try {
                client.close();
            }
            catch (IOException e) {
                LOG.warn("Error closing block worker client for key {}", (Object)key, (Object)e);
            }
        }
    }

    public synchronized boolean hasLocalWorker() throws IOException {
        if (!this.mLocalWorkerInitialized) {
            this.initializeLocalWorker();
        }
        return this.mLocalWorker != null;
    }

    public synchronized WorkerNetAddress getLocalWorker() throws IOException {
        if (!this.mLocalWorkerInitialized) {
            this.initializeLocalWorker();
        }
        return this.mLocalWorker;
    }

    public synchronized List<BlockWorkerInfo> getCachedWorkers() throws IOException {
        if (this.mWorkerInfoList == null || this.mWorkerRefreshPolicy.attempt()) {
            this.mWorkerInfoList = this.getAllWorkers();
        }
        return this.mWorkerInfoList;
    }

    private List<BlockWorkerInfo> getAllWorkers() throws IOException {
        try (CloseableResource<BlockMasterClient> masterClientResource = this.acquireBlockMasterClientResource();){
            List<BlockWorkerInfo> list = ((BlockMasterClient)masterClientResource.get()).getWorkerInfoList().stream().map(w -> new BlockWorkerInfo(w.getAddress(), w.getCapacityBytes(), w.getUsedBytes())).collect(Collectors.toList());
            return list;
        }
    }

    private void initializeLocalWorker() throws IOException {
        List<WorkerNetAddress> addresses = this.getWorkerAddresses();
        if (!addresses.isEmpty() && addresses.get(0).getHost().equals(NetworkAddressUtils.getClientHostName((AlluxioConfiguration)this.getClusterConf()))) {
            this.mLocalWorker = addresses.get(0);
        }
        this.mLocalWorkerInitialized = true;
    }

    private List<WorkerNetAddress> getWorkerAddresses() throws IOException {
        List<WorkerInfo> infos;
        BlockMasterClient blockMasterClient = (BlockMasterClient)this.mBlockMasterClientPool.acquire();
        try {
            infos = blockMasterClient.getWorkerInfoList();
        }
        finally {
            this.mBlockMasterClientPool.release(blockMasterClient);
        }
        if (infos.isEmpty()) {
            throw new UnavailableException(ExceptionMessage.NO_WORKER_AVAILABLE.getMessage(new Object[0]));
        }
        ArrayList<WorkerNetAddress> workerNetAddresses = new ArrayList<WorkerNetAddress>();
        ArrayList<WorkerNetAddress> localWorkerNetAddresses = new ArrayList<WorkerNetAddress>();
        String localHostname = NetworkAddressUtils.getClientHostName((AlluxioConfiguration)this.getClusterConf());
        for (WorkerInfo info : infos) {
            WorkerNetAddress netAddress = info.getAddress();
            if (netAddress.getHost().equals(localHostname)) {
                localWorkerNetAddresses.add(netAddress);
            }
            workerNetAddresses.add(netAddress);
        }
        return localWorkerNetAddresses.isEmpty() ? workerNetAddresses : localWorkerNetAddresses;
    }

    private static final class ClientPoolKey {
        private final SocketAddress mSocketAddress;
        private final String mUsername;

        public ClientPoolKey(SocketAddress socketAddress, String username) {
            this.mSocketAddress = socketAddress;
            this.mUsername = username;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mSocketAddress, this.mUsername});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClientPoolKey)) {
                return false;
            }
            ClientPoolKey that = (ClientPoolKey)o;
            return Objects.equal((Object)this.mSocketAddress, (Object)that.mSocketAddress) && Objects.equal((Object)this.mUsername, (Object)that.mUsername);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("socketAddress", (Object)this.mSocketAddress).add("username", (Object)this.mUsername).toString();
        }
    }
}

