/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.stream;

import alluxio.client.block.stream.BlockWorkerClient;
import alluxio.client.block.stream.StreamSerializationClientInterceptor;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.grpc.AsyncCacheRequest;
import alluxio.grpc.AsyncCacheResponse;
import alluxio.grpc.BlockWorkerGrpc;
import alluxio.grpc.ClearMetricsRequest;
import alluxio.grpc.ClearMetricsResponse;
import alluxio.grpc.CreateLocalBlockRequest;
import alluxio.grpc.CreateLocalBlockResponse;
import alluxio.grpc.DataMessageMarshaller;
import alluxio.grpc.DataMessageMarshallerProvider;
import alluxio.grpc.GrpcChannel;
import alluxio.grpc.GrpcChannelBuilder;
import alluxio.grpc.GrpcChannelKey;
import alluxio.grpc.GrpcSerializationUtils;
import alluxio.grpc.GrpcServerAddress;
import alluxio.grpc.MoveBlockRequest;
import alluxio.grpc.MoveBlockResponse;
import alluxio.grpc.OpenLocalBlockRequest;
import alluxio.grpc.OpenLocalBlockResponse;
import alluxio.grpc.ReadRequest;
import alluxio.grpc.ReadResponse;
import alluxio.grpc.RemoveBlockRequest;
import alluxio.grpc.RemoveBlockResponse;
import alluxio.grpc.WriteRequest;
import alluxio.grpc.WriteResponse;
import alluxio.retry.RetryPolicy;
import alluxio.retry.RetryUtils;
import alluxio.security.user.UserState;
import alluxio.util.network.NettyUtils;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.netty.channel.EventLoopGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBlockWorkerClient
implements BlockWorkerClient {
    private static final Logger LOG = LoggerFactory.getLogger((String)DefaultBlockWorkerClient.class.getName());
    private GrpcChannel mStreamingChannel;
    private GrpcChannel mRpcChannel;
    private GrpcServerAddress mAddress;
    private final long mDataTimeoutMs;
    private BlockWorkerGrpc.BlockWorkerStub mStreamingAsyncStub;
    private BlockWorkerGrpc.BlockWorkerBlockingStub mRpcBlockingStub;
    private BlockWorkerGrpc.BlockWorkerStub mRpcAsyncStub;

    public DefaultBlockWorkerClient(UserState userState, GrpcServerAddress address, AlluxioConfiguration alluxioConf, EventLoopGroup workerGroup) throws IOException {
        RetryPolicy retryPolicy = RetryUtils.defaultClientRetry((Duration)alluxioConf.getDuration(PropertyKey.USER_RPC_RETRY_MAX_DURATION), (Duration)alluxioConf.getDuration(PropertyKey.USER_RPC_RETRY_BASE_SLEEP_MS), (Duration)alluxioConf.getDuration(PropertyKey.USER_RPC_RETRY_MAX_SLEEP_MS));
        UnauthenticatedException lastException = null;
        while (retryPolicy.attempt()) {
            try {
                this.mStreamingChannel = this.buildChannel(userState.getSubject(), address, GrpcChannelKey.PoolingStrategy.DISABLED, alluxioConf, workerGroup);
                this.mStreamingChannel.intercept((ClientInterceptor)new StreamSerializationClientInterceptor());
                this.mRpcChannel = this.buildChannel(userState.getSubject(), address, GrpcChannelKey.PoolingStrategy.DEFAULT, alluxioConf, workerGroup);
                lastException = null;
                break;
            }
            catch (StatusRuntimeException e) {
                this.close();
                throw AlluxioStatusException.fromStatusRuntimeException((StatusRuntimeException)e);
            }
            catch (UnauthenticatedException e) {
                this.close();
                userState.relogin();
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        this.mStreamingAsyncStub = BlockWorkerGrpc.newStub((Channel)this.mStreamingChannel);
        this.mRpcBlockingStub = BlockWorkerGrpc.newBlockingStub((Channel)this.mRpcChannel);
        this.mRpcAsyncStub = BlockWorkerGrpc.newStub((Channel)this.mRpcChannel);
        this.mAddress = address;
        this.mDataTimeoutMs = alluxioConf.getMs(PropertyKey.USER_NETWORK_DATA_TIMEOUT_MS);
    }

    @Override
    public boolean isShutdown() {
        return this.mStreamingChannel.isShutdown() || this.mRpcChannel.isShutdown();
    }

    @Override
    public boolean isHealthy() {
        return !this.isShutdown() && this.mStreamingChannel.isHealthy() && this.mRpcChannel.isHealthy();
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = Closer.create();){
            closer.register(() -> {
                if (this.mStreamingChannel != null) {
                    this.mStreamingChannel.shutdown();
                }
            });
            closer.register(() -> {
                if (this.mRpcChannel != null) {
                    this.mRpcChannel.shutdown();
                }
            });
        }
    }

    @Override
    public StreamObserver<WriteRequest> writeBlock(StreamObserver<WriteResponse> responseObserver) {
        if (responseObserver instanceof DataMessageMarshallerProvider) {
            DataMessageMarshaller marshaller = ((DataMessageMarshallerProvider)responseObserver).getRequestMarshaller();
            Preconditions.checkNotNull((Object)marshaller, (Object)"marshaller");
            return ((BlockWorkerGrpc.BlockWorkerStub)this.mStreamingAsyncStub.withOption(GrpcSerializationUtils.OVERRIDDEN_METHOD_DESCRIPTOR, (Object)BlockWorkerGrpc.getWriteBlockMethod().toBuilder().setRequestMarshaller((MethodDescriptor.Marshaller)marshaller).build())).writeBlock(responseObserver);
        }
        return this.mStreamingAsyncStub.writeBlock(responseObserver);
    }

    @Override
    public StreamObserver<ReadRequest> readBlock(StreamObserver<ReadResponse> responseObserver) {
        if (responseObserver instanceof DataMessageMarshallerProvider) {
            DataMessageMarshaller marshaller = ((DataMessageMarshallerProvider)responseObserver).getResponseMarshaller();
            Preconditions.checkNotNull((Object)marshaller);
            return ((BlockWorkerGrpc.BlockWorkerStub)this.mStreamingAsyncStub.withOption(GrpcSerializationUtils.OVERRIDDEN_METHOD_DESCRIPTOR, (Object)BlockWorkerGrpc.getReadBlockMethod().toBuilder().setResponseMarshaller((MethodDescriptor.Marshaller)marshaller).build())).readBlock(responseObserver);
        }
        return this.mStreamingAsyncStub.readBlock(responseObserver);
    }

    @Override
    public StreamObserver<CreateLocalBlockRequest> createLocalBlock(StreamObserver<CreateLocalBlockResponse> responseObserver) {
        return this.mStreamingAsyncStub.createLocalBlock(responseObserver);
    }

    @Override
    public StreamObserver<OpenLocalBlockRequest> openLocalBlock(StreamObserver<OpenLocalBlockResponse> responseObserver) {
        return this.mStreamingAsyncStub.openLocalBlock(responseObserver);
    }

    @Override
    public RemoveBlockResponse removeBlock(RemoveBlockRequest request) {
        return ((BlockWorkerGrpc.BlockWorkerBlockingStub)this.mRpcBlockingStub.withDeadlineAfter(this.mDataTimeoutMs, TimeUnit.MILLISECONDS)).removeBlock(request);
    }

    @Override
    public MoveBlockResponse moveBlock(MoveBlockRequest request) {
        return ((BlockWorkerGrpc.BlockWorkerBlockingStub)this.mRpcBlockingStub.withDeadlineAfter(this.mDataTimeoutMs, TimeUnit.MILLISECONDS)).moveBlock(request);
    }

    @Override
    public ClearMetricsResponse clearMetrics(ClearMetricsRequest request) {
        return ((BlockWorkerGrpc.BlockWorkerBlockingStub)this.mRpcBlockingStub.withDeadlineAfter(this.mDataTimeoutMs, TimeUnit.MILLISECONDS)).clearMetrics(request);
    }

    @Override
    public void asyncCache(final AsyncCacheRequest request) {
        ((BlockWorkerGrpc.BlockWorkerStub)this.mRpcAsyncStub.withDeadlineAfter(this.mDataTimeoutMs, TimeUnit.MILLISECONDS)).asyncCache(request, (StreamObserver)new StreamObserver<AsyncCacheResponse>(){

            public void onNext(AsyncCacheResponse value) {
            }

            public void onError(Throwable t) {
                LOG.warn("Error sending async cache request {} to worker {}.", new Object[]{request, DefaultBlockWorkerClient.this.mAddress, t});
            }

            public void onCompleted() {
            }
        });
    }

    private GrpcChannel buildChannel(Subject subject, GrpcServerAddress address, GrpcChannelKey.PoolingStrategy poolingStrategy, AlluxioConfiguration alluxioConf, EventLoopGroup workerGroup) throws AlluxioStatusException {
        return GrpcChannelBuilder.newBuilder((GrpcServerAddress)address, (AlluxioConfiguration)alluxioConf).setSubject(subject).setChannelType(NettyUtils.getClientChannelClass((!(address.getSocketAddress() instanceof InetSocketAddress) ? 1 : 0) != 0, (AlluxioConfiguration)alluxioConf)).setPoolingStrategy(poolingStrategy).setEventLoopGroup(workerGroup).setKeepAliveTime(alluxioConf.getMs(PropertyKey.USER_NETWORK_KEEPALIVE_TIME_MS), TimeUnit.MILLISECONDS).setKeepAliveTimeout(alluxioConf.getMs(PropertyKey.USER_NETWORK_KEEPALIVE_TIMEOUT_MS), TimeUnit.MILLISECONDS).setMaxInboundMessageSize((int)alluxioConf.getBytes(PropertyKey.USER_NETWORK_MAX_INBOUND_MESSAGE_SIZE)).setFlowControlWindow((int)alluxioConf.getBytes(PropertyKey.USER_NETWORK_FLOWCONTROL_WINDOW)).setClientType("DefaultBlockWorkerClient").build();
    }
}

