/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.stream;

import alluxio.client.block.stream.BlockWorkerClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.GrpcServerAddress;
import alluxio.resource.DynamicResourcePool;
import alluxio.security.user.UserState;
import alluxio.util.ThreadFactoryUtils;
import io.netty.channel.EventLoopGroup;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class BlockWorkerClientPool
extends DynamicResourcePool<BlockWorkerClient> {
    private static final Logger LOG = LoggerFactory.getLogger(BlockWorkerClientPool.class);
    private final UserState mUserState;
    private final GrpcServerAddress mAddress;
    private static final int WORKER_CLIENT_POOL_GC_THREADPOOL_SIZE = 10;
    private static final ScheduledExecutorService GC_EXECUTOR = new ScheduledThreadPoolExecutor(10, ThreadFactoryUtils.build((String)"BlockWorkerClientPoolGcThreads-%d", (boolean)true));
    private final AlluxioConfiguration mConf;
    private final EventLoopGroup mWorkerGroup;

    public BlockWorkerClientPool(UserState userState, GrpcServerAddress address, int maxCapacity, AlluxioConfiguration alluxioConf, EventLoopGroup workerGroup) {
        super(DynamicResourcePool.Options.defaultOptions().setMaxCapacity(maxCapacity).setGcExecutor(GC_EXECUTOR));
        this.mUserState = userState;
        this.mAddress = address;
        this.mConf = alluxioConf;
        this.mWorkerGroup = workerGroup;
    }

    protected void closeResource(BlockWorkerClient client) throws IOException {
        LOG.info("Block worker client for {} closed.", (Object)this.mAddress);
        client.close();
    }

    protected BlockWorkerClient createNewResource() throws IOException {
        return BlockWorkerClient.Factory.create(this.mUserState, this.mAddress, this.mConf, this.mWorkerGroup);
    }

    protected boolean isHealthy(BlockWorkerClient client) {
        return client.isHealthy();
    }

    protected boolean shouldGc(DynamicResourcePool.ResourceInternal<BlockWorkerClient> clientResourceInternal) {
        return System.currentTimeMillis() - clientResourceInternal.getLastAccessTimeMs() > this.mConf.getMs(PropertyKey.USER_BLOCK_WORKER_CLIENT_POOL_GC_THRESHOLD_MS);
    }
}

