/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.policy;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.policy.BlockLocationPolicy;
import alluxio.client.block.policy.options.GetWorkerOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SpecificHostPolicy
implements BlockLocationPolicy {
    private final String mHostname;

    public SpecificHostPolicy(AlluxioConfiguration conf) {
        this(conf.get(PropertyKey.WORKER_HOSTNAME));
    }

    public SpecificHostPolicy(String hostname) {
        this.mHostname = (String)Preconditions.checkNotNull((Object)hostname, (Object)"hostname");
    }

    @Override
    public WorkerNetAddress getWorker(GetWorkerOptions options) {
        for (BlockWorkerInfo info : options.getBlockWorkerInfos()) {
            if (!info.getNetAddress().getHost().equals(this.mHostname)) continue;
            return info.getNetAddress();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpecificHostPolicy)) {
            return false;
        }
        SpecificHostPolicy that = (SpecificHostPolicy)o;
        return Objects.equal((Object)this.mHostname, (Object)that.mHostname);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mHostname});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hostname", (Object)this.mHostname).toString();
    }
}

