/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.policy;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.policy.BlockLocationPolicy;
import alluxio.client.block.policy.options.GetWorkerOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class RoundRobinPolicy
implements BlockLocationPolicy {
    private List<BlockWorkerInfo> mWorkerInfoList;
    private int mIndex;
    private boolean mInitialized = false;
    private final HashMap<Long, WorkerNetAddress> mBlockLocationCache = new HashMap();

    public RoundRobinPolicy(AlluxioConfiguration conf) {
    }

    @Override
    @Nullable
    public WorkerNetAddress getWorker(GetWorkerOptions options) {
        HashSet<WorkerNetAddress> eligibleAddresses = new HashSet<WorkerNetAddress>();
        for (BlockWorkerInfo info : options.getBlockWorkerInfos()) {
            eligibleAddresses.add(info.getNetAddress());
        }
        WorkerNetAddress address = this.mBlockLocationCache.get(options.getBlockInfo().getBlockId());
        if (address != null && eligibleAddresses.contains(address)) {
            return address;
        }
        address = null;
        if (!this.mInitialized) {
            this.mWorkerInfoList = Lists.newArrayList(options.getBlockWorkerInfos());
            Collections.shuffle(this.mWorkerInfoList);
            this.mIndex = 0;
            this.mInitialized = true;
        }
        for (int i = 0; i < this.mWorkerInfoList.size(); ++i) {
            WorkerNetAddress candidate = this.mWorkerInfoList.get(this.mIndex).getNetAddress();
            BlockWorkerInfo workerInfo = this.findBlockWorkerInfo(options.getBlockWorkerInfos(), candidate);
            this.mIndex = (this.mIndex + 1) % this.mWorkerInfoList.size();
            if (workerInfo == null || workerInfo.getCapacityBytes() < options.getBlockInfo().getLength() || !eligibleAddresses.contains(candidate)) continue;
            address = candidate;
            break;
        }
        this.mBlockLocationCache.put(options.getBlockInfo().getBlockId(), address);
        return address;
    }

    private BlockWorkerInfo findBlockWorkerInfo(Iterable<BlockWorkerInfo> workerInfoList, WorkerNetAddress address) {
        for (BlockWorkerInfo info : workerInfoList) {
            if (!info.getNetAddress().equals((Object)address)) continue;
            return info;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoundRobinPolicy)) {
            return false;
        }
        RoundRobinPolicy that = (RoundRobinPolicy)o;
        return Objects.equal(this.mWorkerInfoList, that.mWorkerInfoList) && Objects.equal((Object)this.mIndex, (Object)that.mIndex) && Objects.equal((Object)this.mInitialized, (Object)that.mInitialized) && Objects.equal(this.mBlockLocationCache, that.mBlockLocationCache);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mWorkerInfoList, this.mIndex, this.mInitialized, this.mBlockLocationCache});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("workerInfoList", this.mWorkerInfoList).add("index", this.mIndex).add("initialized", this.mInitialized).add("blockLocationCache", this.mBlockLocationCache).toString();
    }
}

