/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.options;

import alluxio.grpc.GetWorkerReportPOptions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class GetWorkerReportOptions
implements Serializable {
    private static final long serialVersionUID = -7604526631057562523L;
    private Set<String> mAddresses;
    private Set<WorkerInfoField> mFieldRange;
    private WorkerRange mWorkerRange;

    public static GetWorkerReportOptions defaults() {
        return new GetWorkerReportOptions();
    }

    private GetWorkerReportOptions() {
        this.mAddresses = new HashSet<String>();
        this.mFieldRange = new HashSet<WorkerInfoField>(Arrays.asList(WorkerInfoField.values()));
        this.mWorkerRange = WorkerRange.ALL;
    }

    public GetWorkerReportOptions(GetWorkerReportPOptions options) {
        this.mAddresses = new HashSet<String>((Collection<String>)options.getAddressesList());
        this.mFieldRange = new HashSet<WorkerInfoField>();
        for (alluxio.grpc.WorkerInfoField field : options.getFieldRangesList()) {
            this.mFieldRange.add(WorkerInfoField.fromProto(field));
        }
        this.mWorkerRange = WorkerRange.fromProto(options.getWorkerRange());
    }

    public Set<String> getAddresses() {
        return this.mAddresses;
    }

    public Set<WorkerInfoField> getFieldRange() {
        return this.mFieldRange;
    }

    public WorkerRange getWorkerRange() {
        return this.mWorkerRange;
    }

    public GetWorkerReportOptions setAddresses(Set<String> addresses) {
        this.mAddresses = addresses;
        return this;
    }

    public GetWorkerReportOptions setFieldRange(Set<WorkerInfoField> fieldRange) {
        this.mFieldRange = fieldRange;
        return this;
    }

    public GetWorkerReportOptions setWorkerRange(WorkerRange workerRange) {
        this.mWorkerRange = workerRange;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetWorkerReportOptions)) {
            return false;
        }
        GetWorkerReportOptions that = (GetWorkerReportOptions)o;
        return this.mAddresses.equals(that.mAddresses) && this.mFieldRange.equals(that.mFieldRange) && this.mWorkerRange.equals((Object)that.mWorkerRange);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mAddresses, this.mFieldRange, this.mWorkerRange});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("addresses", this.mAddresses).add("fieldRange", this.mFieldRange).add("workerRange", (Object)this.mWorkerRange).toString();
    }

    public GetWorkerReportPOptions toProto() {
        GetWorkerReportPOptions.Builder optionsBuilder = GetWorkerReportPOptions.newBuilder();
        optionsBuilder.addAllAddresses(this.mAddresses);
        if (this.mFieldRange != null) {
            HashSet<alluxio.grpc.WorkerInfoField> protoFieldRange = new HashSet<alluxio.grpc.WorkerInfoField>();
            for (WorkerInfoField field : this.mFieldRange) {
                protoFieldRange.add(field.toProto());
            }
            optionsBuilder.addAllFieldRanges(protoFieldRange);
        }
        optionsBuilder.setWorkerRange(this.mWorkerRange.toProto());
        return optionsBuilder.build();
    }

    public static enum WorkerInfoField {
        ADDRESS,
        WORKER_CAPACITY_BYTES,
        WORKER_CAPACITY_BYTES_ON_TIERS,
        ID,
        LAST_CONTACT_SEC,
        START_TIME_MS,
        STATE,
        WORKER_USED_BYTES,
        WORKER_USED_BYTES_ON_TIERS;


        public alluxio.grpc.WorkerInfoField toProto() {
            return alluxio.grpc.WorkerInfoField.valueOf((String)this.name());
        }

        public static WorkerInfoField fromProto(alluxio.grpc.WorkerInfoField fieldRange) {
            return WorkerInfoField.valueOf(fieldRange.name());
        }
    }

    public static enum WorkerRange {
        ALL,
        LIVE,
        LOST,
        SPECIFIED;


        public alluxio.grpc.WorkerRange toProto() {
            return alluxio.grpc.WorkerRange.valueOf((String)this.name());
        }

        public static WorkerRange fromProto(alluxio.grpc.WorkerRange workerRange) {
            return WorkerRange.valueOf(workerRange.name());
        }
    }
}

