/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.AbstractMasterClient;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.block.options.GetWorkerReportOptions;
import alluxio.grpc.BlockMasterClientServiceGrpc;
import alluxio.grpc.GetBlockInfoPRequest;
import alluxio.grpc.GetBlockMasterInfoPOptions;
import alluxio.grpc.GetCapacityBytesPOptions;
import alluxio.grpc.GetUsedBytesPOptions;
import alluxio.grpc.GetWorkerInfoListPOptions;
import alluxio.grpc.GetWorkerLostStoragePOptions;
import alluxio.grpc.GrpcUtils;
import alluxio.grpc.ServiceType;
import alluxio.grpc.WorkerInfo;
import alluxio.grpc.WorkerLostStorageInfo;
import alluxio.master.MasterClientContext;
import alluxio.wire.BlockInfo;
import alluxio.wire.BlockMasterInfo;
import io.grpc.Channel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RetryHandlingBlockMasterClient
extends AbstractMasterClient
implements BlockMasterClient {
    private BlockMasterClientServiceGrpc.BlockMasterClientServiceBlockingStub mClient = null;

    public RetryHandlingBlockMasterClient(MasterClientContext conf) {
        super(conf);
    }

    protected ServiceType getRemoteServiceType() {
        return ServiceType.BLOCK_MASTER_CLIENT_SERVICE;
    }

    protected String getServiceName() {
        return "BlockMasterClient";
    }

    protected long getServiceVersion() {
        return 2L;
    }

    protected void afterConnect() {
        this.mClient = BlockMasterClientServiceGrpc.newBlockingStub((Channel)this.mChannel);
    }

    @Override
    public List<alluxio.wire.WorkerInfo> getWorkerInfoList() throws IOException {
        return (List)this.retryRPC(() -> {
            ArrayList<alluxio.wire.WorkerInfo> result = new ArrayList<alluxio.wire.WorkerInfo>();
            for (WorkerInfo workerInfo : this.mClient.getWorkerInfoList(GetWorkerInfoListPOptions.getDefaultInstance()).getWorkerInfosList()) {
                result.add(GrpcUtils.fromProto((WorkerInfo)workerInfo));
            }
            return result;
        });
    }

    @Override
    public List<alluxio.wire.WorkerInfo> getWorkerReport(GetWorkerReportOptions options) throws IOException {
        return (List)this.retryRPC(() -> {
            ArrayList<alluxio.wire.WorkerInfo> result = new ArrayList<alluxio.wire.WorkerInfo>();
            for (WorkerInfo workerInfo : this.mClient.getWorkerReport(options.toProto()).getWorkerInfosList()) {
                result.add(GrpcUtils.fromProto((WorkerInfo)workerInfo));
            }
            return result;
        });
    }

    @Override
    public List<WorkerLostStorageInfo> getWorkerLostStorage() throws IOException {
        return (List)this.retryRPC(() -> this.mClient.getWorkerLostStorage(GetWorkerLostStoragePOptions.getDefaultInstance()).getWorkerLostStorageInfoList());
    }

    @Override
    public BlockInfo getBlockInfo(long blockId) throws IOException {
        return (BlockInfo)this.retryRPC(() -> GrpcUtils.fromProto((alluxio.grpc.BlockInfo)this.mClient.getBlockInfo(GetBlockInfoPRequest.newBuilder().setBlockId(blockId).build()).getBlockInfo()));
    }

    @Override
    public BlockMasterInfo getBlockMasterInfo(Set<BlockMasterInfo.BlockMasterInfoField> fields) throws IOException {
        return (BlockMasterInfo)this.retryRPC(() -> BlockMasterInfo.fromProto((alluxio.grpc.BlockMasterInfo)this.mClient.getBlockMasterInfo(GetBlockMasterInfoPOptions.newBuilder().addAllFilters((Iterable)fields.stream().map(BlockMasterInfo.BlockMasterInfoField::toProto).collect(Collectors.toList())).build()).getBlockMasterInfo()));
    }

    @Override
    public long getCapacityBytes() throws IOException {
        return (Long)this.retryRPC(() -> this.mClient.getCapacityBytes(GetCapacityBytesPOptions.getDefaultInstance()).getBytes());
    }

    @Override
    public long getUsedBytes() throws IOException {
        return (Long)this.retryRPC(() -> this.mClient.getUsedBytes(GetUsedBytesPOptions.getDefaultInstance()).getBytes());
    }
}

